/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

public class JRStringUtil {
    public static String xmlEncode(String text) {
        if (text != null) {
            StringBuffer ret = new StringBuffer();
            block6: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case '&': {
                        ret.append("&amp;");
                        continue block6;
                    }
                    case '>': {
                        ret.append("&gt;");
                        continue block6;
                    }
                    case '<': {
                        ret.append("&lt;");
                        continue block6;
                    }
                    case '\"': {
                        ret.append("&quot;");
                        continue block6;
                    }
                    default: {
                        ret.append(text.substring(i, i + 1));
                    }
                }
            }
            return ret.toString();
        }
        return null;
    }

    public static String htmlEncode(String text) {
        if (text != null) {
            StringBuffer ret = new StringBuffer();
            boolean isEncodeSpace = true;
            block8: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case ' ': {
                        if (isEncodeSpace) {
                            ret.append("&nbsp;");
                            isEncodeSpace = false;
                            continue block8;
                        }
                        ret.append(" ");
                        isEncodeSpace = true;
                        continue block8;
                    }
                    case '&': {
                        ret.append("&amp;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '>': {
                        ret.append("&gt;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '<': {
                        ret.append("&lt;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '\"': {
                        ret.append("&quot;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '\n': {
                        ret.append("<br>");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    default: {
                        ret.append(text.substring(i, i + 1));
                        isEncodeSpace = false;
                    }
                }
            }
            return ret.toString();
        }
        return null;
    }

    public static String getLiteral(String name) {
        if (JRStringUtil.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
        }
        return result;
    }

    public static String replaceDosEOL(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        int length = text.length();
        char[] chars = text.toCharArray();
        int r = 0;
        for (int i = 0; i < length; ++i) {
            char ch = chars[i];
            if (ch != '\r' || i + 1 >= length || chars[i + 1] != '\n') {
                if (r <= 0) continue;
                chars[i - r] = ch;
                continue;
            }
            ++r;
        }
        return r > 0 ? new String(chars, 0, length - r) : text;
    }
}

