/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.sdef.SDEFmethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SDEFWriter {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private PrintStream m_writer;
    private StringBuilder m_buffer;
    private Format m_formatter = new SimpleDateFormat("ddMMMyy");
    private double m_minutesPerDay;
    private double m_minutesPerWeek;
    private double m_daysPerMonth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ProjectFile projectFile, OutputStream outputStream) {
        this.m_projectFile = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_writer = new PrintStream(outputStream);
        this.m_buffer = new StringBuilder();
        try {
            this.write();
        }
        catch (Exception exception) {
            System.out.println("Caught Exception in SDEFWriter.java");
            System.out.println(" " + exception.toString());
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_buffer = null;
        }
    }

    private void write() throws IOException {
        this.writeFileCreationRecord();
        this.writeProjectProperties(this.m_projectFile.getProjectProperties());
        this.writeCalendars(this.m_projectFile.getCalendars());
        this.writeExceptions(this.m_projectFile.getCalendars());
        this.writeTasks(this.m_projectFile.getAllTasks());
        this.writePredecessors(this.m_projectFile.getAllTasks());
        this.writeProgress(this.m_projectFile.getAllTasks());
        this.m_writer.println("END");
    }

    private void writeFileCreationRecord() throws IOException {
        this.m_writer.println("VOLM 1");
    }

    private void writeProjectProperties(ProjectProperties projectProperties) throws IOException {
        this.m_minutesPerDay = projectProperties.getMinutesPerDay().doubleValue();
        this.m_minutesPerWeek = projectProperties.getMinutesPerWeek().doubleValue();
        this.m_daysPerMonth = projectProperties.getDaysPerMonth().doubleValue();
        this.m_buffer.setLength(0);
        this.m_buffer.append("PROJ ");
        this.m_buffer.append(this.m_formatter.format(projectProperties.getStartDate()).toUpperCase() + " ");
        this.m_buffer.append(SDEFmethods.lset(projectProperties.getManager(), 4) + " ");
        this.m_buffer.append(SDEFmethods.lset(projectProperties.getProjectTitle(), 48) + " ");
        this.m_buffer.append(SDEFmethods.lset(projectProperties.getSubject(), 36) + " ");
        this.m_buffer.append("P ");
        this.m_buffer.append(SDEFmethods.lset(projectProperties.getKeywords(), 7));
        this.m_buffer.append(this.m_formatter.format(projectProperties.getStartDate()).toUpperCase() + " ");
        this.m_buffer.append(this.m_formatter.format(projectProperties.getFinishDate()).toUpperCase());
        this.m_writer.println(this.m_buffer);
    }

    private void writeCalendars(List<ProjectCalendar> list) {
        for (ProjectCalendar projectCalendar : list) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("CLDR ");
            this.m_buffer.append(SDEFmethods.lset(projectCalendar.getUniqueID().toString(), 2));
            String string = SDEFmethods.workDays(projectCalendar);
            this.m_buffer.append(SDEFmethods.lset(string, 8));
            this.m_buffer.append(SDEFmethods.lset(projectCalendar.getName(), 30));
            this.m_writer.println(this.m_buffer);
        }
    }

    private void writeExceptions(List<ProjectCalendar> list) throws IOException {
        for (ProjectCalendar projectCalendar : list) {
            if (!projectCalendar.getCalendarExceptions().isEmpty()) {
                for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
                    this.writeCalendarException(projectCalendar, projectCalendarException);
                }
            }
            this.m_eventManager.fireCalendarWrittenEvent(projectCalendar);
        }
    }

    private void writeCalendarException(ProjectCalendar projectCalendar, ProjectCalendarException projectCalendarException) throws IOException {
        this.m_buffer.setLength(0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(projectCalendarException.getFromDate());
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(projectCalendarException.getToDate());
        this.m_buffer.append("HOLI ");
        this.m_buffer.append(SDEFmethods.lset(projectCalendar.getUniqueID().toString(), 2));
        while (calendar.compareTo(calendar2) <= 0) {
            this.m_buffer.append(this.m_formatter.format(calendar.getTime()).toUpperCase() + " ");
            calendar.add(5, 1);
        }
        this.m_writer.println(this.m_buffer.toString());
    }

    private void writeTask(Task task) throws IOException {
        this.m_buffer.setLength(0);
        if (!task.getSummary()) {
            this.m_buffer.append("ACTV ");
            this.m_buffer.append(SDEFmethods.rset(task.getUniqueID().toString(), 10) + " ");
            this.m_buffer.append(SDEFmethods.lset(task.getName(), 30) + " ");
            Duration duration = task.getDuration();
            double d = duration.getDuration();
            if (duration.getUnits() != TimeUnit.DAYS) {
                duration = Duration.convertUnits(d, duration.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            Double d2 = duration.getDuration() + 0.5;
            Integer n = d2.intValue();
            this.m_buffer.append(SDEFmethods.rset(n.toString(), 3) + " ");
            String string = "ES ";
            Date date = task.getEarlyStart();
            int n2 = task.getConstraintType().getValue();
            if (n2 == 1 || n2 == 3 || n2 == 6 || n2 == 7) {
                string = "LF ";
                date = task.getLateFinish();
            }
            this.m_buffer.append(this.m_formatter.format(date).toUpperCase() + " ");
            this.m_buffer.append(string);
            if (task.getCalendar() == null) {
                this.m_buffer.append("1 ");
            } else {
                this.m_buffer.append(SDEFmethods.lset(task.getCalendar().getUniqueID().toString(), 1) + " ");
            }
            this.m_writer.println(this.m_buffer.toString());
            this.m_eventManager.fireTaskWrittenEvent(task);
        }
    }

    private void writeTasks(List<Task> list) throws IOException {
        for (Task task : list) {
            this.writeTask(task);
        }
    }

    private void writePredecessors(List<Task> list) {
        for (Task task : list) {
            this.writeTaskPredecessors(task);
        }
    }

    private void writeTaskPredecessors(Task task) {
        this.m_buffer.setLength(0);
        if (!task.getSummary() && task.getPredecessors() != null) {
            this.m_buffer.append("PRED ");
            List<Relation> list = task.getPredecessors();
            for (Relation relation : list) {
                this.m_buffer.append(SDEFmethods.rset(relation.getSourceTask().getUniqueID().toString(), 10) + " ");
                this.m_buffer.append(SDEFmethods.rset(relation.getTargetTask().getUniqueID().toString(), 10) + " ");
                String string = "C";
                if (!relation.getType().toString().equals("FS")) {
                    string = relation.getType().toString().substring(0, 1);
                }
                this.m_buffer.append(string + " ");
                Duration duration = relation.getLag();
                double d = duration.getDuration();
                if (duration.getUnits() != TimeUnit.DAYS) {
                    duration = Duration.convertUnits(d, duration.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
                }
                Double d2 = duration.getDuration() + 0.5;
                Integer n = d2.intValue();
                this.m_buffer.append(SDEFmethods.rset(n.toString(), 4) + " ");
            }
            this.m_writer.println(this.m_buffer.toString());
        }
    }

    private void writePROG(Task task) {
        this.m_buffer.setLength(0);
        if (!task.getSummary()) {
            this.m_buffer.append("PROG ");
            this.m_buffer.append(SDEFmethods.rset(task.getUniqueID().toString(), 10) + " ");
            Date date = task.getActualStart();
            if (date == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(task.getActualStart()).toUpperCase() + " ");
            }
            date = task.getActualFinish();
            if (date == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(task.getActualFinish()).toUpperCase() + " ");
            }
            Duration duration = task.getRemainingDuration();
            double d = duration.getDuration();
            if (duration.getUnits() != TimeUnit.DAYS) {
                duration = Duration.convertUnits(d, duration.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            Double d2 = duration.getDuration() + 0.5;
            Integer n = d2.intValue();
            this.m_buffer.append(SDEFmethods.rset(n.toString(), 3) + " ");
            DecimalFormat decimalFormat = new DecimalFormat("#0.00");
            this.m_buffer.append(SDEFmethods.rset(decimalFormat.format(task.getCost().floatValue()), 12) + " ");
            this.m_buffer.append(SDEFmethods.rset(decimalFormat.format(0.0), 12) + " ");
            this.m_buffer.append(SDEFmethods.rset(decimalFormat.format(0.0), 12) + " ");
            this.m_buffer.append(this.m_formatter.format(task.getEarlyStart()).toUpperCase() + " ");
            this.m_buffer.append(this.m_formatter.format(task.getEarlyFinish()).toUpperCase() + " ");
            this.m_buffer.append(this.m_formatter.format(task.getLateStart()).toUpperCase() + " ");
            this.m_buffer.append(this.m_formatter.format(task.getLateFinish()).toUpperCase() + " ");
            duration = task.getTotalSlack();
            d = duration.getDuration();
            if (duration.getUnits() != TimeUnit.DAYS) {
                duration = Duration.convertUnits(d, duration.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            char c = (n = Integer.valueOf((d2 = Double.valueOf(duration.getDuration() + 0.5)).intValue())) >= 0 ? (char)'+' : '-';
            this.m_buffer.append(c + " ");
            n = Math.abs(d2.intValue());
            this.m_buffer.append(SDEFmethods.rset(n.toString(), 4));
            this.m_writer.println(this.m_buffer.toString());
            this.m_eventManager.fireTaskWrittenEvent(task);
        }
    }

    private void writeProgress(List<Task> list) {
        for (Task task : list) {
            this.writePROG(task);
        }
    }
}

