/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data.linker;

import com.projity.grouping.core.Node;
import com.projity.grouping.core.hierarchy.NodeHierarchy;
import com.projity.pm.assignment.Assignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Closure;

public abstract class Linker {
    protected Map transformationMap = new HashMap();
    protected Collection transformed = new ArrayList();
    protected Iterator iterator = null;
    protected Object parent;
    protected Object transformedParent;
    protected Object[] args = null;
    protected boolean incremental;

    public Map getTransformationMap() {
        return this.transformationMap;
    }

    public Collection getTransformed() {
        return this.transformed;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean bl) {
        this.incremental = bl;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getTransformedParent() {
        return this.transformedParent;
    }

    public void setTransformedParent(Object object) {
        this.transformedParent = object;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] objectArray) {
        this.args = objectArray;
    }

    public boolean hasNext() {
        return this.iterator == null ? false : this.iterator.hasNext();
    }

    public void addTransformedObjects() throws Exception {
        while (this.hasNext()) {
            Object object;
            Object object2 = this.executeNext();
            if (object2 == null || (object = this.addTransformedObjects(object2)) == null) continue;
            this.transformed.add(object);
        }
        this.executeFinally();
    }

    public void init() {
        this.transformationMap.clear();
        this.transformed.clear();
        this.initIterator();
    }

    public void addOutline(Node node) {
        final HashSet hashSet = new HashSet();
        this.getHierarchy().visitAll(node, true, new Closure(){

            public void execute(Object object) {
                Node node = (Node)object;
                Object object2 = node.getImpl();
                if (!(object2 instanceof Assignment)) {
                    if (node.isVoid()) {
                        hashSet.add(node);
                    } else {
                        hashSet.clear();
                    }
                }
            }
        });
        this.getHierarchy().visitAllLevelOrder(node, true, new Closure(){
            Node thisParent = null;
            long position = 0L;

            public void execute(Object object) {
                Node node = (Node)object;
                if (hashSet.contains(node)) {
                    return;
                }
                Object object2 = node.getImpl();
                if (!(object2 instanceof Assignment)) {
                    Node node2 = Linker.this.getHierarchy().getParent(node);
                    if (node2 != null && node2.isRoot()) {
                        node2 = null;
                    }
                    if (this.thisParent != node2) {
                        this.thisParent = node2;
                        this.position = 0L;
                    }
                    if (node.isVoid() || Linker.this.addOutlineElement(object2, this.thisParent == null ? null : this.thisParent.getImpl(), this.position)) {
                        ++this.position;
                    }
                }
            }
        });
    }

    protected void initIterator() {
    }

    public Object executeNext() {
        return null;
    }

    public void executeFinally() {
    }

    public abstract Object addTransformedObjects(Object var1) throws Exception;

    public NodeHierarchy getHierarchy() {
        return null;
    }

    public boolean addOutlineElement(Object object, Object object2, long l) {
        return true;
    }
}

