/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.datatype.Duration;
import com.projity.pm.assignment.Allocation;
import com.projity.pm.scheduling.SchedulingRule;
import com.projity.strings.Messages;
import com.projity.util.Alert;

public class FixedDuration
implements SchedulingRule {
    private static FixedDuration instance = null;

    public String toString() {
        return Messages.getString("FixedDuration.FixedDuration");
    }

    public void adjustRemainingUnits(Allocation allocation, double d, double d2, boolean bl, boolean bl2) {
        allocation.adjustRemainingUnits(d, d2, bl, bl2);
    }

    public void adjustRemainingDuration(Allocation allocation, long l, boolean bl) {
        allocation.adjustRemainingDuration(Duration.millis(l), bl);
    }

    public void adjustRemainingWork(Allocation allocation, long l, boolean bl) {
        long l2 = allocation.getRemainingWork();
        this.adjustRemainingWork(allocation, l, l2, bl);
    }

    public void adjustRemainingWork(Allocation allocation, long l, long l2, boolean bl) {
        l = Duration.millis(l);
        double d = allocation.getRemainingUnits();
        if (l2 == 0L) {
            allocation.adjustRemainingDuration((long)((double)l / d), bl);
            Alert.warn(Messages.getString("FixedDuration.TheDurationMessage"));
        } else {
            allocation.adjustRemainingUnits(d * (double)l / (double)l2, d, bl, false);
        }
    }

    private FixedDuration() {
    }

    public static FixedDuration getInstance() {
        if (instance == null) {
            instance = new FixedDuration();
        }
        return instance;
    }
}

