/*
 * Decompiled with CFR 0.152.
 */
package com.projity.algorithm;

import com.projity.algorithm.CalculationVisitor;
import com.projity.algorithm.DateInRangePredicate;
import com.projity.algorithm.IntervalGenerator;
import com.projity.algorithm.IntervalGeneratorSet;
import com.projity.algorithm.RangeIntervalGenerator;
import com.projity.pm.time.HasStartAndEnd;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.ChainedClosure;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.TruePredicate;

public class SelectFrom
implements HasStartAndEnd {
    long start;
    long end;
    boolean finished = false;
    private IntervalGenerator generator = null;
    boolean mustProcessAll = false;
    Closure fieldVisitors = null;
    CalculationVisitor[] fieldVisitorArray = null;
    Predicate wherePredicate = TruePredicate.INSTANCE;
    protected IntervalGeneratorSet fromGenerators = null;
    public static final SelectFrom[] NOTHING = new SelectFrom[0];

    public static LinkedList selectFromListInstance() {
        return new LinkedList();
    }

    public static LinkedList listInstance(SelectFrom selectFrom) {
        LinkedList<SelectFrom> linkedList = new LinkedList<SelectFrom>();
        linkedList.add(selectFrom);
        return linkedList;
    }

    public static LinkedList listInstance(SelectFrom selectFrom, SelectFrom selectFrom2) {
        LinkedList<SelectFrom> linkedList = new LinkedList<SelectFrom>();
        linkedList.add(selectFrom);
        linkedList.add(selectFrom2);
        return linkedList;
    }

    public static LinkedList listInstance(SelectFrom selectFrom, SelectFrom selectFrom2, SelectFrom selectFrom3) {
        LinkedList<SelectFrom> linkedList = new LinkedList<SelectFrom>();
        linkedList.add(selectFrom);
        linkedList.add(selectFrom2);
        linkedList.add(selectFrom3);
        return linkedList;
    }

    public static LinkedList listInstance(SelectFrom selectFrom, SelectFrom selectFrom2, SelectFrom selectFrom3, SelectFrom selectFrom4) {
        LinkedList<SelectFrom> linkedList = new LinkedList<SelectFrom>();
        linkedList.add(selectFrom);
        linkedList.add(selectFrom2);
        linkedList.add(selectFrom3);
        linkedList.add(selectFrom4);
        return linkedList;
    }

    public Collection getFromIntervalGenerators() {
        return this.fromGenerators.getGenerators();
    }

    public SelectFrom select(CalculationVisitor[] calculationVisitorArray) {
        this.fieldVisitorArray = calculationVisitorArray;
        this.fieldVisitors = new ChainedClosure(calculationVisitorArray);
        return this;
    }

    public SelectFrom select(CalculationVisitor calculationVisitor) {
        if (this.fieldVisitorArray != null) {
            CalculationVisitor[] calculationVisitorArray = new CalculationVisitor[this.fieldVisitorArray.length + 1];
            System.arraycopy(this.fieldVisitorArray, 0, calculationVisitorArray, 0, this.fieldVisitorArray.length);
            calculationVisitorArray[this.fieldVisitorArray.length] = calculationVisitor;
            return this.select(calculationVisitorArray);
        }
        this.fieldVisitorArray = new CalculationVisitor[]{calculationVisitor};
        this.fieldVisitors = calculationVisitor;
        return this;
    }

    public SelectFrom all() {
        this.mustProcessAll = true;
        return this;
    }

    public SelectFrom from(LinkedList linkedList) {
        if (this.fromGenerators == null) {
            this.fromGenerators = IntervalGeneratorSet.getInstance(linkedList);
        } else {
            this.fromGenerators.getGenerators().addAll(linkedList);
        }
        return this;
    }

    public SelectFrom from(IntervalGenerator intervalGenerator) {
        if (this.fromGenerators == null) {
            this.fromGenerators = IntervalGeneratorSet.getInstance(intervalGenerator);
        } else {
            this.fromGenerators.getGenerators().add(intervalGenerator);
        }
        return this;
    }

    public SelectFrom where(Predicate predicate) {
        this.wherePredicate = predicate;
        return this;
    }

    public SelectFrom whereInRange(long l, long l2) {
        if (l <= l2) {
            if (this.wherePredicate != null && this.wherePredicate instanceof DateInRangePredicate) {
                DateInRangePredicate dateInRangePredicate = (DateInRangePredicate)this.wherePredicate;
                dateInRangePredicate.limitTo(l, l2);
                l = dateInRangePredicate.getStart();
                l2 = dateInRangePredicate.getEnd();
            } else {
                this.wherePredicate = DateInRangePredicate.getInstance(l, l2);
            }
            this.from(RangeIntervalGenerator.betweenInstance(l, l2));
        } else {
            this.wherePredicate = FalsePredicate.INSTANCE;
        }
        return this;
    }

    public void initializeCalculations() {
        if (this.fieldVisitorArray == null) {
            return;
        }
        for (int i = 0; i < this.fieldVisitorArray.length; ++i) {
            this.fieldVisitorArray[i].initialize();
        }
    }

    public void resetCalculations() {
        if (this.fieldVisitorArray == null) {
            return;
        }
        for (int i = 0; i < this.fieldVisitorArray.length; ++i) {
            this.fieldVisitorArray[i].reset();
        }
    }

    public boolean calculate(long l, long l2) {
        if (this.finished) {
            this.resetCalculations();
            return false;
        }
        while (true) {
            if (this.generator == null) {
                this.generator = this.fromGenerators.earliestEndingGenerator();
            }
            if (this.generator == null) {
                this.finished = true;
                break;
            }
            this.start = Math.max(this.start, this.generator.currentStart());
            this.end = Math.min(l2, this.generator.currentEnd());
            if (this.end >= this.start) {
                boolean bl = this.wherePredicate.evaluate(this);
                if (this.fieldVisitors != null) {
                    for (int i = 0; i < this.fieldVisitorArray.length; ++i) {
                        if (!bl && !this.fieldVisitorArray[i].isCumulative()) continue;
                        this.fieldVisitorArray[i].execute(this);
                    }
                }
            }
            this.start = this.end;
            if (this.end == l2) break;
            if (!this.generator.evaluate(this)) {
                if (this.mustProcessAll) {
                    this.fromGenerators.remove(this.generator);
                    this.finished = this.fromGenerators.isEmpty();
                } else {
                    this.finished = true;
                }
                if (this.finished) break;
            }
            this.generator = null;
        }
        return true;
    }

    private SelectFrom() {
    }

    public static SelectFrom getInstance() {
        return new SelectFrom();
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public String toString() {
        return "Select From where is " + this.wherePredicate;
    }
}

