#!/usr/bin/perl
#
# Copyright (c) 2006 Zmanda Inc.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Contact information: Zmanda Inc, 505 N Mathlida Ave, Suite 120
# Sunnyvale, CA 94085, USA, or: http://www.zmanda.com
#

# This file contains a template for pre-backup plugin that can be used 
# with Zmanda Recovery Manager (ZRM) for MySQL. For more information about the
# product, please see http://mysqlbackup.zmanda.com/
#
# This plugin is executed before a backup run for the backup set.
#
# Parameters passed to the plugin
# -------------------------------
# First parameter is the value of "pre-backup-plugin-options" from the
# mysql-zrm.conf(5) configuration file.
# Second parameter is the data being backed up. It will be either
# '--all-databases' or 
# '--databases <"db1 db2 ...">' or
# '--database <db>' and  '--tables <"table1 table2 ...">'
# Third parameter --backup-directory <path>
#
# Return values
# -------------
# The plugin should return 0 on success and and non-zero value on failure
#
# How to use this plugin
# ----------------------
# 1. Make modifications to the plugin. The default plugin does no action.
# 2. Modify the mysql-zrm.conf file in the relevant backup-set directory 
#    (/etc/mysql-zrm/<backup set name>/mysql-zrm.conf) and add the 
#    following line to the configuration file.
#
#    pre-backup-plugin="/usr/share/mysql-zrm/plugins/pre-backup.pl"
#    

#This plugin will just print all of the inputs and exit with return value 0
foreach( @ARGV ){
	print "$_\n";
}
exit(0);
