/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.renderer.Renderer;

public class PrintingRenderer
implements Renderer {
    private static final Log logger = LogFactory.getLog(PrintingRenderer.class);
    private Renderer parent;

    public PrintingRenderer(Renderer renderer) {
        this.parent = renderer;
    }

    public void startedDocument(PageContext pageContext) {
        logger.debug((Object)"<document>");
        this.parent.startedDocument(pageContext);
    }

    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<flow tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedFlow(layoutContext);
    }

    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<table tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTable(layoutContext);
    }

    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<table-section tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTableSection(layoutContext);
    }

    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<table-row tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTableRow(layoutContext);
    }

    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<table-cell tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedTableCell(layoutContext);
    }

    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<block tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedBlock(layoutContext);
    }

    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<marker tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedMarker(layoutContext);
    }

    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<paragraph tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedRootInline(layoutContext);
    }

    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<inline tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>"));
        this.parent.startedInline(layoutContext);
    }

    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.debug((Object)("<content>" + contentToken + "</content>"));
        this.parent.addContent(layoutContext, contentToken);
    }

    public void finishedInline() throws NormalizationException {
        logger.debug((Object)"</inline>");
        this.parent.finishedInline();
    }

    public void finishedRootInline() throws NormalizationException {
        logger.debug((Object)"</paragraph>");
        this.parent.finishedRootInline();
    }

    public void finishedMarker() throws NormalizationException {
        logger.debug((Object)"</marker>");
        this.parent.finishedMarker();
    }

    public void finishedBlock() throws NormalizationException {
        logger.debug((Object)"</block>");
        this.parent.finishedBlock();
    }

    public void finishedTableCell() throws NormalizationException {
        logger.debug((Object)"</table-cell>");
        this.parent.finishedTableCell();
    }

    public void finishedTableRow() throws NormalizationException {
        logger.debug((Object)"</table-row>");
        this.parent.finishedTableRow();
    }

    public void finishedTableSection() throws NormalizationException {
        logger.debug((Object)"</table-section>");
        this.parent.finishedTableSection();
    }

    public void finishedTable() throws NormalizationException {
        logger.debug((Object)"</table>");
        this.parent.finishedTable();
    }

    public void finishedFlow() throws NormalizationException {
        logger.debug((Object)"</flow>");
        this.parent.finishedFlow();
    }

    public void finishedDocument() throws NormalizationException {
        logger.debug((Object)"</document>");
        this.parent.finishedDocument();
    }

    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-column-group>");
        this.parent.startedTableColumnGroup(layoutContext);
    }

    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-column>");
        this.parent.startedTableColumn(layoutContext);
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        logger.debug((Object)"</table-column-group>");
        this.parent.finishedTableColumnGroup();
    }

    public void finishedTableColumn() throws NormalizationException {
        logger.debug((Object)"</table-column>");
        this.parent.finishedTableColumn();
    }

    public void handlePageBreak(PageContext pageContext) {
        logger.debug((Object)"<!-- PAGEBREAK ENCOUNTERED -->");
        this.parent.handlePageBreak(pageContext);
    }

    public void startedPassThrough(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<pass-through>");
        this.parent.startedPassThrough(layoutContext);
    }

    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.debug((Object)("<pass-through-content>" + contentToken + "</pass-through-content>"));
        this.parent.addPassThroughContent(layoutContext, contentToken);
    }

    public void finishedPassThrough() throws NormalizationException {
        logger.debug((Object)"</pass-through>");
        this.parent.finishedPassThrough();
    }

    public State saveState() throws StateException {
        return new PrintingRendererState(this.parent);
    }

    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-caption>");
        this.parent.startedTableCaption(layoutContext);
    }

    public void finishedTableCaption() throws NormalizationException {
        logger.debug((Object)"</table-caption>");
        this.parent.finishedTableCaption();
    }

    private static class PrintingRendererState
    implements State {
        private State parentState;

        private PrintingRendererState(Renderer renderer) throws StateException {
            this.parentState = renderer.saveState();
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            return new PrintingRenderer((Renderer)this.parentState.restore(layoutProcess));
        }
    }
}

