/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSParserFactoryException;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSCompoundAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSInheritValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.w3c.css.sac.LexicalUnit;

public class CSSValueFactory {
    private static final Log logger = LogFactory.getLog(CSSValueFactory.class);
    public static final String SIMPLE_PREFIX = "org.jfree.layouting.parser.handlers.";
    public static final String COMPOUND_PREFIX = "org.jfree.layouting.parser.compoundhandlers.";
    private HashMap handlers;
    private HashMap compoundHandlers;
    private StyleKeyRegistry registry;

    public CSSValueFactory(StyleKeyRegistry styleKeyRegistry) {
        if (styleKeyRegistry == null) {
            throw new NullPointerException();
        }
        this.registry = styleKeyRegistry;
        this.handlers = new HashMap();
        this.compoundHandlers = new HashMap();
        this.registerDefaults();
    }

    public void registerDefaults() {
        Object object;
        String string;
        String string2;
        Object object2;
        Configuration configuration = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(SIMPLE_PREFIX);
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            string2 = ((String)object2).substring(SIMPLE_PREFIX.length()).toLowerCase();
            string = configuration.getConfigProperty((String)object2);
            object = ObjectUtilities.loadAndInstantiate((String)string, CSSValueFactory.class, CSSValueReadHandler.class);
            if (object instanceof CSSValueReadHandler) {
                this.handlers.put(string2, object);
                continue;
            }
            logger.warn((Object)("Invalid module implementation: " + string));
        }
        object2 = configuration.findPropertyKeys(COMPOUND_PREFIX);
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            string = string2.substring(COMPOUND_PREFIX.length()).toLowerCase();
            object = configuration.getConfigProperty(string2);
            Object object3 = ObjectUtilities.loadAndInstantiate((String)object, CSSValueFactory.class, CSSCompoundValueReadHandler.class);
            if (!(object3 instanceof CSSCompoundValueReadHandler)) continue;
            this.compoundHandlers.put(string, object3);
        }
    }

    private CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        CSSValueReadHandler cSSValueReadHandler = (CSSValueReadHandler)this.handlers.get(styleKey.getName());
        if (cSSValueReadHandler == null) {
            return null;
        }
        return cSSValueReadHandler.createValue(styleKey, lexicalUnit);
    }

    public static CSSAttrFunction parseAttrFunction(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != 37) {
            return null;
        }
        String string = lexicalUnit.getStringValue().trim();
        String[] stringArray = StyleSheetParserUtil.parseNamespaceIdent(string);
        return new CSSAttrFunction(stringArray[0], stringArray[1]);
    }

    public static boolean isFunctionValue(LexicalUnit lexicalUnit) {
        return lexicalUnit.getLexicalUnitType() == 41 || lexicalUnit.getLexicalUnitType() == 25 || lexicalUnit.getLexicalUnitType() == 26 || lexicalUnit.getLexicalUnitType() == 27 || lexicalUnit.getLexicalUnitType() == 38 || lexicalUnit.getLexicalUnitType() == 41;
    }

    private static CSSAttrFunction parseComplexAttrFn(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return null;
        }
        String string = lexicalUnit.getStringValue().trim();
        String[] stringArray = StyleSheetParserUtil.parseNamespaceIdent(string);
        LexicalUnit lexicalUnit2 = CSSValueFactory.parseComma(lexicalUnit);
        if (lexicalUnit2 == null) {
            return new CSSAttrFunction(stringArray[0], stringArray[1]);
        }
        String string2 = CSSValueFactory.parseAttributeType(lexicalUnit2);
        if (string2 == null) {
            return new CSSAttrFunction(stringArray[0], stringArray[1]);
        }
        return new CSSAttrFunction(stringArray[0], stringArray[1], string2);
    }

    public static CSSFunctionValue parseFunction(LexicalUnit lexicalUnit) {
        Object object;
        if (!CSSValueFactory.isFunctionValue(lexicalUnit)) {
            return null;
        }
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        String string = lexicalUnit.getFunctionName();
        if (lexicalUnit2 == null) {
            return new CSSFunctionValue(string, new CSSValue[0]);
        }
        if ("attr".equalsIgnoreCase(string)) {
            return CSSValueFactory.parseComplexAttrFn(lexicalUnit.getParameters());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (lexicalUnit2 != null) {
            if (lexicalUnit2.getLexicalUnitType() == 35) {
                arrayList.add(new CSSConstant(lexicalUnit2.getStringValue()));
            } else if (lexicalUnit2.getLexicalUnitType() == 36) {
                arrayList.add(new CSSStringValue(CSSStringType.STRING, lexicalUnit2.getStringValue()));
            } else if (CSSValueFactory.isNumericValue(lexicalUnit2)) {
                object = CSSValueFactory.createNumericValue(lexicalUnit2);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            } else if (CSSValueFactory.isLengthValue(lexicalUnit2)) {
                object = CSSValueFactory.createLengthValue(lexicalUnit2);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            } else if (lexicalUnit2.getLexicalUnitType() == 37) {
                object = CSSValueFactory.parseAttrFunction(lexicalUnit2);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            } else if (lexicalUnit2.getLexicalUnitType() == 24) {
                object = CSSValueFactory.createUriValue(lexicalUnit2);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            } else if (CSSValueFactory.isFunctionValue(lexicalUnit2)) {
                object = CSSValueFactory.parseFunction(lexicalUnit2);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            } else {
                return null;
            }
            lexicalUnit2 = CSSValueFactory.parseComma(lexicalUnit2);
        }
        object = arrayList.toArray(new CSSValue[arrayList.size()]);
        return new CSSFunctionValue(string, (CSSValue[])object);
    }

    private static String parseAttributeType(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 35) {
            return lexicalUnit.getStringValue();
        }
        return null;
    }

    private void setCompundInheritValue(String string, CSSDeclarationRule cSSDeclarationRule, boolean bl) {
        CSSCompoundValueReadHandler cSSCompoundValueReadHandler = (CSSCompoundValueReadHandler)this.compoundHandlers.get(string);
        if (cSSCompoundValueReadHandler == null) {
            logger.warn((Object)("Got no key for inherited value: " + string));
            return;
        }
        StyleKey[] styleKeyArray = cSSCompoundValueReadHandler.getAffectedKeys();
        for (int i = 0; i < styleKeyArray.length; ++i) {
            StyleKey styleKey = styleKeyArray[i];
            cSSDeclarationRule.setPropertyValue(styleKey, CSSInheritValue.getInstance());
            cSSDeclarationRule.setImportant(styleKey, bl);
        }
    }

    private void setCompundAttrValue(String string, CSSAttrFunction cSSAttrFunction, CSSDeclarationRule cSSDeclarationRule, boolean bl) {
        CSSCompoundValueReadHandler cSSCompoundValueReadHandler = (CSSCompoundValueReadHandler)this.compoundHandlers.get(string);
        if (cSSCompoundValueReadHandler == null) {
            logger.warn((Object)("Got no key for compound attr function: " + string));
            return;
        }
        StyleKey[] styleKeyArray = cSSCompoundValueReadHandler.getAffectedKeys();
        for (int i = 0; i < styleKeyArray.length; ++i) {
            StyleKey styleKey = styleKeyArray[i];
            CSSCompoundAttrFunction cSSCompoundAttrFunction = new CSSCompoundAttrFunction(string, cSSAttrFunction.getNamespace(), cSSAttrFunction.getName(), cSSAttrFunction.getType());
            cSSDeclarationRule.setPropertyValue(styleKey, cSSCompoundAttrFunction);
            cSSDeclarationRule.setImportant(styleKey, bl);
        }
    }

    public void parseValue(CSSDeclarationRule cSSDeclarationRule, String string, LexicalUnit lexicalUnit, boolean bl) throws CSSParserFactoryException {
        Object object;
        if (cSSDeclarationRule == null) {
            throw new NullPointerException("Rule given is null.");
        }
        String string2 = string.toLowerCase();
        StyleKey styleKey = this.registry.findKeyByName(string2);
        if (lexicalUnit.getLexicalUnitType() == 12) {
            if (styleKey == null) {
                this.setCompundInheritValue(string2, cSSDeclarationRule, bl);
                return;
            }
            cSSDeclarationRule.setPropertyValue(styleKey, CSSInheritValue.getInstance());
            cSSDeclarationRule.setImportant(styleKey, bl);
            return;
        }
        if (lexicalUnit.getLexicalUnitType() == 37) {
            CSSAttrFunction cSSAttrFunction = CSSValueFactory.parseAttrFunction(lexicalUnit);
            if (cSSAttrFunction != null) {
                if (styleKey == null) {
                    this.setCompundAttrValue(string2, cSSAttrFunction, cSSDeclarationRule, bl);
                    return;
                }
                cSSDeclarationRule.setPropertyValue(styleKey, cSSAttrFunction);
                cSSDeclarationRule.setImportant(styleKey, bl);
            }
            return;
        }
        if (CSSValueFactory.isFunctionValue(lexicalUnit) && "attr".equals(lexicalUnit.getFunctionName())) {
            if (styleKey == null) {
                logger.warn((Object)("Got no key for attribute-function " + string2));
                return;
            }
            CSSAttrFunction cSSAttrFunction = CSSValueFactory.parseComplexAttrFn(lexicalUnit.getParameters());
            if (cSSAttrFunction != null) {
                cSSDeclarationRule.setPropertyValue(styleKey, cSSAttrFunction);
                cSSDeclarationRule.setImportant(styleKey, bl);
            }
            return;
        }
        if (styleKey != null && (object = this.createValue(styleKey, lexicalUnit)) != null) {
            cSSDeclarationRule.setPropertyValue(styleKey, (CSSValue)object);
            cSSDeclarationRule.setImportant(styleKey, bl);
            return;
        }
        object = (CSSCompoundValueReadHandler)this.compoundHandlers.get(string2);
        if (object == null) {
            if (styleKey == null) {
                logger.info((Object)("Unknown style-key: Neither compound handlers nor single-value handers are registered for " + string2));
                return;
            }
            logger.warn((Object)("Unparsable value: Got no valid result for " + string2 + " (" + lexicalUnit + ')'));
            return;
        }
        Map map = object.createValues(lexicalUnit);
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            StyleKey styleKey2 = (StyleKey)entry.getKey();
            CSSValue cSSValue = (CSSValue)entry.getValue();
            cSSDeclarationRule.setPropertyValue(styleKey2, cSSValue);
            cSSDeclarationRule.setImportant(styleKey2, bl);
        }
    }

    public static CSSStringValue createUriValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() != 24) {
            return null;
        }
        String string = lexicalUnit.getStringValue();
        return new CSSStringValue(CSSStringType.URI, string);
    }

    public static boolean isNumericValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 13) {
            return true;
        }
        return lexicalUnit.getLexicalUnitType() == 14;
    }

    public static CSSNumericValue createNumericValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 13) {
            return CSSNumericValue.createValue(CSSNumericType.NUMBER, lexicalUnit.getIntegerValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 14) {
            return CSSNumericValue.createValue(CSSNumericType.NUMBER, lexicalUnit.getFloatValue());
        }
        return null;
    }

    public static boolean isLengthValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 15) {
            return true;
        }
        if (lexicalUnit.getLexicalUnitType() == 16) {
            return true;
        }
        if (lexicalUnit.getLexicalUnitType() == 17) {
            return true;
        }
        if (lexicalUnit.getLexicalUnitType() == 18) {
            return true;
        }
        if (lexicalUnit.getLexicalUnitType() == 19) {
            return true;
        }
        if (lexicalUnit.getLexicalUnitType() == 20) {
            return true;
        }
        if (lexicalUnit.getLexicalUnitType() == 22) {
            return true;
        }
        return lexicalUnit.getLexicalUnitType() == 21;
    }

    public static CSSNumericValue createLengthValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit.getLexicalUnitType() == 13) {
            if (lexicalUnit.getFloatValue() != 0.0f) {
                return null;
            }
            return CSSNumericValue.createValue(CSSNumericType.PT, 0.0);
        }
        if (lexicalUnit.getLexicalUnitType() == 15) {
            return CSSNumericValue.createValue(CSSNumericType.EM, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 16) {
            return CSSNumericValue.createValue(CSSNumericType.EX, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 17) {
            return CSSNumericValue.createValue(CSSNumericType.PX, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 18) {
            return CSSNumericValue.createValue(CSSNumericType.INCH, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 19) {
            return CSSNumericValue.createValue(CSSNumericType.CM, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 20) {
            return CSSNumericValue.createValue(CSSNumericType.MM, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 22) {
            return CSSNumericValue.createValue(CSSNumericType.PC, lexicalUnit.getFloatValue());
        }
        if (lexicalUnit.getLexicalUnitType() == 21) {
            return CSSNumericValue.createValue(CSSNumericType.PT, lexicalUnit.getFloatValue());
        }
        return null;
    }

    public static LexicalUnit parseComma(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return null;
        }
        LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
        if (lexicalUnit2 == null) {
            return null;
        }
        if (lexicalUnit2.getLexicalUnitType() == 0) {
            return lexicalUnit2.getNextLexicalUnit();
        }
        return null;
    }
}

