/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.file;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.file.FileResourceData;

public class FileResourceLoader
implements ResourceLoader {
    public static final String SCHEMA_NAME = FileResourceLoader.class.getName();
    private static final Log logger = LogFactory.getLog(FileResourceLoader.class);

    public boolean isSupportedKey(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return SCHEMA_NAME.equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        File f;
        if (value instanceof File) {
            File f2 = (File)value;
            if (f2.exists() && f2.isFile()) {
                return new ResourceKey(SCHEMA_NAME, f2, factoryKeys);
            }
        } else if (value instanceof String && (f = new File(String.valueOf(value))).exists() && f.isFile()) {
            return new ResourceKey(SCHEMA_NAME, f, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        try {
            HashMap map;
            File target;
            if (path != null) {
                File parentResource = (File)parent.getIdentifier();
                target = new File(parentResource.getCanonicalFile().getParentFile(), path);
                if (!target.exists() || !target.isFile()) {
                    throw new ResourceKeyCreationException("Malformed value: " + path + " (" + target + ')');
                }
            } else {
                target = (File)parent.getIdentifier();
            }
            if (factoryKeys != null) {
                map = new HashMap();
                map.putAll(parent.getFactoryParameters());
                map.putAll(factoryKeys);
            } else {
                map = parent.getFactoryParameters();
            }
            return new ResourceKey(parent.getSchema(), target, map);
        }
        catch (IOException ioe) {
            throw new ResourceKeyCreationException("Failed to create key", ioe);
        }
    }

    public URL toURL(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        File file = (File)key.getIdentifier();
        try {
            return file.toURI().toURL();
        }
        catch (SecurityException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new FileResourceData(key);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new NullPointerException("The ResourceKey can not be null");
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        if (!(key.getIdentifier() instanceof File)) {
            throw new IllegalArgumentException("ResourceKey is invalid - identifier is not a File object");
        }
        logger.debug((Object)"Serializing a File Resource Key...");
        if (key.getParent() != null) {
            throw new ResourceException("Unable to serialize a File-ResourceKey with a parent. This type is not expected to have a parent.");
        }
        try {
            File file = (File)key.getIdentifier();
            String strIdentifier = file.getCanonicalPath();
            String result = ResourceKeyUtils.createStringResourceKey(key.getSchema().toString(), strIdentifier, key.getFactoryParameters());
            logger.debug((Object)("Serialized File Resource Key: [" + result + "]"));
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not determine cononical path to file specified in ResourceKey: " + ioe.getMessage());
        }
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData keyData = ResourceKeyUtils.parse(stringKey);
        if (!SCHEMA_NAME.equals(keyData.getSchema())) {
            throw new ResourceKeyCreationException("Serialized version of key does not contain correct schema");
        }
        File file = new File(keyData.getIdentifier());
        return this.createKey(file, keyData.getFactoryParameters());
    }

    public boolean isSupportedDeserializer(String data) {
        return SCHEMA_NAME.equals(ResourceKeyUtils.readSchemaFromString(data));
    }
}

