/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractReader {
    protected DataSet ds = new DataSet();
    protected Changeset uploadChangeset;
    protected final Map<PrimitiveId, OsmPrimitive> externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    protected final Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    protected final Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();

    public DataSet getDataSet() {
        return this.ds;
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive osmPrimitive : this.externalIdMap.values()) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.ds.addPrimitive(osmPrimitive);
        }
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Map.Entry<Long, Collection<Long>> entry : this.ways.entrySet()) {
            Long l = entry.getKey();
            Way way = (Way)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.WAY));
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (long l2 : entry.getValue()) {
                Node node = (Node)this.externalIdMap.get(new SimplePrimitiveId(l2, OsmPrimitiveType.NODE));
                if (node == null) {
                    if (l2 <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", l, l2));
                    }
                    node = (Node)this.ds.getPrimitiveById(l2, OsmPrimitiveType.NODE);
                    if (node == null) {
                        node = new Node(l2);
                        this.ds.addPrimitive(node);
                    }
                }
                if (node.isDeleted()) {
                    Main.info(I18n.tr("Deleted node {0} is part of way {1}", l2, way.getId()));
                    continue;
                }
                arrayList.add(node);
            }
            way.setNodes(arrayList);
            if (way.hasIncompleteNodes()) {
                Main.info(I18n.tr("Way {0} with {1} nodes has incomplete nodes because at least one node was missing in the loaded data.", l, way.getNodesCount()));
            }
            this.ds.addPrimitive(way);
        }
    }

    protected void processRelationsAfterParsing() throws IllegalDataException {
        Comparable<OsmPrimitive> comparable;
        for (Long object : this.relations.keySet()) {
            comparable = (Relation)this.externalIdMap.get(new SimplePrimitiveId(object, OsmPrimitiveType.RELATION));
            this.ds.addPrimitive((OsmPrimitive)comparable);
        }
        for (Map.Entry entry : this.relations.entrySet()) {
            comparable = (Long)entry.getKey();
            Relation relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId((Long)comparable, OsmPrimitiveType.RELATION));
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMemberData relationMemberData : (Collection)entry.getValue()) {
                OsmPrimitive osmPrimitive = this.externalIdMap.get(new SimplePrimitiveId(relationMemberData.getMemberId(), relationMemberData.getMemberType()));
                if (osmPrimitive == null) {
                    if (relationMemberData.getMemberId() <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", comparable, relationMemberData.getMemberId()));
                    }
                    osmPrimitive = this.ds.getPrimitiveById(relationMemberData.getMemberId(), relationMemberData.getMemberType());
                    if (osmPrimitive == null) {
                        switch (relationMemberData.getMemberType()) {
                            case NODE: {
                                osmPrimitive = new Node(relationMemberData.getMemberId());
                                break;
                            }
                            case WAY: {
                                osmPrimitive = new Way(relationMemberData.getMemberId());
                                break;
                            }
                            case RELATION: {
                                osmPrimitive = new Relation(relationMemberData.getMemberId());
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.ds.addPrimitive(osmPrimitive);
                        this.externalIdMap.put(new SimplePrimitiveId(relationMemberData.getMemberId(), relationMemberData.getMemberType()), osmPrimitive);
                    }
                }
                if (osmPrimitive.isDeleted()) {
                    Main.info(I18n.tr("Deleted member {0} is used by relation {1}", osmPrimitive.getId(), relation.getId()));
                    continue;
                }
                arrayList.add(new RelationMember(relationMemberData.getRole(), osmPrimitive));
            }
            relation.setMembers(arrayList);
        }
    }

    protected void processChangesetAfterParsing() {
        if (this.uploadChangeset != null) {
            for (Map.Entry<String, String> entry : this.uploadChangeset.getKeys().entrySet()) {
                this.ds.addChangeSetTag(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void prepareDataSet() throws IllegalDataException {
        try {
            this.ds.beginUpdate();
            this.processNodesAfterParsing();
            this.processWaysAfterParsing();
            this.processRelationsAfterParsing();
            this.processChangesetAfterParsing();
        }
        finally {
            this.ds.endUpdate();
        }
    }
}

