/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetContentDownloadTask;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetAware;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableModel;
import org.openstreetmap.josm.gui.dialogs.changeset.DownloadChangesetContentAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public class ChangesetContentPanel
extends JPanel
implements PropertyChangeListener,
ChangesetAware {
    private ChangesetContentTableModel model;
    private transient Changeset currentChangeset;
    private DownloadChangesetContentAction actDownloadContentAction;
    private ShowHistoryAction actShowHistory;
    private SelectInCurrentLayerAction actSelectInCurrentLayerAction;
    private ZoomInCurrentLayerAction actZoomInCurrentLayerAction;
    private final HeaderPanel pnlHeader = new HeaderPanel();
    public DownloadObjectAction actDownloadObjectAction;

    protected void buildModels() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new ChangesetContentTableModel(defaultListSelectionModel);
        this.actDownloadContentAction = new DownloadChangesetContentAction(this);
        this.actDownloadContentAction.initProperties();
        this.actDownloadObjectAction = new DownloadObjectAction();
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadObjectAction);
        this.actShowHistory = new ShowHistoryAction();
        this.model.getSelectionModel().addListSelectionListener(this.actShowHistory);
        this.actSelectInCurrentLayerAction = new SelectInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actSelectInCurrentLayerAction);
        Main.getLayerManager().addActiveLayerChangeListener(this.actSelectInCurrentLayerAction);
        this.actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actZoomInCurrentLayerAction);
        Main.getLayerManager().addActiveLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                try {
                    Main.getLayerManager().removeActiveLayerChangeListener(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
                    Main.getLayerManager().removeActiveLayerChangeListener(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw BugReport.intercept(illegalArgumentException).put("hint", "This Component can only be hidden once.");
                }
            }
        });
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable(this.model, new ChangesetContentTableColumnModel(), this.model.getSelectionModel());
        jTable.addMouseListener(new PopupMenuLauncher(new ChangesetContentTablePopupMenu()));
        jPanel.add((Component)new JScrollPane(jTable), "Center");
        return jPanel;
    }

    protected JPanel buildActionButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.actDownloadContentAction);
        jToolBar.addSeparator();
        jToolBar.add(this.actDownloadObjectAction);
        jToolBar.add(this.actShowHistory);
        jToolBar.addSeparator();
        jToolBar.add(this.actSelectInCurrentLayerAction);
        jToolBar.add(this.actZoomInCurrentLayerAction);
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected final void build() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.buildModels();
        this.add((Component)this.pnlHeader, "North");
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add((Component)this.buildContentPanel(), "Center");
    }

    public ChangesetContentPanel() {
        this.build();
    }

    public ChangesetContentTableModel getModel() {
        return this.model;
    }

    protected void setCurrentChangeset(Changeset changeset) {
        this.currentChangeset = changeset;
        if (changeset == null) {
            this.model.populate(null);
        } else {
            this.model.populate(changeset.getContent());
        }
        this.actDownloadContentAction.initProperties();
        this.pnlHeader.setChangeset(changeset);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        Changeset changeset = (Changeset)propertyChangeEvent.getNewValue();
        this.setCurrentChangeset(changeset);
    }

    private void alertNoPrimitivesTo(Collection<HistoryOsmPrimitive> collection, String string, String string2) {
        HelpAwareOptionPane.showOptionDialog(this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", collection.size(), Main.getLayerManager().getEditLayer().getName()), string, 2, string2);
    }

    @Override
    public Changeset getCurrentChangeset() {
        return this.currentChangeset;
    }

    private static class HeaderPanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private transient Changeset current;

        protected final void build() {
            this.setLayout(new FlowLayout(0));
            this.lblMessage = new JMultilineLabel(I18n.tr("The content of this changeset is not downloaded yet.", new Object[0]));
            this.add(this.lblMessage);
            this.add(new JButton(new DownloadAction()));
        }

        HeaderPanel() {
            this.build();
        }

        public void setChangeset(Changeset changeset) {
            this.setVisible(changeset != null && changeset.getContent() == null);
            this.current = changeset;
        }

        private class DownloadAction
        extends AbstractAction {
            DownloadAction() {
                this.putValue("Name", I18n.tr("Download now", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content", new Object[0]));
                new ImageProvider("dialogs/changeset", "downloadchangesetcontent").getResource().attachImageIcon(this);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeaderPanel.this.current == null) {
                    return;
                }
                ChangesetContentDownloadTask changesetContentDownloadTask = new ChangesetContentDownloadTask((Component)HeaderPanel.this, HeaderPanel.this.current.getId());
                ChangesetCacheManager.getInstance().runDownloadTask(changesetContentDownloadTask);
            }
        }
    }

    class ZoomInCurrentLayerAction
    extends SelectionBasedAction {
        ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            new ImageProvider("dialogs/autoscale", "selection").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Zoom to the corresponding objects in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Set<OsmPrimitive> set = this.getTarget();
            if (set == null) {
                return;
            }
            if (set.isEmpty()) {
                ChangesetContentPanel.this.alertNoPrimitivesTo(ChangesetContentPanel.this.model.getSelectedPrimitives(), I18n.tr("Nothing to zoom to", new Object[0]), HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
                return;
            }
            Main.getLayerManager().getEditLayer().data.setSelected(set);
            AutoScaleAction.zoomToSelection();
        }
    }

    class SelectInCurrentLayerAction
    extends SelectionBasedAction {
        SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            new ImageProvider("dialogs", "select").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Select the corresponding primitives in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Set<OsmPrimitive> set = this.getTarget();
            if (set == null) {
                return;
            }
            if (set.isEmpty()) {
                ChangesetContentPanel.this.alertNoPrimitivesTo(ChangesetContentPanel.this.model.getSelectedPrimitives(), I18n.tr("Nothing to select", new Object[0]), HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
                return;
            }
            Main.getLayerManager().getEditLayer().data.setSelected(set);
        }
    }

    abstract class SelectionBasedAction
    extends AbstractAction
    implements ListSelectionListener,
    MainLayerManager.ActiveLayerChangeListener {
        SelectionBasedAction() {
        }

        protected Set<OsmPrimitive> getTarget() {
            if (!this.isEnabled() || Main.main == null || !Main.main.hasEditLayer()) {
                return null;
            }
            OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive historyOsmPrimitive : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive osmPrimitive = osmDataLayer.data.getPrimitiveById(historyOsmPrimitive.getPrimitiveId());
                if (osmPrimitive == null) continue;
                hashSet.add(osmPrimitive);
            }
            return hashSet;
        }

        public final void updateEnabledState() {
            if (Main.main == null || !Main.main.hasEditLayer()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
            this.updateEnabledState();
        }
    }

    class DownloadObjectAction
    extends AbstractAction
    implements ListSelectionListener {
        DownloadObjectAction() {
            this.putValue("Name", I18n.tr("Download objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("downloadprimitive"));
            this.putValue("ShortDescription", I18n.tr("Download the current version of the selected objects", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<PrimitiveId> arrayList = new ArrayList<PrimitiveId>(Utils.transform(ChangesetContentPanel.this.model.getSelectedPrimitives(), new Utils.Function<HistoryOsmPrimitive, PrimitiveId>(){

                @Override
                public PrimitiveId apply(HistoryOsmPrimitive historyOsmPrimitive) {
                    return historyOsmPrimitive.getPrimitiveId();
                }
            }));
            Main.worker.submit(new DownloadPrimitivesWithReferrersTask(false, arrayList, true, true, null, null));
        }

        protected final void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            new ImageProvider("dialogs", "history").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download and show the history of the selected objects", new Object[0]));
            this.updateEnabledState();
        }

        protected List<HistoryOsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<HistoryOsmPrimitive> collection) {
            ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>(collection.size());
            for (HistoryOsmPrimitive historyOsmPrimitive : collection) {
                if (HistoryDataSet.getInstance().getHistory(historyOsmPrimitive.getPrimitiveId()) != null) continue;
                arrayList.add(historyOsmPrimitive);
            }
            return arrayList;
        }

        public void showHistory(Collection<HistoryOsmPrimitive> collection) {
            List<HistoryOsmPrimitive> list = this.filterPrimitivesWithUnloadedHistory(collection);
            if (!list.isEmpty()) {
                HistoryLoadTask historyLoadTask = new HistoryLoadTask(ChangesetContentPanel.this);
                for (HistoryOsmPrimitive historyOsmPrimitive : list) {
                    historyLoadTask.add(historyOsmPrimitive);
                }
                Main.worker.submit(historyLoadTask);
            }
            Main.worker.submit(new ShowHistoryTask(collection));
        }

        protected final void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Set<HistoryOsmPrimitive> set = ChangesetContentPanel.this.model.getSelectedPrimitives();
            if (set.isEmpty()) {
                return;
            }
            this.showHistory(set);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        private final class ShowHistoryTask
        implements Runnable {
            private final Collection<HistoryOsmPrimitive> primitives;

            private ShowHistoryTask(Collection<HistoryOsmPrimitive> collection) {
                this.primitives = collection;
            }

            @Override
            public void run() {
                try {
                    for (HistoryOsmPrimitive historyOsmPrimitive : this.primitives) {
                        final History history = HistoryDataSet.getInstance().getHistory(historyOsmPrimitive.getPrimitiveId());
                        if (history == null) continue;
                        GuiHelper.runInEDT(new Runnable(){

                            @Override
                            public void run() {
                                HistoryBrowserDialogManager.getInstance().show(history);
                            }
                        });
                    }
                }
                catch (RuntimeException runtimeException) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            BugReportExceptionHandler.handleException(runtimeException);
                        }
                    });
                }
            }
        }
    }

    class ChangesetContentTablePopupMenu
    extends JPopupMenu {
        ChangesetContentTablePopupMenu() {
            this.add(ChangesetContentPanel.this.actDownloadContentAction);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actDownloadObjectAction);
            this.add(ChangesetContentPanel.this.actShowHistory);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
            this.add(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
        }
    }
}

