/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class Way
extends OsmPrimitive
implements IWay {
    private Node[] nodes = new Node[0];
    private BBox bbox;

    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodes(List<Node> list) {
        boolean bl = this.writeLock();
        try {
            for (Node node : this.nodes) {
                node.removeReferrer(this);
                node.clearCachedStyle();
            }
            this.nodes = list == null ? new Node[0] : list.toArray(new Node[list.size()]);
            for (Node node : this.nodes) {
                node.addReferrer(this);
                node.clearCachedStyle();
            }
            this.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    private static List<Node> removeDouble(List<Node> list) {
        Node node = null;
        int n = list.size();
        int n2 = 0;
        while (n2 < n && n > 2) {
            Node node2 = list.get(n2);
            if (node == node2) {
                list.remove(n2);
                --n;
                continue;
            }
            node = node2;
            ++n2;
        }
        return list;
    }

    @Override
    public int getNodesCount() {
        return this.nodes.length;
    }

    public int getRealNodesCount() {
        int n = this.getNodesCount();
        return this.isClosed() ? n - 1 : n;
    }

    public Node getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public long getNodeId(int n) {
        return this.nodes[n].getUniqueId();
    }

    public boolean containsNode(Node node) {
        Node[] nodeArray;
        if (node == null) {
            return false;
        }
        for (Node node2 : nodeArray = this.nodes) {
            if (!node2.equals(node)) continue;
            return true;
        }
        return false;
    }

    public Set<Node> getNeighbours(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        if (node == null) {
            return hashSet;
        }
        Node[] nodeArray = this.nodes;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!nodeArray[i].equals(node)) continue;
            if (i > 0) {
                hashSet.add(nodeArray[i - 1]);
            }
            if (i >= nodeArray.length - 1) continue;
            hashSet.add(nodeArray[i + 1]);
        }
        return hashSet;
    }

    public List<Pair<Node, Node>> getNodePairs(boolean bl) {
        Node[] nodeArray;
        ArrayList<Pair<Node, Node>> arrayList = new ArrayList<Pair<Node, Node>>();
        if (this.isIncomplete()) {
            return arrayList;
        }
        Node node = null;
        for (Node node2 : nodeArray = this.nodes) {
            if (node == null) {
                node = node2;
                continue;
            }
            Pair<Node, Node> pair = new Pair<Node, Node>(node, node2);
            if (bl) {
                Pair.sort(pair);
            }
            arrayList.add(pair);
            node = node2;
        }
        return arrayList;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    protected Way(long l, boolean bl) {
        super(l, bl);
    }

    public Way() {
        super(0L, false);
    }

    public Way(Way way, boolean bl) {
        super(way.getUniqueId(), true);
        this.cloneFrom(way);
        if (bl) {
            this.clearOsmMetadata();
        }
    }

    public Way(Way way) {
        this(way, false);
    }

    public Way(long l) {
        super(l, false);
    }

    public Way(long l, int n) {
        super(l, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData primitiveData) {
        boolean bl = this.writeLock();
        try {
            super.load(primitiveData);
            WayData wayData = (WayData)primitiveData;
            if (!wayData.getNodes().isEmpty() && this.getDataSet() == null) {
                throw new AssertionError((Object)"Data consistency problem - way without dataset detected");
            }
            ArrayList<Node> arrayList = new ArrayList<Node>(wayData.getNodes().size());
            for (Long l : wayData.getNodes()) {
                Node node = (Node)this.getDataSet().getPrimitiveById(l, OsmPrimitiveType.NODE);
                if (node != null) {
                    arrayList.add(node);
                    continue;
                }
                throw new AssertionError((Object)"Data consistency problem - way with missing node detected");
            }
            this.setNodes(arrayList);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public WayData save() {
        WayData wayData = new WayData();
        this.saveCommonAttributes(wayData);
        for (Node node : this.nodes) {
            wayData.getNodes().add(node.getUniqueId());
        }
        return wayData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.cloneFrom(osmPrimitive);
            Way way = (Way)osmPrimitive;
            this.setNodes(way.getNodes());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public String toString() {
        String string = this.isIncomplete() ? "(incomplete)" : "nodes=" + Arrays.toString(this.nodes);
        return "{Way id=" + this.getUniqueId() + " version=" + this.getVersion() + ' ' + this.getFlagsAsString() + ' ' + string + '}';
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive, boolean bl) {
        if (!(osmPrimitive instanceof Way)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive, bl)) {
            return false;
        }
        Way way = (Way)osmPrimitive;
        if (this.getNodesCount() != way.getNodesCount()) {
            return false;
        }
        for (int i = 0; i < this.getNodesCount(); ++i) {
            if (this.getNode(i).hasEqualSemanticAttributes(way.getNode(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Relation) {
            return 1;
        }
        return osmPrimitive instanceof Way ? Long.compare(this.getUniqueId(), osmPrimitive.getUniqueId()) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) {
        if (node == null || this.isIncomplete()) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            int n;
            boolean bl2 = this.lastNode() == node && this.firstNode() == node;
            List<Node> list = this.getNodes();
            while ((n = list.indexOf(node)) >= 0) {
                list.remove(n);
            }
            n = list.size();
            if (bl2 && n > 2) {
                list.add(list.get(0));
            } else if (n >= 2 && n <= 3 && list.get(0) == list.get(n - 1)) {
                list.remove(n - 1);
            }
            this.setNodes(Way.removeDouble(list));
            node.clearCachedStyle();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeNodes(Set<? extends Node> set) {
        if (set == null || this.isIncomplete()) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            void node;
            boolean bl2 = this.isClosed() && set.contains(this.lastNode());
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node[] nodeArray = this.nodes;
            int n = nodeArray.length;
            boolean bl3 = false;
            while (node < n) {
                Node node2 = nodeArray[node];
                if (!set.contains(node2)) {
                    arrayList.add(node2);
                }
                ++node;
            }
            int n2 = arrayList.size();
            if (bl2 && n2 > 2) {
                arrayList.add((Node)arrayList.get(0));
            } else if (n2 >= 2 && n2 <= 3 && arrayList.get(0) == arrayList.get(n2 - 1)) {
                arrayList.remove(n2 - 1);
            }
            this.setNodes(Way.removeDouble(arrayList));
            for (Node node3 : set) {
                node3.clearCachedStyle();
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node) {
        if (node == null) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
            }
            this.clearCachedStyle();
            node.addReferrer(this);
            this.nodes = Utils.addInArrayCopy(this.nodes, node);
            node.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(int n, Node node) throws IndexOutOfBoundsException {
        if (node == null) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
            }
            this.clearCachedStyle();
            node.addReferrer(this);
            Node[] nodeArray = new Node[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, nodeArray, 0, n);
            System.arraycopy(this.nodes, n, nodeArray, n + 1, this.nodes.length - n);
            nodeArray[n] = node;
            this.nodes = nodeArray;
            node.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            for (Node node : this.nodes) {
                if (bl) {
                    node.removeReferrer(this);
                } else {
                    node.addReferrer(this);
                }
                node.clearCachedStyle();
            }
            this.fireNodesChanged();
            super.setDeleted(bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    @Override
    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        Node[] nodeArray = this.nodes;
        return nodeArray.length >= 3 && nodeArray[nodeArray.length - 1] == nodeArray[0];
    }

    public boolean isArea() {
        if (this.nodes.length >= 4 && this.isClosed()) {
            Node node = null;
            for (int i = 1; i < this.nodes.length - 1; ++i) {
                if (node == null && this.nodes[i] != this.nodes[0]) {
                    node = this.nodes[i];
                    continue;
                }
                if (node == null || this.nodes[i] == this.nodes[0] || this.nodes[i] == node) continue;
                return true;
            }
        }
        return false;
    }

    public Node lastNode() {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length == 0) {
            return null;
        }
        return nodeArray[nodeArray.length - 1];
    }

    public Node firstNode() {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length == 0) {
            return null;
        }
        return nodeArray[0];
    }

    public boolean isFirstLastNode(Node node) {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length == 0) {
            return false;
        }
        return node == nodeArray[0] || node == nodeArray[nodeArray.length - 1];
    }

    public boolean isInnerNode(Node node) {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length <= 2) {
            return false;
        }
        if (node == nodeArray[0] && node == nodeArray[nodeArray.length - 1]) {
            return true;
        }
        for (int i = 1; i < nodeArray.length - 1; ++i) {
            if (nodeArray[i] != node) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    @Override
    public OsmPrimitiveType getDisplayType() {
        return this.isClosed() ? OsmPrimitiveType.CLOSEDWAY : OsmPrimitiveType.WAY;
    }

    private void checkNodes() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                if (node.getDataSet() != dataSet) {
                    throw new DataIntegrityProblemException("Nodes in way must be in the same dataset", I18n.tr("Nodes in way must be in the same dataset", new Object[0]));
                }
                if (!node.isDeleted()) continue;
                throw new DataIntegrityProblemException("Deleted node referenced: " + this.toString(), "<html>" + I18n.tr("Deleted node referenced by {0}", DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(this)) + "</html>");
            }
            if (Main.pref.getBoolean("debug.checkNullCoor", true)) {
                for (Node node : nodeArray) {
                    if (!node.isVisible() || node.isIncomplete() || node.isLatLonKnown()) continue;
                    throw new DataIntegrityProblemException("Complete visible node with null coordinates: " + this.toString(), "<html>" + I18n.tr("Complete node {0} with null coordinates in way {1}", DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(node), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(this)) + "</html>");
                }
            }
        }
    }

    private void fireNodesChanged() {
        this.checkNodes();
        if (this.getDataSet() != null) {
            this.getDataSet().fireWayNodesChanged(this);
        }
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkNodes();
    }

    @Override
    public BBox getBBox() {
        if (this.getDataSet() == null) {
            return new BBox(this);
        }
        if (this.bbox == null) {
            this.bbox = new BBox(this);
        }
        return new BBox(this.bbox);
    }

    @Override
    public void updatePosition() {
        this.bbox = new BBox(this);
    }

    public boolean hasIncompleteNodes() {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !this.hasIncompleteNodes();
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && !this.hasIncompleteNodes();
    }

    public double getLength() {
        double d = 0.0;
        Node node = null;
        for (Node node2 : this.nodes) {
            if (node != null) {
                LatLon latLon = node.getCoor();
                LatLon latLon2 = node2.getCoor();
                if (latLon != null && latLon2 != null) {
                    d += latLon2.greatCircleDistance(latLon);
                }
            }
            node = node2;
        }
        return d;
    }

    public double getLongestSegmentLength() {
        double d = 0.0;
        Node node = null;
        for (Node node2 : this.nodes) {
            if (node != null) {
                double d2;
                LatLon latLon = node.getCoor();
                LatLon latLon2 = node2.getCoor();
                if (latLon != null && latLon2 != null && (d2 = latLon2.greatCircleDistance(latLon)) > d) {
                    d = d2;
                }
            }
            node = node2;
        }
        return d;
    }

    public int isOneway() {
        String string = this.get("oneway");
        if (string != null) {
            if ("-1".equals(string)) {
                return -1;
            }
            Boolean bl = OsmUtils.getOsmBoolean(string);
            if (bl != null && bl.booleanValue()) {
                return 1;
            }
        }
        return 0;
    }

    public Node firstNode(boolean bl) {
        return !bl || this.isOneway() != -1 ? this.firstNode() : this.lastNode();
    }

    public Node lastNode(boolean bl) {
        return !bl || this.isOneway() != -1 ? this.lastNode() : this.firstNode();
    }

    @Override
    public boolean concernsArea() {
        return this.hasAreaTags();
    }

    @Override
    public boolean isOutsideDownloadArea() {
        for (Node node : this.nodes) {
            if (!node.isOutsideDownloadArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void keysChangedImpl(Map<String, String> map) {
        super.keysChangedImpl(map);
        this.clearCachedNodeStyles();
    }

    public void clearCachedNodeStyles() {
        for (Node node : this.nodes) {
            node.clearCachedStyle();
        }
    }
}

