/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.User;

public abstract class PrimitiveData
extends AbstractPrimitive
implements Serializable {
    private static final long serialVersionUID = -1044837092478109138L;

    public PrimitiveData() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public PrimitiveData(PrimitiveData primitiveData) {
        this.cloneFrom(primitiveData);
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public void setIncomplete(boolean bl) {
        super.setIncomplete(bl);
    }

    public abstract PrimitiveData makeCopy();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id).append(Arrays.toString(this.keys)).append(this.getFlagsAsString());
        return stringBuilder.toString();
    }

    public static <T extends PrimitiveData> List<T> getFilteredList(Collection<T> collection, OsmPrimitiveType osmPrimitiveType) {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>();
        for (PrimitiveData primitiveData : collection) {
            if (!osmPrimitiveType.getDataClass().isInstance(primitiveData)) continue;
            arrayList.add(primitiveData);
        }
        return arrayList;
    }

    @Override
    protected final void keysChangedImpl(Map<String, String> map) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.id);
        objectOutputStream.writeLong(this.user == null ? -1L : this.user.getId());
        objectOutputStream.writeInt(this.version);
        objectOutputStream.writeInt(this.changesetId);
        objectOutputStream.writeInt(this.timestamp);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.id = objectInputStream.readLong();
        long l = objectInputStream.readLong();
        this.user = l == -1L ? null : User.getById(l);
        this.version = objectInputStream.readInt();
        this.changesetId = objectInputStream.readInt();
        this.timestamp = objectInputStream.readInt();
        objectInputStream.defaultReadObject();
    }
}

