/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final Map<String, String> tags;

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> collection, Map<String, String> map) {
        this.tags = map;
        this.init(collection);
    }

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.tags = new HashMap<String, String>(1);
        this.tags.put(string, string2);
        this.init(collection);
    }

    public ChangePropertyCommand(OsmPrimitive osmPrimitive, String string, String string2) {
        this(Arrays.asList(osmPrimitive), string, string2);
    }

    private void init(Collection<? extends OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                String string = osmPrimitive.get(entry.getKey());
                String string2 = entry.getValue();
                if (string2 == null || string2.isEmpty()) {
                    if (string == null) continue;
                    bl = true;
                    continue;
                }
                if (string != null && string2.equals(string)) continue;
                bl = true;
            }
            if (!bl) continue;
            this.objects.add(osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        if (this.objects.isEmpty()) {
            return true;
        }
        DataSet dataSet = this.objects.get(0).getDataSet();
        if (dataSet != null) {
            dataSet.beginUpdate();
        }
        try {
            super.executeCommand();
            for (OsmPrimitive osmPrimitive : this.objects) {
                for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                    String string = osmPrimitive.get(entry.getKey());
                    String string2 = entry.getValue();
                    if (string2 == null || string2.isEmpty()) {
                        if (string == null) continue;
                        osmPrimitive.remove(entry.getKey());
                        continue;
                    }
                    if (string != null && string2.equals(string)) continue;
                    osmPrimitive.put(entry.getKey(), string2);
                }
                osmPrimitive.setModified(true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (dataSet != null) {
                dataSet.endUpdate();
            }
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    @Override
    public String getDescriptionText() {
        String string;
        if (this.objects.size() == 1 && this.tags.size() == 1) {
            OsmPrimitive osmPrimitive = this.objects.get(0);
            Map.Entry<String, String> entry = this.tags.entrySet().iterator().next();
            if (entry.getValue() == null) {
                String string2;
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string2 = I18n.marktr("Remove \"{0}\" for node ''{1}''");
                        break;
                    }
                    case WAY: {
                        string2 = I18n.marktr("Remove \"{0}\" for way ''{1}''");
                        break;
                    }
                    case RELATION: {
                        string2 = I18n.marktr("Remove \"{0}\" for relation ''{1}''");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                string = I18n.tr(string2, entry.getKey(), osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                String string3;
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string3 = I18n.marktr("Set {0}={1} for node ''{2}''");
                        break;
                    }
                    case WAY: {
                        string3 = I18n.marktr("Set {0}={1} for way ''{2}''");
                        break;
                    }
                    case RELATION: {
                        string3 = I18n.marktr("Set {0}={1} for relation ''{2}''");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                string = I18n.tr(string3, entry.getKey(), entry.getValue(), osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        } else if (this.objects.size() > 1 && this.tags.size() == 1) {
            Map.Entry<String, String> entry = this.tags.entrySet().iterator().next();
            string = entry.getValue() == null ? I18n.trn("Remove \"{0}\" for {1} object", "Remove \"{0}\" for {1} objects", this.objects.size(), entry.getKey(), this.objects.size()) : I18n.trn("Set {0}={1} for {2} object", "Set {0}={1} for {2} objects", this.objects.size(), entry.getKey(), entry.getValue(), this.objects.size());
        } else {
            boolean bl = true;
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                if (entry.getValue() == null) continue;
                bl = false;
                break;
            }
            string = bl ? I18n.trn("Deleted {0} tags for {1} object", "Deleted {0} tags for {1} objects", this.objects.size(), this.tags.size(), this.objects.size()) : I18n.trn("Set {0} tags for {1} object", "Set {0} tags for {1} objects", this.objects.size(), this.tags.size(), this.objects.size());
        }
        return string;
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "key");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osmPrimitive : this.objects) {
            arrayList.add(new PseudoCommand(){

                @Override
                public String getDescriptionText() {
                    return osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
                }

                @Override
                public Icon getDescriptionIcon() {
                    return ImageProvider.get(osmPrimitive.getDisplayType());
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return arrayList;
    }

    public final int getObjectsNumber() {
        return this.objects.size();
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objects, this.tags);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangePropertyCommand changePropertyCommand = (ChangePropertyCommand)object;
        return Objects.equals(this.objects, changePropertyCommand.objects) && Objects.equals(this.tags, changePropertyCommand.tags);
    }
}

