/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.deserializer;

import java.io.DataInput;
import java.io.IOException;
import jd.core.model.classfile.attribute.Annotation;
import jd.core.model.classfile.attribute.ElementValue;
import jd.core.model.classfile.attribute.ElementValueAnnotationValue;
import jd.core.model.classfile.attribute.ElementValueArrayValue;
import jd.core.model.classfile.attribute.ElementValueClassInfo;
import jd.core.model.classfile.attribute.ElementValueEnumConstValue;
import jd.core.model.classfile.attribute.ElementValuePair;
import jd.core.model.classfile.attribute.ElementValuePrimitiveType;
import jd.core.process.deserializer.ClassFormatException;

public class AnnotationDeserializer {
    public static Annotation[] Deserialize(DataInput di) throws IOException {
        int num_annotations = di.readUnsignedShort();
        if (num_annotations == 0) {
            return null;
        }
        Annotation[] annotations = new Annotation[num_annotations];
        int i = 0;
        while (i < num_annotations) {
            annotations[i] = new Annotation(di.readUnsignedShort(), AnnotationDeserializer.DeserializeElementValuePairs(di));
            ++i;
        }
        return annotations;
    }

    private static ElementValuePair[] DeserializeElementValuePairs(DataInput di) throws IOException {
        int num_element_value_pairs = di.readUnsignedShort();
        if (num_element_value_pairs == 0) {
            return null;
        }
        ElementValuePair[] pairs = new ElementValuePair[num_element_value_pairs];
        int i = 0;
        while (i < num_element_value_pairs) {
            pairs[i] = new ElementValuePair(di.readUnsignedShort(), AnnotationDeserializer.DeserializeElementValue(di));
            ++i;
        }
        return pairs;
    }

    public static ElementValue DeserializeElementValue(DataInput di) throws IOException {
        byte type = di.readByte();
        switch (type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new ElementValuePrimitiveType(1, type, di.readUnsignedShort());
            }
            case 101: {
                return new ElementValueEnumConstValue(2, di.readUnsignedShort(), di.readUnsignedShort());
            }
            case 99: {
                return new ElementValueClassInfo(3, di.readUnsignedShort());
            }
            case 64: {
                return new ElementValueAnnotationValue(4, new Annotation(di.readUnsignedShort(), AnnotationDeserializer.DeserializeElementValuePairs(di)));
            }
            case 91: {
                return new ElementValueArrayValue(5, AnnotationDeserializer.DeserializeElementValues(di));
            }
        }
        throw new ClassFormatException("Invalid element value type: " + type);
    }

    private static ElementValue[] DeserializeElementValues(DataInput di) throws IOException {
        int num_values = di.readUnsignedShort();
        if (num_values == 0) {
            return null;
        }
        ElementValue[] values = new ElementValue[num_values];
        int i = 0;
        while (i < num_values) {
            values[i] = AnnotationDeserializer.DeserializeElementValue(di);
            ++i;
        }
        return values;
    }
}

