"""Generated client library for serviceregistry version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.
from googlecloudsdk.third_party.apitools.base.py import base_api
from googlecloudsdk.third_party.apis.serviceregistry.v1alpha import serviceregistry_v1alpha_messages as messages


class ServiceregistryV1alpha(base_api.BaseApiClient):
  """Generated client library for service serviceregistry version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://www.googleapis.com/serviceregistry/v1alpha/'

  _PACKAGE = u'serviceregistry'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only', u'https://www.googleapis.com/auth/ndev.cloudman', u'https://www.googleapis.com/auth/ndev.cloudman.readonly']
  _VERSION = u'v1alpha'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'ServiceregistryV1alpha'
  _URL_VERSION = u'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new serviceregistry handle."""
    url = url or self.BASE_URL
    super(ServiceregistryV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.endpoints = self.EndpointsService(self)
    self.operations = self.OperationsService(self)

  class EndpointsService(base_api.BaseApiService):
    """Service class for the endpoints resource."""

    _NAME = u'endpoints'

    def __init__(self, client):
      super(ServiceregistryV1alpha.EndpointsService, self).__init__(client)
      self._method_configs = {
          'Delete': base_api.ApiMethodInfo(
              http_method=u'DELETE',
              method_id=u'serviceregistry.endpoints.delete',
              ordered_params=[u'project', u'endpoint'],
              path_params=[u'endpoint', u'project'],
              query_params=[],
              relative_path=u'projects/{project}/global/endpoints/{endpoint}',
              request_field='',
              request_type_name=u'ServiceregistryEndpointsDeleteRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'serviceregistry.endpoints.get',
              ordered_params=[u'project', u'endpoint'],
              path_params=[u'endpoint', u'project'],
              query_params=[],
              relative_path=u'projects/{project}/global/endpoints/{endpoint}',
              request_field='',
              request_type_name=u'ServiceregistryEndpointsGetRequest',
              response_type_name=u'Endpoint',
              supports_download=False,
          ),
          'Insert': base_api.ApiMethodInfo(
              http_method=u'POST',
              method_id=u'serviceregistry.endpoints.insert',
              ordered_params=[u'project'],
              path_params=[u'project'],
              query_params=[],
              relative_path=u'projects/{project}/global/endpoints',
              request_field=u'endpoint',
              request_type_name=u'ServiceregistryEndpointsInsertRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'serviceregistry.endpoints.list',
              ordered_params=[u'project'],
              path_params=[u'project'],
              query_params=[u'filter', u'maxResults', u'pageToken'],
              relative_path=u'projects/{project}/global/endpoints',
              request_field='',
              request_type_name=u'ServiceregistryEndpointsListRequest',
              response_type_name=u'EndpointsListResponse',
              supports_download=False,
          ),
          'Patch': base_api.ApiMethodInfo(
              http_method=u'PATCH',
              method_id=u'serviceregistry.endpoints.patch',
              ordered_params=[u'project', u'endpoint'],
              path_params=[u'endpoint', u'project'],
              query_params=[],
              relative_path=u'projects/{project}/global/endpoints/{endpoint}',
              request_field=u'endpointResource',
              request_type_name=u'ServiceregistryEndpointsPatchRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'Update': base_api.ApiMethodInfo(
              http_method=u'PUT',
              method_id=u'serviceregistry.endpoints.update',
              ordered_params=[u'project', u'endpoint'],
              path_params=[u'endpoint', u'project'],
              query_params=[],
              relative_path=u'projects/{project}/global/endpoints/{endpoint}',
              request_field=u'endpointResource',
              request_type_name=u'ServiceregistryEndpointsUpdateRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      """Deletes an endpoint.

      Args:
        request: (ServiceregistryEndpointsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Get(self, request, global_params=None):
      """Gets an endpoint.

      Args:
        request: (ServiceregistryEndpointsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Endpoint) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Insert(self, request, global_params=None):
      """Creates an endpoint.

      Args:
        request: (ServiceregistryEndpointsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    def List(self, request, global_params=None):
      """Lists endpoints for a project.

      Args:
        request: (ServiceregistryEndpointsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EndpointsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Patch(self, request, global_params=None):
      """Updates an endpoint. This method supports patch semantics.

      Args:
        request: (ServiceregistryEndpointsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    def Update(self, request, global_params=None):
      """Updates an endpoint.

      Args:
        request: (ServiceregistryEndpointsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(ServiceregistryV1alpha.OperationsService, self).__init__(client)
      self._method_configs = {
          'Get': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'serviceregistry.operations.get',
              ordered_params=[u'project', u'operation'],
              path_params=[u'operation', u'project'],
              query_params=[],
              relative_path=u'projects/{project}/global/operations/{operation}',
              request_field='',
              request_type_name=u'ServiceregistryOperationsGetRequest',
              response_type_name=u'Operation',
              supports_download=False,
          ),
          'List': base_api.ApiMethodInfo(
              http_method=u'GET',
              method_id=u'serviceregistry.operations.list',
              ordered_params=[u'project'],
              path_params=[u'project'],
              query_params=[u'filter', u'maxResults', u'pageToken'],
              relative_path=u'projects/{project}/global/operations',
              request_field='',
              request_type_name=u'ServiceregistryOperationsListRequest',
              response_type_name=u'OperationsListResponse',
              supports_download=False,
          ),
          }

      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      """Gets information about a specific operation.

      Args:
        request: (ServiceregistryOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    def List(self, request, global_params=None):
      """Lists all operations for a project.

      Args:
        request: (ServiceregistryOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationsListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)
