/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets.htmldoclet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ExternalDocSet {
    private String url;
    private String packageListDir;
    private URL docSetDirectoryURL;
    private Set packageNames = new HashSet();
    private boolean javadocCompatible;

    public String getPackageListDir() {
        return this.packageListDir;
    }

    public ExternalDocSet(String url, String packageListDir) {
        this.url = url;
        this.packageListDir = packageListDir;
    }

    public void load(File targetDirectory) throws IOException, MalformedURLException {
        URL packageListDirURL;
        if (!this.url.endsWith("/")) {
            this.url = String.valueOf(this.url) + "/";
        }
        this.docSetDirectoryURL = new URL(targetDirectory.toURL(), this.url);
        if (this.packageListDir != null) {
            if (!this.packageListDir.endsWith("/")) {
                this.packageListDir = String.valueOf(this.packageListDir) + "/";
            }
            packageListDirURL = new URL(new File(System.getProperty("user.dir")).toURL(), this.packageListDir);
        } else {
            packageListDirURL = this.docSetDirectoryURL;
        }
        URL packageListURL = new URL(packageListDirURL, "package-list");
        InputStream in = packageListURL.openStream();
        if (in == null) {
            throw new FileNotFoundException(packageListURL.toString());
        }
        this.readPackages(in);
        in.close();
        URL gjdocPropertiesURL = new URL(packageListDirURL, "gjdoc.properties");
        try {
            InputStream propertiesIn = gjdocPropertiesURL.openStream();
            if (in != null) {
                Properties properties = new Properties();
                properties.load(propertiesIn);
                propertiesIn.close();
                String gjdocCompatProperty = properties.getProperty("gjdoc.compat");
                this.javadocCompatible = gjdocCompatProperty != null ? "true".equals(properties.getProperty("gjdoc.compat")) : true;
            } else {
                this.javadocCompatible = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.javadocCompatible = true;
        }
    }

    public String getPackageDocURL(String packageName) {
        try {
            URL packageURL = new URL(this.docSetDirectoryURL, packageName.replace('.', '/'));
            return packageURL.toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getClassDocURL(String packageName, String typeName) {
        try {
            URL fileURL = new URL(this.docSetDirectoryURL, String.valueOf(packageName.replace('.', '/')) + "/" + typeName + ".html");
            return fileURL.toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readPackages(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            this.packageNames.add(line);
        }
    }

    public Set getPackageNames() {
        return this.packageNames;
    }

    public boolean isJavadocCompatible() {
        return this.javadocCompatible;
    }
}

