/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly;

    public MetalComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list2) {
        this(cb, i, cb.isEditable(), pane, list2);
    }

    public MetalComboBoxButton(JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list2) {
        if (cb == null) {
            throw new NullPointerException("Null 'cb' argument");
        }
        this.comboBox = cb;
        this.comboIcon = i;
        this.iconOnly = onlyIcon;
        this.listBox = list2;
        this.rendererPane = pane;
        this.setRolloverEnabled(false);
        this.setEnabled(this.comboBox.isEnabled());
        this.setFocusable(this.comboBox.isEnabled());
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int w = this.getWidth() - (insets.left + insets.right);
        int h = this.getHeight() - (insets.top + insets.bottom);
        if (h > 0 && w > 0) {
            int x1 = insets.left;
            int y1 = insets.top;
            int x2 = x1 + (w - 1);
            int y2 = y1 + (h - 1);
            int iconWidth = 0;
            int iconX = x2;
            if (this.comboIcon != null) {
                int iconY;
                iconWidth = this.comboIcon.getIconWidth();
                int iconHeight = this.comboIcon.getIconHeight();
                if (this.iconOnly) {
                    iconX = this.getWidth() / 2 - iconWidth / 2;
                    iconY = this.getHeight() / 2 - iconHeight / 2;
                } else {
                    iconX = x1 + (w - 1) - iconWidth;
                    iconY = y1 + (y2 - y1) / 2 - iconHeight / 2;
                }
                this.comboIcon.paintIcon(this, g, iconX, iconY);
                if (this.hasFocus()) {
                    g.setColor(MetalLookAndFeel.getFocusColor());
                    g.drawRect(x1 - 1, y1 - 1, w + 3, h + 1);
                }
            }
            if (!this.iconOnly && this.comboBox != null) {
                ListCellRenderer renderer = this.comboBox.getRenderer();
                this.getModel().isPressed();
                Component comp = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
                comp.setFont(this.rendererPane.getFont());
                if (this.model.isArmed() && this.model.isPressed() || this.comboBox.isFocusOwner() && !this.comboBox.isPopupVisible()) {
                    if (this.isOpaque()) {
                        comp.setBackground(UIManager.getColor("Button.select"));
                        comp.setForeground(this.comboBox.getForeground());
                    }
                } else if (!this.comboBox.isEnabled()) {
                    if (this.isOpaque()) {
                        Color dbg = UIManager.getColor("ComboBox.disabledBackground");
                        comp.setBackground(dbg);
                        Color dfg = UIManager.getColor("ComboBox.disabledForeground");
                        comp.setForeground(dfg);
                    }
                } else {
                    comp.setForeground(this.comboBox.getForeground());
                    comp.setBackground(this.comboBox.getBackground());
                }
                int wr = w - (insets.right + iconWidth);
                this.rendererPane.paintComponent(g, comp, this, x1, y1, wr, h);
            }
        }
    }
}

