/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.lang.CPStringBuilder;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    boolean focusCycleRoot;
    private boolean focusTraversalPolicyProvider;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("no such component");
            }
            return this.component[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] result = new Component[this.ncomponents];
            if (this.ncomponents > 0) {
                System.arraycopy(this.component, 0, result, 0, this.ncomponents);
            }
            return result;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        Insets i = this.peer == null || this.peer instanceof LightweightPeer ? new Insets(0, 0, 0, 0) : ((ContainerPeer)this.peer).getInsets();
        return i;
    }

    public Component add(Component comp) {
        this.addImpl(comp, null, -1);
        return comp;
    }

    public Component add(String name, Component comp) {
        this.addImpl(comp, name, -1);
        return comp;
    }

    public Component add(Component comp, int index) {
        this.addImpl(comp, null, index);
        return comp;
    }

    public void add(Component comp, Object constraints) {
        this.addImpl(comp, constraints, -1);
    }

    public void add(Component comp, Object constraints, int index) {
        this.addImpl(comp, constraints, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int childHierarchyBoundsListeners;
            if (index > this.ncomponents || index < 0 && index != -1 || comp instanceof Window || comp instanceof Container && ((Container)comp).isAncestorOf(this)) {
                throw new IllegalArgumentException();
            }
            if (comp.parent != null) {
                comp.parent.remove(comp);
            }
            if (this.component == null) {
                this.component = new Component[4];
            }
            if (this.ncomponents >= this.component.length) {
                int nl = this.component.length * 2;
                Component[] c = new Component[nl];
                System.arraycopy(this.component, 0, c, 0, this.ncomponents);
                this.component = c;
            }
            if (index == -1) {
                this.component[this.ncomponents++] = comp;
            } else {
                System.arraycopy(this.component, index, this.component, index + 1, this.ncomponents - index);
                this.component[index] = comp;
                ++this.ncomponents;
            }
            comp.parent = this;
            int childHierarchyListeners = comp.numHierarchyListeners;
            if (childHierarchyListeners > 0) {
                this.updateHierarchyListenerCount(32768L, childHierarchyListeners);
            }
            if ((childHierarchyBoundsListeners = comp.numHierarchyBoundsListeners) > 0) {
                this.updateHierarchyListenerCount(65536L, childHierarchyListeners);
            }
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                comp.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
                    lm2.addLayoutComponent(comp, constraints);
                } else if (constraints instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)constraints, comp);
                } else {
                    this.layoutMgr.addLayoutComponent("", comp);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                ContainerEvent ce = new ContainerEvent(this, 300, comp);
                this.dispatchEvent(ce);
            }
            comp.fireHierarchyEvent(1400, comp, this, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int childHierarchyBoundsListeners;
            int childHierarchyListeners;
            if (index < 0 || index >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Component r = this.component[index];
            if (this.peer != null) {
                r.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(r);
            }
            if ((childHierarchyListeners = r.numHierarchyListeners) > 0) {
                this.updateHierarchyListenerCount(32768L, -childHierarchyListeners);
            }
            if ((childHierarchyBoundsListeners = r.numHierarchyBoundsListeners) > 0) {
                this.updateHierarchyListenerCount(65536L, -childHierarchyListeners);
            }
            r.parent = null;
            System.arraycopy(this.component, index + 1, this.component, index, this.ncomponents - index - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                ContainerEvent ce = new ContainerEvent(this, 301, r);
                this.dispatchEvent(ce);
            }
            r.fireHierarchyEvent(1400, r, this, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = 0;
            while (i < this.ncomponents) {
                if (this.component[i] == comp) {
                    this.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (this.ncomponents > 0) {
                int childHierarchyBoundsListeners;
                int childHierarchyListeners;
                --this.ncomponents;
                Component r = this.component[this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    r.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(r);
                }
                r.parent = null;
                if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                    ContainerEvent ce = new ContainerEvent(this, 301, r);
                    this.dispatchEvent(ce);
                }
                if ((childHierarchyListeners = r.numHierarchyListeners) > 0) {
                    this.updateHierarchyListenerCount(32768L, -childHierarchyListeners);
                }
                if ((childHierarchyBoundsListeners = r.numHierarchyBoundsListeners) > 0) {
                    this.updateHierarchyListenerCount(65536L, -childHierarchyListeners);
                }
                this.fireHierarchyEvent(1400, r, this, 1L);
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager mgr) {
        this.layoutMgr = mgr;
        if (this.valid) {
            this.invalidate();
        }
    }

    @Override
    public void doLayout() {
        this.layout();
    }

    @Override
    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            lm2.invalidateLayout(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        ComponentPeer p = this.peer;
        if (!this.valid && p != null) {
            ContainerPeer cPeer = null;
            if (p instanceof ContainerPeer) {
                cPeer = (ContainerPeer)this.peer;
            }
            Object object = this.getTreeLock();
            synchronized (object) {
                if (cPeer != null) {
                    cPeer.beginValidate();
                }
                this.validateTree();
                this.valid = true;
                if (cPeer != null) {
                    cPeer.endValidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = 0;
            while (i < this.ncomponents) {
                Component comp = this.component[i];
                if (comp instanceof Container) {
                    ((Container)comp).invalidateTree();
                } else if (comp.valid) {
                    comp.invalidate();
                }
                ++i;
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            ContainerPeer cPeer = null;
            if (this.peer instanceof ContainerPeer) {
                cPeer = (ContainerPeer)this.peer;
                cPeer.beginLayout();
            }
            this.doLayout();
            int i = 0;
            while (i < this.ncomponents) {
                Component comp = this.component[i];
                if (comp instanceof Container && !(comp instanceof Window) && !comp.valid) {
                    ((Container)comp).validateTree();
                } else {
                    comp.validate();
                }
                ++i;
            }
            if (cPeer != null) {
                cPeer = (ContainerPeer)this.peer;
                cPeer.endLayout();
            }
        }
        this.valid = true;
    }

    @Override
    public void setFont(Font f) {
        Font oldFont = this.getFont();
        super.setFont(f);
        Font newFont = this.getFont();
        if (!(newFont == oldFont || oldFont != null && oldFont.equals(newFont))) {
            this.invalidateTree();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredSize() {
        Dimension size = this.prefSize;
        if (size == null || !this.prefSizeSet && !this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager l = this.layoutMgr;
                this.prefSize = l != null ? l.preferredLayoutSize(this) : super.preferredSizeImpl();
                size = this.prefSize;
            }
        }
        if (size != null) {
            return new Dimension(size);
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumSize() {
        Dimension size = this.minSize;
        if (size == null || !this.minSizeSet && !this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager l = this.layoutMgr;
                this.minSize = l != null ? l.minimumLayoutSize(this) : super.minimumSizeImpl();
                size = this.minSize;
            }
        }
        if (size != null) {
            return new Dimension(size);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMaximumSize() {
        Dimension size = this.maxSize;
        if (size == null || !this.maxSizeSet && !this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager l = this.layoutMgr;
                this.maxSize = l instanceof LayoutManager2 ? ((LayoutManager2)l).maximumLayoutSize(this) : super.maximumSizeImpl();
                size = this.maxSize;
            }
        }
        if (size != null) {
            return new Dimension(size);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAlignmentX() {
        LayoutManager layout = this.getLayout();
        float alignmentX = 0.0f;
        if (layout != null && layout instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 lm2 = (LayoutManager2)layout;
                alignmentX = lm2.getLayoutAlignmentX(this);
            }
        } else {
            alignmentX = super.getAlignmentX();
        }
        return alignmentX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAlignmentY() {
        LayoutManager layout = this.getLayout();
        float alignmentY = 0.0f;
        if (layout != null && layout instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 lm2 = (LayoutManager2)layout;
                alignmentY = lm2.getLayoutAlignmentY(this);
            }
        } else {
            alignmentY = super.getAlignmentY();
        }
        return alignmentY;
    }

    @Override
    public void paint(Graphics g) {
        if (this.isShowing()) {
            this.visitChildren(g, GfxPaintVisitor.INSTANCE, true);
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.isShowing()) {
            ComponentPeer p = this.peer;
            if (!(p instanceof LightweightPeer)) {
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.paint(g);
        }
    }

    @Override
    public void print(Graphics g) {
        super.print(g);
        this.visitChildren(g, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics g) {
        if (this.isShowing()) {
            this.visitChildren(g, GfxPaintAllVisitor.INSTANCE, false);
        }
    }

    public void printComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener listener) {
        if (listener != null) {
            this.containerListener = AWTEventMulticaster.add(this.containerListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeContainerListener(ContainerListener listener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, listener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])AWTEventMulticaster.getListeners((EventListener)this.containerListener, ContainerListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ContainerListener.class) {
            return this.getContainerListeners();
        }
        return super.getListeners(listenerType);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processContainerEvent(ContainerEvent e) {
        if (this.containerListener == null) {
            return;
        }
        switch (e.id) {
            case 300: {
                this.containerListener.componentAdded(e);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverEvent(Event e) {
        if (!this.handleEvent(e)) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Container parent = this.getParent();
                if (parent != null) {
                    ((Component)parent).deliverEvent(e);
                }
            }
        }
    }

    @Override
    public Component getComponentAt(int x, int y) {
        return this.locate(x, y);
    }

    public Point getMousePosition(boolean allowChildren) throws HeadlessException {
        return super.getMousePositionHelper(allowChildren);
    }

    @Override
    boolean mouseOverComponent(Component component, boolean allowChildren) {
        if (allowChildren) {
            return this.isAncestorOf(component);
        }
        return component == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component locate(int x, int y) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int y2;
            int x2;
            Component comp;
            block8: {
                if (this.contains(x, y)) break block8;
                return null;
            }
            int i = 0;
            while (i < this.ncomponents) {
                comp = this.component[i];
                x2 = x - comp.x;
                y2 = y - comp.y;
                if (comp.contains(x2, y2) && !comp.isLightweight()) {
                    return comp;
                }
                ++i;
            }
            i = 0;
            while (i < this.ncomponents) {
                comp = this.component[i];
                x2 = x - comp.x;
                y2 = y - comp.y;
                if (comp.contains(x2, y2) && comp.isLightweight()) {
                    return comp;
                }
                ++i;
            }
            return this;
        }
    }

    @Override
    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component findComponentAt(int x, int y) {
        Object object = this.getTreeLock();
        synchronized (object) {
            block10: {
                if (this.contains(x, y)) break block10;
                return null;
            }
            int i = 0;
            while (i < this.ncomponents) {
                if (this.component[i].isVisible()) {
                    int x2 = x - this.component[i].x;
                    int y2 = y - this.component[i].y;
                    if (this.component[i] instanceof Container) {
                        Container k = (Container)this.component[i];
                        Component r = k.findComponentAt(x2, y2);
                        if (r != null) {
                            return r;
                        }
                    } else if (this.component[i].contains(x2, y2)) {
                        return this.component[i];
                    }
                }
                ++i;
            }
            return this;
        }
    }

    public Component findComponentAt(Point p) {
        return this.findComponentAt(p.x, p.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            this.addNotifyContainerChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int ncomps = this.ncomponents;
            Component[] comps = this.component;
            int i = ncomps - 1;
            while (i >= 0) {
                Component comp = comps[i];
                if (comp != null) {
                    comp.removeNotify();
                }
                --i;
            }
            super.removeNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAncestorOf(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            do {
                if (comp != null) continue;
                return false;
            } while ((comp = comp.getParent()) != this);
            return true;
        }
    }

    @Override
    protected String paramString() {
        if (this.layoutMgr == null) {
            return super.paramString();
        }
        CPStringBuilder sb = new CPStringBuilder();
        sb.append(super.paramString());
        sb.append(",layout=");
        sb.append(this.layoutMgr.getClass().getName());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(PrintStream out, int indent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(out, indent);
            int i = 0;
            while (i < this.ncomponents) {
                this.component[i].list(out, indent + 2);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(PrintWriter out, int indent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(out, indent);
            int i = 0;
            while (i < this.ncomponents) {
                this.component[i].list(out, indent + 2);
                ++i;
            }
        }
    }

    @Override
    public void setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
        String name;
        Set<AWTKeyStroke> sc;
        Set<AWTKeyStroke> sb;
        Set<AWTKeyStroke> sa;
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        if (keystrokes == null) {
            Container parent = this.getParent();
            while (parent != null) {
                if (parent.areFocusTraversalKeysSet(id)) {
                    keystrokes = parent.getFocusTraversalKeys(id);
                    break;
                }
                parent = parent.getParent();
            }
            if (keystrokes == null) {
                keystrokes = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
            }
        }
        switch (id) {
            case 0: {
                sa = this.getFocusTraversalKeys(1);
                sb = this.getFocusTraversalKeys(2);
                sc = this.getFocusTraversalKeys(3);
                name = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(2);
                sc = this.getFocusTraversalKeys(3);
                name = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                sc = this.getFocusTraversalKeys(3);
                name = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                sc = this.getFocusTraversalKeys(2);
                name = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator<? extends AWTKeyStroke> iter = keystrokes.iterator();
        while (--i >= 0) {
            AWTKeyStroke o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && !sc.contains(o) && o.keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[4];
        }
        keystrokes = Collections.unmodifiableSet(new HashSet<AWTKeyStroke>(keystrokes));
        this.firePropertyChange(name, this.focusTraversalKeys[id], keystrokes);
        this.focusTraversalKeys[id] = keystrokes;
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        Set<AWTKeyStroke> s = null;
        if (this.focusTraversalKeys != null) {
            s = this.focusTraversalKeys[id];
        }
        if (s == null && this.parent != null) {
            s = this.parent.getFocusTraversalKeys(id);
        }
        return s == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id) : s;
    }

    @Override
    public boolean areFocusTraversalKeysSet(int id) {
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[id] != null;
    }

    @Override
    public boolean isFocusCycleRoot(Container c) {
        if (this == c && this.isFocusCycleRoot()) {
            return true;
        }
        Container ancestor = this.getFocusCycleRootAncestor();
        return c == ancestor;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.focusTraversalPolicy = policy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container ancestor = this.getFocusCycleRootAncestor();
            if (ancestor != this && ancestor != null) {
                return ancestor.getFocusTraversalPolicy();
            }
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return manager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy == null;
    }

    public void setFocusCycleRoot(boolean focusCycleRoot) {
        this.focusCycleRoot = focusCycleRoot;
    }

    public final boolean isFocusTraversalPolicyProvider() {
        return this.focusTraversalPolicyProvider;
    }

    public final void setFocusTraversalPolicyProvider(boolean b) {
        this.focusTraversalPolicyProvider = b;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            fm.setGlobalCurrentFocusCycleRoot(this);
            FocusTraversalPolicy policy = this.getFocusTraversalPolicy();
            Component defaultComponent = policy.getDefaultComponent(this);
            if (defaultComponent != null) {
                defaultComponent.requestFocus();
            }
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation orientation) {
        if (orientation == null) {
            throw new NullPointerException();
        }
        this.setComponentOrientation(orientation);
        int i = 0;
        while (i < this.ncomponents) {
            if (this.component[i] instanceof Container) {
                ((Container)this.component[i]).applyComponentOrientation(orientation);
            } else {
                this.component[i].setComponentOrientation(orientation);
            }
            ++i;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setComponentZOrder(Component comp, int index) {
        if (comp == null) {
            throw new NullPointerException("comp must not be null");
        }
        if (comp instanceof Container && ((Container)comp).isAncestorOf(this)) {
            throw new IllegalArgumentException("comp must not be an ancestor of this");
        }
        if (comp instanceof Window) {
            throw new IllegalArgumentException("comp must not be a Window");
        }
        if (comp == this) {
            throw new IllegalArgumentException("cannot add component to itself");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (comp.getParent() != this) {
                throw new AssertionError((Object)"Reparenting is not implemented yet");
            }
            int currentIndex = this.getComponentZOrder(comp);
            if (currentIndex < index) {
                System.arraycopy(this.component, currentIndex + 1, this.component, currentIndex, index - currentIndex);
            } else {
                System.arraycopy(this.component, index, this.component, index + 1, currentIndex - index);
            }
            this.component[index] = comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getComponentZOrder(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int index = -1;
            if (this.component != null) {
                int i = 0;
                while (i < this.ncomponents) {
                    if (this.component[i] == comp) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitChildren(Graphics gfx, GfxVisitor visitor, boolean lightweightOnly) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = this.ncomponents - 1;
            while (i >= 0) {
                boolean applicable;
                Component comp = this.component[i];
                boolean bl = applicable = comp.isVisible() && (comp.isLightweight() || !lightweightOnly);
                if (applicable) {
                    this.visitChild(gfx, visitor, comp);
                }
                --i;
            }
        }
    }

    private void visitChild(Graphics gfx, GfxVisitor visitor, Component comp) {
        Rectangle bounds = comp.getBounds();
        if (!gfx.hitClip(bounds.x, bounds.y, bounds.width, bounds.height)) {
            return;
        }
        Graphics g2 = gfx.create(bounds.x, bounds.y, bounds.width, bounds.height);
        try {
            g2.setFont(comp.getFont());
            visitor.visit(comp, g2);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        LightweightDispatcher dispatcher = LightweightDispatcher.getInstance();
        if (!this.isLightweight() && dispatcher.dispatchEvent(e)) {
            e.consume();
            ComponentPeer p = this.peer;
            if (p != null) {
                p.handleEvent(e);
            }
        } else {
            super.dispatchEventImpl(e);
        }
    }

    void dispatchNoLightweight(AWTEvent e) {
        super.dispatchEventImpl(e);
    }

    @Override
    boolean eventTypeEnabled(int eventId) {
        if (eventId <= 301 && eventId >= 300) {
            return this.containerListener != null || (this.eventMask & 2L) != 0L;
        }
        return super.eventTypeEnabled(eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Component findNextFocusComponent(Component child) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int end;
            int start;
            if (child != null) {
                start = 0;
                while (start < this.ncomponents) {
                    if (this.component[start] == child) break;
                    ++start;
                }
                end = start;
                if (end == 0) {
                    end = this.ncomponents;
                }
                ++start;
            } else {
                start = 0;
                end = this.ncomponents;
            }
            int j = start;
            while (j != end) {
                if (j >= this.ncomponents) {
                    if (this.parent != null) {
                        return this.parent.findNextFocusComponent(this);
                    }
                    j -= this.ncomponents;
                }
                if (this.component[j] instanceof Container) {
                    Component c = this.component[j];
                    if ((c = c.findNextFocusComponent(null)) != null) {
                        return c;
                    }
                } else if (this.component[j].isFocusTraversable()) {
                    return this.component[j];
                }
                ++j;
            }
            return null;
        }
    }

    @Override
    void fireHierarchyEvent(int id, Component changed, Container parent, long flags) {
        if (id == 1400 && this.numHierarchyListeners > 0 || (id == 1401 || id == 1402) && this.numHierarchyBoundsListeners > 0) {
            int i = 0;
            while (i < this.ncomponents) {
                this.component[i].fireHierarchyEvent(id, changed, parent, flags);
                ++i;
            }
            super.fireHierarchyEvent(id, changed, parent, flags);
        }
    }

    void updateHierarchyListenerCount(long type, int delta) {
        if (type == 65536L) {
            this.numHierarchyBoundsListeners += delta;
        } else if (type == 32768L) {
            this.numHierarchyListeners += delta;
        } else assert (false) : "Should not reach here";
        if (this.parent != null) {
            this.parent.updateHierarchyListenerCount(type, delta);
        }
    }

    @Override
    void notifyReshape(boolean resized, boolean moved) {
        super.notifyReshape(resized, moved);
        if (this.ncomponents > 0) {
            Component child;
            int i;
            if (resized) {
                i = 0;
                while (i < this.getComponentCount()) {
                    child = this.getComponent(i);
                    child.fireHierarchyEvent(1402, this, this.parent, 0L);
                    ++i;
                }
            }
            if (moved) {
                i = 0;
                while (i < this.getComponentCount()) {
                    child = this.getComponent(i);
                    child.fireHierarchyEvent(1401, this, this.parent, 0L);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = this.ncomponents;
            while (--i >= 0) {
                this.component[i].addNotify();
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        String key = (String)s.readObject();
        while (key != null) {
            Object object = s.readObject();
            if ("containerL".equals(key)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(key)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            key = (String)s.readObject();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            s.writeObject(this.focusTraversalPolicy);
        } else {
            s.writeObject(null);
        }
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler;

        protected AccessibleAWTContainer() {
            super(Container.this);
            this.accessibleContainerHandler = new AccessibleContainerHandler();
            Container.this.addContainerListener(this.accessibleContainerHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getAccessibleChildrenCount() {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                int count = 0;
                int i = Container.this.component == null ? 0 : Container.this.component.length;
                while (--i >= 0) {
                    if (!(Container.this.component[i] instanceof Accessible)) continue;
                    ++count;
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Accessible getAccessibleChild(int i) {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                block6: {
                    if (Container.this.component != null) break block6;
                    return null;
                }
                int index = -1;
                while (i >= 0 && ++index < Container.this.component.length) {
                    if (!(Container.this.component[index] instanceof Accessible)) continue;
                    --i;
                }
                if (i < 0) {
                    return (Accessible)((Object)Container.this.component[index]);
                }
                return null;
            }
        }

        public Accessible getAccessibleAt(Point p) {
            Component c = Container.this.getComponentAt(p.x, p.y);
            return c != Container.this && c instanceof Accessible ? (Accessible)((Object)c) : null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent e) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, e.getChild());
            }

            public void componentRemoved(ContainerEvent e) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", e.getChild(), null);
            }
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        GfxPaintAllVisitor() {
        }

        public void visit(Component c, Graphics gfx) {
            c.paintAll(gfx);
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        GfxPaintVisitor() {
        }

        public void visit(Component c, Graphics gfx) {
            c.paint(gfx);
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        GfxPrintAllVisitor() {
        }

        public void visit(Component c, Graphics gfx) {
            c.printAll(gfx);
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        GfxPrintVisitor() {
        }

        public void visit(Component c, Graphics gfx) {
            c.print(gfx);
        }
    }

    static abstract class GfxVisitor {
        GfxVisitor() {
        }

        public abstract void visit(Component var1, Graphics var2);
    }
}

