/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.ServerHello;
import java.nio.ByteBuffer;

public class ServerHelloBuilder
extends ServerHello
implements Builder {
    public ServerHelloBuilder() {
        super(ByteBuffer.allocate(70));
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setVersion(ProtocolVersion version) {
        this.buffer.putShort(0, (short)version.rawValue());
    }

    public void setSessionId(byte[] sessionId) {
        this.setSessionId(sessionId, 0, sessionId.length);
    }

    public void setSessionId(byte[] sessionId, int offset, int length) {
        if (length < 0 || length > 32) {
            throw new IllegalArgumentException("length must be between 0 and 32");
        }
        this.buffer.put(34, (byte)length);
        ((ByteBuffer)this.buffer.duplicate().position(35)).put(sessionId, offset, length);
    }

    public void setCipherSuite(CipherSuite suite) {
        int offset = 34 + (this.buffer.get(34) & 0xFF) + 1;
        ((ByteBuffer)this.buffer.duplicate().position(offset)).put(suite.id());
    }

    public void setCompressionMethod(CompressionMethod comp) {
        int offset = 34 + (this.buffer.get(34) & 0xFF) + 3;
        this.buffer.put(offset, (byte)comp.getValue());
    }

    public void setDisableExtensions(boolean disable) {
        this.disableExtensions = disable;
    }

    public void setExtensionsLength(int length) {
        if (length < 0 || length > 16384) {
            throw new IllegalArgumentException("length must be nonnegative and not exceed 16384");
        }
        int needed = 35 + (this.buffer.get(34) & 0xFF) + 5 + length;
        if (this.buffer.capacity() < needed) {
            this.ensureCapacity(needed);
        }
        this.buffer.putShort(35 + (this.buffer.get(34) & 0xFF) + 3, (short)length);
    }

    public void setExtensions(ByteBuffer extensions) {
        extensions = (ByteBuffer)extensions.duplicate().limit(extensions.position() + this.extensionsLength());
        ((ByteBuffer)this.buffer.duplicate().position(35 + (this.buffer.get(34) & 0xFF))).put(extensions);
    }

    public void ensureCapacity(int newCapacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        newBuffer.put(this.buffer);
        newBuffer.position(0);
        this.buffer = newBuffer;
    }
}

