/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateURL
extends Extension.Value
implements Iterable<URLAndOptionalHash> {
    private ByteBuffer buffer;

    public CertificateURL(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public CertificateURL(CertChainType type, List<URLAndOptionalHash> urls) {
        int length = 3;
        for (URLAndOptionalHash url : urls) {
            length += url.length();
        }
        this.buffer = ByteBuffer.allocate(length);
        this.buffer.put((byte)type.getValue());
        this.buffer.putShort((short)(length - 1));
        for (URLAndOptionalHash url : urls) {
            this.buffer.put(url.buffer());
        }
        this.buffer.rewind();
    }

    @Override
    public int length() {
        return 3 + (this.buffer.getShort(1) & 0xFFFF);
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public CertChainType type() {
        switch (this.buffer.get(0)) {
            case 0: {
                return CertChainType.INDIVIDUAL_CERTS;
            }
            case 1: {
                return CertChainType.PKIPATH;
            }
        }
        throw new IllegalArgumentException("unknown certificate URL type");
    }

    public int size() {
        int len = this.buffer.getShort(1) & 0xFFFF;
        int n = 0;
        int i = 3;
        while (i < len) {
            URLAndOptionalHash u = new URLAndOptionalHash((ByteBuffer)this.buffer.duplicate().position(i));
            int l = u.length();
            i += l;
            ++n;
        }
        return n;
    }

    public URLAndOptionalHash get(int index) {
        int len = this.buffer.getShort(1) & 0xFFFF;
        int n = 0;
        int l = 0;
        int i = 3;
        while (i < len && n < index) {
            URLAndOptionalHash u = new URLAndOptionalHash((ByteBuffer)this.buffer.duplicate().position(i));
            l = u.length();
            i += l;
            ++n;
        }
        if (n < index) {
            throw new IndexOutOfBoundsException();
        }
        return new URLAndOptionalHash(((ByteBuffer)this.buffer.duplicate().position(i).limit(i + l)).slice());
    }

    public void set(int index, URLAndOptionalHash url) {
        int len = this.buffer.getShort(1) & 0xFFFF;
        int n = 0;
        int i = 3;
        while (i < len && n < index - 1) {
            URLAndOptionalHash u = new URLAndOptionalHash((ByteBuffer)this.buffer.duplicate().position(i));
            int l = u.length();
            i += l;
            ++n;
        }
        if (n < index - 1) {
            throw new IndexOutOfBoundsException();
        }
        int l = url.urlLength();
        this.buffer.putShort(i, (short)l);
        ((ByteBuffer)this.buffer.duplicate().position(i + 2)).put(url.urlBuffer());
        this.buffer.put(i + l + 2, (byte)(url.hashPresent() ? 1 : 0));
        if (url.hashPresent()) {
            ((ByteBuffer)this.buffer.duplicate().position(i + l + 3)).put(url.sha1Hash());
        }
    }

    public void setLength(int length) {
        if (length < 0 || length > 65535) {
            throw new IllegalArgumentException("length must be between 0 and 65535");
        }
        this.buffer.putShort(1, (short)length);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  type = ");
        out.print((Object)this.type());
        out.println(";");
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  url_and_hash_list = {");
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        for (URLAndOptionalHash url : this) {
            out.println(url.toString(subprefix));
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  };");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} CertificateURL;");
        return str.toString();
    }

    @Override
    public java.util.Iterator<URLAndOptionalHash> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertChainType {
        INDIVIDUAL_CERTS(0),
        PKIPATH(1);

        private final int value;

        private CertChainType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<URLAndOptionalHash> {
        private int index = 0;

        @Override
        public URLAndOptionalHash next() throws NoSuchElementException {
            try {
                return CertificateURL.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < CertificateURL.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class URLAndOptionalHash
    implements Builder,
    Constructed {
        private ByteBuffer buffer;

        public URLAndOptionalHash(ByteBuffer buffer) {
            this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        }

        public URLAndOptionalHash(String url) {
            this(url, null);
        }

        public URLAndOptionalHash(String url, byte[] hash) {
            if (hash != null && hash.length < 20) {
                throw new IllegalArgumentException();
            }
            int length = 3 + url.length();
            if (hash != null) {
                length += 20;
            }
            this.buffer = ByteBuffer.allocate(length);
            this.buffer.putShort((short)url.length());
            Charset cs = Charset.forName("US-ASCII");
            CharsetEncoder ascii = cs.newEncoder();
            ascii.encode(CharBuffer.wrap(url), this.buffer, true);
            this.buffer.put((byte)(hash != null ? 1 : 0));
            if (hash != null) {
                this.buffer.put(hash, 0, 20);
            }
            this.buffer.rewind();
        }

        public int length() {
            return (this.buffer.getShort(0) & 0xFFFF) + (this.hashPresent() ? 23 : 3);
        }

        public ByteBuffer buffer() {
            return (ByteBuffer)this.buffer.duplicate().limit(this.length());
        }

        public String url() {
            Charset cs = Charset.forName("ASCII");
            return cs.decode(this.urlBuffer()).toString();
        }

        public int urlLength() {
            return this.buffer.getShort(0) & 0xFFFF;
        }

        public ByteBuffer urlBuffer() {
            int len = this.urlLength();
            return ((ByteBuffer)this.buffer.duplicate().position(2).limit(2 + len)).slice();
        }

        public boolean hashPresent() {
            int i = (this.buffer.getShort(0) & 0xFFFF) + 2;
            byte b = this.buffer.get(i);
            if (b == 0) {
                return false;
            }
            if (b == 1) {
                return true;
            }
            throw new IllegalArgumentException("expecting 0 or 1: " + (b & 0xFF));
        }

        public byte[] sha1Hash() {
            int i = (this.buffer.getShort(0) & 0xFFFF) + 2;
            byte b = this.buffer.get(i);
            if (b == 0) {
                return null;
            }
            byte[] buf = new byte[20];
            ((ByteBuffer)this.buffer.duplicate().position(i + 1)).get(buf);
            return buf;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String prefix) {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            if (prefix != null) {
                out.print(prefix);
            }
            out.println("struct {");
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  url = ");
            out.print(this.url());
            out.println(";");
            boolean has_hash = this.hashPresent();
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  hash_present = ");
            out.print(has_hash);
            out.println(";");
            if (has_hash) {
                if (prefix != null) {
                    out.print(prefix);
                }
                out.print("  sha1Hash = ");
                out.print(Util.toHexString(this.sha1Hash(), ':'));
                out.println(";");
            }
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("} URLAndOptionalHash;");
            return str.toString();
        }
    }
}

