/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.prng;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import java.util.Map;

public class MDGenerator
extends BasePRNG
implements Cloneable {
    public static final String MD_NAME = "gnu.crypto.prng.md.hash.name";
    public static final String SEEED = "gnu.crypto.prng.md.seed";
    private IMessageDigest md;

    public MDGenerator() {
        super("md");
    }

    public void setup(Map attributes) {
        String underlyingMD = (String)attributes.get(MD_NAME);
        if (underlyingMD == null) {
            if (this.md == null) {
                this.md = HashFactory.getInstance("sha-160");
            } else {
                this.md.reset();
            }
        } else {
            this.md = HashFactory.getInstance(underlyingMD);
        }
        byte[] seed = (byte[])attributes.get(SEEED);
        if (seed == null) {
            seed = new byte[]{};
        }
        this.md.update(seed, 0, seed.length);
    }

    public void fillBlock() throws LimitReachedException {
        IMessageDigest mdc = (IMessageDigest)this.md.clone();
        this.buffer = mdc.digest();
        this.md.update(this.buffer, 0, this.buffer.length);
    }

    public void addRandomByte(byte b) {
        if (this.md == null) {
            throw new IllegalStateException("not initialized");
        }
        this.md.update(b);
    }

    public void addRandomBytes(byte[] buf, int off, int len) {
        if (this.md == null) {
            throw new IllegalStateException("not initialized");
        }
        this.md.update(buf, off, len);
    }

    public Object clone() throws CloneNotSupportedException {
        MDGenerator result = (MDGenerator)super.clone();
        if (this.md != null) {
            result.md = (IMessageDigest)this.md.clone();
        }
        return result;
    }
}

