/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TransactionSession;

public class ServerGame
extends Game
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerGame.class.getName());
    private long lastTime = -1L;

    public ServerGame(Specification specification) {
        super(specification);
        this.combatModel = new SimpleCombatModel();
        this.currentPlayer = null;
    }

    public ServerGame(FreeColGameObjectListener freeColGameObjectListener, FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.freeColGameObjectListener = freeColGameObjectListener;
        this.setGame(this);
        this.readFromXML(xr);
    }

    public List<ServerPlayer> getConnectedPlayers(ServerPlayer ... serverPlayers) {
        return this.getLivePlayers(null).stream().map(p -> (ServerPlayer)p).filter(sp -> sp.isConnected() && CollectionUtils.none(serverPlayers, s -> s == sp)).collect(Collectors.toList());
    }

    public void sendToAll(ChangeSet cs, ServerPlayer ... serverPlayers) {
        List<ServerPlayer> live = this.getConnectedPlayers(new ServerPlayer[0]);
        for (ServerPlayer sp : serverPlayers) {
            if (live.contains(sp)) continue;
            live.add(sp);
        }
        this.sendToList(live, cs);
    }

    public void sendToOthers(ServerPlayer serverPlayer, ChangeSet cs) {
        this.sendToList(this.getConnectedPlayers(serverPlayer), cs);
    }

    public void sendToList(List<ServerPlayer> serverPlayers, ChangeSet cs) {
        for (ServerPlayer s : serverPlayers) {
            s.send(cs);
        }
    }

    private Object makeServerObject(String type, String id) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        type = "net.sf.freecol.server.model." + type.substring(0, 1).toUpperCase() + type.substring(1);
        Class<?> c = Class.forName(type);
        return c.getConstructor(Game.class, String.class).newInstance(this, id);
    }

    public List<ServerModelObject> getServerModelObjects() {
        ArrayList<ServerModelObject> objs = new ArrayList<ServerModelObject>();
        for (FreeColGameObject fcgo : this.getFreeColGameObjects()) {
            if (!(fcgo instanceof ServerModelObject)) continue;
            objs.add((ServerModelObject)((Object)fcgo));
        }
        return objs;
    }

    public void updatePlayers(List<ServerPlayer> players) {
        ChangeSet cs = new ChangeSet();
        for (ServerPlayer sp : players) {
            cs.addPlayer(sp);
        }
        this.sendToAll(cs, new ServerPlayer[0]);
    }

    @Override
    public String getNextId() {
        String id = Integer.toString(this.nextId);
        ++this.nextId;
        return id;
    }

    public void randomize(Random random) {
        if (random != null) {
            NameCache.requireCitiesOfCibola(random);
        }
    }

    public Player checkForWinner() {
        List winners;
        Player winner;
        Specification spec = this.getSpecification();
        if (spec.getBoolean("model.option.victoryDefeatREF") && (winner = CollectionUtils.find(this.getLiveEuropeanPlayers(null), p -> p.getPlayerType() == Player.PlayerType.INDEPENDENT)) != null) {
            return winner;
        }
        if (spec.getBoolean("model.option.victoryDefeatEuropeans") && (winners = this.getLiveEuropeanPlayers(null).stream().filter(p -> !p.isREF()).collect(Collectors.toList())).size() == 1) {
            return (Player)winners.get(0);
        }
        if (spec.getBoolean("model.option.victoryDefeatHumans") && (winners = this.getLiveEuropeanPlayers(null).stream().filter(p -> !p.isAI()).collect(Collectors.toList())).size() == 1) {
            return (Player)winners.get(0);
        }
        return null;
    }

    public boolean isNextPlayerInNewTurn() {
        Player nextPlayer = this.getNextPlayer();
        return this.players.indexOf(this.currentPlayer) > this.players.indexOf(nextPlayer) || this.currentPlayer == nextPlayer;
    }

    public void csNextTurn(ChangeSet cs) {
        String duration = null;
        long now = new Date().getTime();
        if (this.lastTime >= 0L) {
            duration = ", previous turn duration = " + (now - this.lastTime) + "ms";
        }
        this.lastTime = now;
        TransactionSession.completeAll(cs);
        this.setTurn(this.getTurn().next());
        logger.finest("Turn is now " + this.getTurn() + duration);
        cs.addTrivial(ChangeSet.See.all(), "newTurn", ChangeSet.ChangePriority.CHANGE_NORMAL, "turn", Integer.toString(this.getTurn().getNumber()));
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add("GAME ", this.getId(), ", ");
        for (Player player : this.getLivePlayers(null)) {
            ((ServerPlayer)player).csNewTurn(random, lb, cs);
        }
        Specification spec = this.getSpecification();
        Event succession = spec.getEvent("model.event.spanishSuccession");
        if (succession != null && !this.getSpanishSuccession()) {
            ServerPlayer serverPlayer = this.csSpanishSuccession(cs, lb, succession);
        }
    }

    private ServerPlayer csSpanishSuccession(ChangeSet cs, LogBuilder lb, Event event) {
        Limit yearLimit = event.getLimit("model.limit.spanishSuccession.year");
        if (!yearLimit.evaluate(this)) {
            return null;
        }
        Limit weakLimit = event.getLimit("model.limit.spanishSuccession.weakestPlayer");
        Limit strongLimit = event.getLimit("model.limit.spanishSuccession.strongestPlayer");
        HashMap<Player, Integer> scores = new HashMap<Player, Integer>();
        boolean ready = false;
        for (Player player : this.getLiveEuropeanPlayers(null)) {
            if (player.isREF()) continue;
            ready |= strongLimit.evaluate(player);
            if (!player.isAI()) continue;
            scores.put(player, player.getSpanishSuccessionScore());
        }
        if (!ready) {
            return null;
        }
        int bestScore = Integer.MIN_VALUE;
        int worstScore = Integer.MAX_VALUE;
        Player weakestAIPlayer = null;
        Player strongestAIPlayer = null;
        for (Map.Entry entry : scores.entrySet()) {
            Player player = (Player)entry.getKey();
            int score = (Integer)entry.getValue();
            if (worstScore > score && weakLimit.evaluate(player)) {
                worstScore = score;
                weakestAIPlayer = player;
            }
            if (bestScore >= score) continue;
            bestScore = score;
            strongestAIPlayer = player;
        }
        if (weakestAIPlayer == null || strongestAIPlayer == null || weakestAIPlayer == strongestAIPlayer) {
            return null;
        }
        lb.add("Spanish succession scores[");
        for (Map.Entry entry : scores.entrySet()) {
            lb.add(" ", ((Player)entry.getKey()).getName(), "=", entry.getValue());
        }
        lb.add(" ]=> ", weakestAIPlayer.getName(), " cedes to ", strongestAIPlayer.getName(), ":");
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        ServerPlayer strongest = (ServerPlayer)strongestAIPlayer;
        ServerPlayer weakest = (ServerPlayer)weakestAIPlayer;
        for (Player player : this.getLiveNativePlayers(null)) {
            for (IndianSettlement is : player.getIndianSettlements()) {
                if (!is.hasMissionary(weakest)) continue;
                lb.add(" ", is.getName(), "(mission)");
                is.getTile().cacheUnseen(strongest);
                tiles.add(is.getTile());
                is.setContacted(strongest);
                ServerUnit missionary = (ServerUnit)is.getMissionary();
                if (!weakest.csChangeOwner(missionary, strongest, UnitTypeChange.ChangeType.CAPTURE, null, cs)) continue;
                is.getTile().updateIndianSettlement(strongest);
                cs.add(ChangeSet.See.perhaps().always(strongest), is);
            }
        }
        for (Colony colony : weakest.getColonies()) {
            for (Tile t : colony.getOwnedTiles()) {
                t.cacheUnseen();
                tiles.add(t);
            }
            ((ServerColony)colony).csChangeOwner(strongest, cs);
            cs.add(ChangeSet.See.only(strongest), strongest.exploreForSettlement(colony));
            lb.add(" ", colony.getName());
        }
        for (Unit unit : weakest.getUnits()) {
            Tile tile;
            if (!weakest.csChangeOwner(unit, strongest, UnitTypeChange.ChangeType.CAPTURE, null, cs)) continue;
            unit.setMovesLeft(0);
            unit.setState(Unit.UnitState.ACTIVE);
            lb.add(" ", unit.getId());
            if (unit.getLocation() instanceof Europe) {
                unit.setLocation(strongestAIPlayer.getEurope());
                cs.add(ChangeSet.See.only(strongest), unit);
                continue;
            }
            if (unit.getLocation() instanceof HighSeas) {
                unit.setLocation(strongestAIPlayer.getHighSeas());
                cs.add(ChangeSet.See.only(strongest), unit);
                continue;
            }
            if (!(unit.getLocation() instanceof Tile) || tiles.contains(tile = unit.getTile())) continue;
            tiles.add(tile);
        }
        StringTemplate loser = weakestAIPlayer.getNationLabel();
        StringTemplate winner = strongestAIPlayer.getNationLabel();
        cs.addMessage(ChangeSet.See.all(), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.game.spanishSuccession", strongestAIPlayer).addStringTemplate("%loserNation%", loser).addStringTemplate("%nation%", winner));
        cs.addGlobalHistory(this, new HistoryEvent(this.getTurn(), HistoryEvent.HistoryEventType.SPANISH_SUCCESSION, null).addStringTemplate("%loserNation%", loser).addStringTemplate("%nation%", winner));
        this.setSpanishSuccession(true);
        cs.addPartial(ChangeSet.See.all(), this, "spanishSuccession");
        cs.add(ChangeSet.See.perhaps(), tiles);
        weakest.csKill(cs);
        strongest.invalidateCanSeeTiles();
        for (FreeColGameObject fcgo : this.getFreeColGameObjects()) {
            if (!(fcgo instanceof Ownable) || ((Ownable)((Object)fcgo)).getOwner() != weakest) continue;
            throw new RuntimeException("Lurking " + weakest.getId() + " fcgo: " + fcgo);
        }
        return weakest;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverGame";
    }
}

