/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class UnloadGoodsMessage
extends DOMMessage {
    private final String goodsTypeId;
    private final String amountString;
    private final String carrierId;

    public UnloadGoodsMessage(GoodsType goodsType, int amount, Unit carrier) {
        super(UnloadGoodsMessage.getXMLElementTagName());
        this.goodsTypeId = goodsType.getId();
        this.amountString = Integer.toString(amount);
        this.carrierId = carrier.getId();
    }

    public UnloadGoodsMessage(Game game, Element element) {
        super(UnloadGoodsMessage.getXMLElementTagName());
        this.goodsTypeId = element.getAttribute("type");
        this.amountString = element.getAttribute("amount");
        this.carrierId = element.getAttribute("carrier");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int amount;
        Unit carrier;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            carrier = player.getOurFreeColGameObject(this.carrierId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!carrier.canCarryGoods()) {
            return DOMMessage.clientError("Not a goods carrier: " + this.carrierId);
        }
        GoodsType type = server.getSpecification().getGoodsType(this.goodsTypeId);
        if (type == null) {
            return DOMMessage.clientError("Not a goods type: " + this.goodsTypeId);
        }
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad amount: " + this.amountString);
        }
        if (amount <= 0) {
            return DOMMessage.clientError("Amount must be positive: " + this.amountString);
        }
        int present = carrier.getGoodsCount(type);
        if (present < amount) {
            return DOMMessage.clientError("Attempt to unload " + amount + " " + type.getId() + " but only " + present + " present.");
        }
        return server.getInGameController().unloadGoods(serverPlayer, type, amount, carrier);
    }

    @Override
    public Element toXMLElement() {
        return UnloadGoodsMessage.createMessage(UnloadGoodsMessage.getXMLElementTagName(), "type", this.goodsTypeId, "amount", this.amountString, "carrier", this.carrierId);
    }

    public static String getXMLElementTagName() {
        return "unloadGoods";
    }
}

