/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;

public class WildcardQueryBuilder
extends MultiTermQueryBuilder
implements BoostableQueryBuilder<WildcardQueryBuilder> {
    private final String name;
    private final String wildcard;
    private float boost = -1.0f;
    private String rewrite;
    private String queryName;

    public WildcardQueryBuilder(String name, String wildcard) {
        this.name = name;
        this.wildcard = wildcard;
    }

    public WildcardQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    @Override
    public WildcardQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public WildcardQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("wildcard");
        if (this.boost == -1.0f && this.rewrite == null && this.queryName == null) {
            builder.field(this.name, this.wildcard);
        } else {
            builder.startObject(this.name);
            builder.field("wildcard", this.wildcard);
            if (this.boost != -1.0f) {
                builder.field("boost", this.boost);
            }
            if (this.rewrite != null) {
                builder.field("rewrite", this.rewrite);
            }
            if (this.queryName != null) {
                builder.field("_name", this.queryName);
            }
            builder.endObject();
        }
        builder.endObject();
    }
}

