/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.mysql.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.expressions.QueryExpression;
import org.eclipse.wst.rdb.internal.models.sql.expressions.SQLExpressionsPackage;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.impl.ViewTableImpl;


public class MySqlCatalogView extends ViewTableImpl implements ICatalogObject {
		public void refresh() {
			if (this.columnsLoaded) {
				this.columns.clear();
				this.columnsLoaded = false;
			}
			this.propertiesLoaded = false;
			RefreshManager.getInstance().referesh(this);
		}

		public boolean isSystemObject() {
			return false;
		}

		public Connection getConnection() {
			Database database = this.getCatalogDatabase();
			return ((MySqlCatalogDatabase) database).getConnection();
		}
		
		public Database getCatalogDatabase() {
			return this.getSchema().getDatabase();		
		}
		
		public EList getColumns() {
			if(!this.columnsLoaded) this.loadColumns();
			return this.columns;
		}
		
		public QueryExpression getQueryExpression() {
			if(!this.propertiesLoaded) this.loadProperties();
			return this.queryExpression;
		}
		
		public boolean eIsSet(EStructuralFeature eFeature) {
			int id = eDerivedStructuralFeatureID(eFeature);
			if(id == SQLTablesPackage.VIEW_TABLE__COLUMNS) {
				this.getColumns();
			}
			else if(id == SQLTablesPackage.VIEW_TABLE__QUERY_EXPRESSION) {
				this.getQueryExpression();
			}
			
			return super.eIsSet(eFeature);
		}

		private synchronized void loadColumns() {
			if(this.columnsLoaded) return;
			
			boolean deliver = this.eDeliver();
			this.eSetDeliver(false);
			try {
				MySqlCatalogTable.loadColumns(this.getConnection(), super.getColumns(), this);
			}
			catch(Exception e) {
			}
			this.columnsLoaded = true;
			this.eSetDeliver(deliver);
		}

		private synchronized void loadProperties() {
			if(this.propertiesLoaded) return;
			this.propertiesLoaded = true;
			
			boolean deliver = this.eDeliver();
			this.eSetDeliver(false);
			
			try {
				Connection connection = this.getConnection();
				
				String query = "SELECT VIEW_DEFINITION" +
						" FROM INFORMATION_SCHEMA.VIEWS" +
						" WHERE TABLE_NAME='" + this.getName() + "'";
				
				Statement s = connection.createStatement();
				ResultSet r = s.executeQuery(query);
				
				String text = "";
				while (r.next()) {
					String expression = r.getString(1);
					text += expression.trim()+" ";
				}
				
				DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
				QueryExpression queryExpression = (QueryExpression) factory.create(SQLExpressionsPackage.eINSTANCE.getQueryExpressionDefault());
				queryExpression.setSQL(text);
				this.setQueryExpression(queryExpression);
				
				r.close();
				s.close();
			}
			catch (Exception e) {
			}
			
			this.eSetDeliver(deliver);
		}
		
		private boolean columnsLoaded = false;
		private boolean propertiesLoaded = false;
	
	
}
