/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.editor;

import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HTMLEditorPluginImageHelper {
    private final String PLUGINID = "org.eclipse.wst.html.ui";
    private static HTMLEditorPluginImageHelper instance = null;
    private HashMap fImageDescRegistry = null;

    public static synchronized HTMLEditorPluginImageHelper getInstance() {
        if (instance == null) {
            instance = new HTMLEditorPluginImageHelper();
        }
        return instance;
    }

    public Image getImage(String resource) {
        Image image = this.getImageRegistry().get(resource);
        if (image == null) {
            image = this.createImage(resource);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String resource) {
        ImageDescriptor imageDescriptor = null;
        Object o = this.getImageDescriptorRegistry().get(resource);
        imageDescriptor = o == null ? this.createImageDescriptor(resource) : (ImageDescriptor)o;
        return imageDescriptor;
    }

    private HashMap getImageDescriptorRegistry() {
        if (this.fImageDescRegistry == null) {
            this.fImageDescRegistry = new HashMap();
        }
        return this.fImageDescRegistry;
    }

    private ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }

    private Image createImage(String resource) {
        ImageDescriptor desc = this.getImageDescriptor(resource);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                this.getImageRegistry().put(resource, image);
            }
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.html.ui", (String)imageFilePath);
        if (imageDescriptor != null) {
            this.getImageDescriptorRegistry().put(imageFilePath, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }
}

