/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class HistoryTableProvider {
    private ISVNRemoteResource currentRemoteResource;
    private SVNRevision.Number currentRevision;
    private TableViewer viewer;
    private Font currentRevisionFont;
    private static final int COL_REVISION = 0;
    private static final int COL_TAGS = 1;
    private static final int COL_DATE = 2;
    private static final int COL_AUTHOR = 3;
    private static final int COL_COMMENT = 4;
    static /* synthetic */ Class class$0;

    protected ILogEntry adaptToLogEntry(Object element) {
        ILogEntry entry = null;
        if (element instanceof ILogEntry) {
            entry = (ILogEntry)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.tigris.subversion.subclipse.core.history.ILogEntry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            entry = (ILogEntry)iAdaptable.getAdapter((Class)clazz);
        }
        return entry;
    }

    public TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        this.createColumns(table, layout, viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistorySorter sorter = new HistorySorter(0);
        sorter.setReversed(true);
        viewer.setSorter((ViewerSorter)sorter);
        table.setSortDirection(1024);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HistoryTableProvider.this.currentRevisionFont != null) {
                    HistoryTableProvider.this.currentRevisionFont.dispose();
                }
            }
        });
        this.viewer = viewer;
        return viewer;
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        SelectionListener headerListener = this.getColumnListener(viewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.revision"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        table.setSortColumn(col);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.tags"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.date"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.author"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.comment"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                HistorySorter oldSorter = (HistorySorter)tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    tableViewer.setSorter((ViewerSorter)new HistorySorter(column));
                }
                tableViewer.getTable().setSortColumn((TableColumn)e.widget);
                if (tableViewer.getTable().getSortDirection() == 128) {
                    tableViewer.getTable().setSortDirection(1024);
                } else {
                    tableViewer.getTable().setSortDirection(128);
                }
            }
        };
    }

    private SVNRevision.Number getRevision(ISVNRemoteResource currentEdition) {
        if (currentEdition == null) {
            return SVNRevision.INVALID_REVISION;
        }
        return currentEdition.getLastChangedRevision();
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.currentRemoteResource = remoteResource;
        this.currentRevision = this.getRevision(remoteResource);
    }

    public SVNRevision.Number getCurrentRevision() {
        return this.currentRevision;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.currentRemoteResource;
    }

    class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        HistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    String revision = entry.getRevision().toString();
                    if (HistoryTableProvider.this.currentRemoteResource != null && entry.getRevision().equals((Object)HistoryTableProvider.this.currentRemoteResource.getLastChangedRevision())) {
                        revision = Policy.bind("currentRevision", revision);
                    }
                    return revision;
                }
                case 1: {
                    return AliasManager.getAliasesAsString((Alias[])entry.getTags());
                }
                case 2: {
                    Date date = entry.getDate();
                    if (date == null) {
                        return Policy.bind("notAvailable");
                    }
                    return DateFormat.getInstance().format(date);
                }
                case 3: {
                    if (entry.getAuthor() == null) {
                        return Policy.bind("noauthor");
                    }
                    return entry.getAuthor();
                }
                case 4: {
                    String comment = entry.getComment();
                    if (comment == null) {
                        return "";
                    }
                    int rIndex = comment.indexOf("\r");
                    int nIndex = comment.indexOf("\n");
                    if (rIndex == -1 && nIndex == -1) {
                        return comment;
                    }
                    if (rIndex == 0 || nIndex == 0) {
                        return Policy.bind("HistoryView.[...]_4");
                    }
                    if (rIndex != -1) {
                        return Policy.bind("SVNCompareRevisionsInput.truncate", comment.substring(0, rIndex));
                    }
                    return Policy.bind("SVNCompareRevisionsInput.truncate", comment.substring(0, nIndex));
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry == null) {
                return null;
            }
            SVNRevision.Number revision = entry.getRevision();
            SVNRevision.Number currentRevision = HistoryTableProvider.this.getCurrentRevision();
            if (currentRevision != null && currentRevision.equals((Object)revision)) {
                if (HistoryTableProvider.this.currentRevisionFont == null) {
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] data = defaultFont.getFontData();
                    int i = 0;
                    while (i < data.length) {
                        data[i].setStyle(1);
                        ++i;
                    }
                    HistoryTableProvider.this.currentRevisionFont = new Font((Device)HistoryTableProvider.this.viewer.getTable().getDisplay(), data);
                }
                return HistoryTableProvider.this.currentRevisionFont;
            }
            return null;
        }
    }

    class HistorySorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        private int[][] SORT_ORDERS_BY_COLUMN;

        public HistorySorter(int columnNumber) {
            int[][] nArrayArray = new int[5][];
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[5];
            nArray3[0] = 2;
            nArray3[2] = 1;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[5];
            nArray4[0] = 3;
            nArray4[2] = 1;
            nArray4[3] = 2;
            nArray4[4] = 4;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[5];
            nArray5[0] = 4;
            nArray5[2] = 1;
            nArray5[3] = 2;
            nArray5[4] = 3;
            nArrayArray[4] = nArray5;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            ILogEntry e1 = HistoryTableProvider.this.adaptToLogEntry(o1);
            ILogEntry e2 = HistoryTableProvider.this.adaptToLogEntry(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(viewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, ILogEntry e1, ILogEntry e2) {
            switch (columnNumber) {
                case 0: {
                    return e1.getRevision().getNumber() < e2.getRevision().getNumber() ? -1 : (e1.getRevision() == e2.getRevision() ? 0 : 1);
                }
                case 1: {
                    String tags1 = AliasManager.getAliasesAsString((Alias[])e1.getTags());
                    String tags2 = AliasManager.getAliasesAsString((Alias[])e2.getTags());
                    return this.getCollator().compare(tags1, tags2);
                }
                case 2: {
                    Date date1 = e1.getDate();
                    Date date2 = e2.getDate();
                    return date1.compareTo(date2);
                }
                case 3: {
                    return this.getCollator().compare(e1.getAuthor(), e2.getAuthor());
                }
                case 4: {
                    return this.getCollator().compare(e1.getComment(), e2.getComment());
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }
}

