/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.debug.ui.launcher.RubyApplicationShortcut;
import org.rubypeople.rdt.internal.launching.RubyRuntime;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.testunit.TestunitPlugin;
import org.rubypeople.rdt.testunit.launcher.TestSearchEngine;
import org.rubypeople.rdt.testunit.launcher.TestUnitRunnerConfiguration;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;

public class TestUnitLaunchShortcut
extends RubyApplicationShortcut {
    static final String TEST_RUNNER_FILE = "RemoteTestRunner.rb";

    protected void doLaunch(IRubyElement iRubyElement, String string) throws CoreException {
        String string2 = this.getContainer(iRubyElement);
        ILaunchConfiguration iLaunchConfiguration = this.findOrCreateLaunchConfiguration(iRubyElement, string, string2, "", "");
        if (iLaunchConfiguration != null) {
            iLaunchConfiguration.launch(string, null);
        }
        TestSearchEngine.findTests((IFile)iRubyElement.getUnderlyingResource());
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(IRubyElement iRubyElement, String string, String string2, String string3, String string4) throws CoreException {
        IFile iFile = (IFile)iRubyElement.getUnderlyingResource();
        ILaunchConfigurationType iLaunchConfigurationType = this.getRubyLaunchConfigType();
        ArrayList<ILaunchConfiguration> arrayList = null;
        ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
        arrayList = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
        int n = 0;
        while (n < iLaunchConfigurationArray.length) {
            ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n];
            if (iLaunchConfiguration.getAttribute("org.rubypeople.rdt.testunit.CONTAINER", "").equals(string2) && iLaunchConfiguration.getAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "").equals("") && iLaunchConfiguration.getAttribute("org.rubypeople.rdt.testunit.TESTNAME", "").equals(string4) && iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", "").equals(iFile.getProject().getName())) {
                arrayList.add(iLaunchConfiguration);
            }
            ++n;
        }
        switch (arrayList.size()) {
            case 0: {
                return this.createConfiguration(iFile, string2, string4);
            }
            case 1: {
                return (ILaunchConfiguration)arrayList.get(0);
            }
        }
        ILaunchConfiguration iLaunchConfiguration = this.chooseConfiguration(arrayList, string);
        if (iLaunchConfiguration != null) {
            return iLaunchConfiguration;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(TestUnitMessages.getString("LaunchTestAction.message.selectConfiguration"));
        if (string.equals("debug")) {
            elementListSelectionDialog.setMessage(TestUnitMessages.getString("LaunchTestAction.message.selectDebugConfiguration"));
        } else {
            elementListSelectionDialog.setMessage(TestUnitMessages.getString("LaunchTestAction.message.selectRunConfiguration"));
        }
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected Shell getShell() {
        return TestunitPlugin.getActiveWorkbenchShell();
    }

    private String getContainer(IRubyElement iRubyElement) {
        try {
            IFile iFile = (IFile)iRubyElement.getUnderlyingResource();
            return iFile.getProjectRelativePath().toString();
        }
        catch (RubyModelException rubyModelException) {
            RubyPlugin.log((Throwable)rubyModelException);
            return iRubyElement.getElementName();
        }
    }

    protected ILaunchConfiguration createConfiguration(IFile iFile, String string, String string2) {
        if (RubyRuntime.getDefault().getSelectedInterpreter() == null) {
            this.showNoInterpreterDialog();
            return null;
        }
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getRubyLaunchConfigType();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iFile.getName()));
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", iFile.getProject().getName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.FILE_NAME", TestUnitRunnerConfiguration.getTestRunnerPath());
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", TestUnitLaunchShortcut.getDefaultWorkingDirectory(iFile.getProject()));
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", RubyRuntime.getDefault().getSelectedInterpreter().getName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.CONTAINER", string);
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", string2);
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "");
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.rubypeople.rdt.testunit.launchconfig");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void log(String string) {
        TestunitPlugin.log((IStatus)new Status(1, "org.rubypeople.rdt.testunit", 1, string, null));
    }

    protected void log(Throwable throwable) {
        TestunitPlugin.log(throwable);
    }

    protected void showNoInterpreterDialog() {
        MessageDialog.openInformation((Shell)TestunitPlugin.getActiveWorkbenchShell(), (String)TestUnitMessages.getString("Dialog.launchWithoutSelectedInterpreter.title"), (String)TestUnitMessages.getString("Dialog.launchWithoutSelectedInterpreter"));
    }

    protected static String getDefaultWorkingDirectory(IProject iProject) {
        if (iProject != null && iProject.exists()) {
            return iProject.getLocation().toOSString();
        }
        return TestunitPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }
}

