/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.RubyAnnotationHover;
import org.rubypeople.rdt.internal.ui.text.RubyCommentScanner;
import org.rubypeople.rdt.internal.ui.text.RubyContentAssistPreference;
import org.rubypeople.rdt.internal.ui.text.RubyDoubleClickSelector;
import org.rubypeople.rdt.internal.ui.text.RubyReconciler;
import org.rubypeople.rdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.rubypeople.rdt.internal.ui.text.comment.RubyCommentAutoIndentStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCodeScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProcessor;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyFormattingStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyReconcilingStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.SingleTokenRubyCodeScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyCodeTextHover;
import org.rubypeople.rdt.ui.text.IColorManager;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class RubySourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected RubyTextTools textTools;
    protected ITextEditor fTextEditor;
    private RubyCodeTextHover fRubyTextHover;
    private String fDocumentPartitioning;
    private IColorManager fColorManager;
    protected AbstractRubyScanner fCodeScanner;
    protected AbstractRubyScanner fMultilineCommentScanner;
    protected AbstractRubyScanner fSinglelineCommentScanner;
    protected AbstractRubyScanner fStringScanner;
    private SingleTokenRubyCodeScanner fRegexpScanner;
    private SingleTokenRubyCodeScanner fCommandScanner;
    private RubyDoubleClickSelector fRubyDoubleClickSelector;

    public RubySourceViewerConfiguration(IColorManager iColorManager, IPreferenceStore iPreferenceStore, ITextEditor iTextEditor, String string) {
        super(iPreferenceStore);
        this.fColorManager = iColorManager;
        this.fTextEditor = iTextEditor;
        this.fDocumentPartitioning = string;
        this.initializeScanners();
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        MultiPassContentFormatter multiPassContentFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(iSourceViewer), "__dftl_partition_content_type");
        multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new RubyFormattingStrategy());
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__ruby_rdoc");
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__ruby_singleline_comment");
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__ruby_multiline_comment");
        return multiPassContentFormatter;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsBehavior(propertyChangeEvent) || this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fStringScanner.affectsBehavior(propertyChangeEvent) || this.fRegexpScanner.affectsBehavior(propertyChangeEvent) || this.fCommandScanner.affectsBehavior(propertyChangeEvent);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fStringScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fRegexpScanner.affectsBehavior(propertyChangeEvent)) {
            this.fRegexpScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fCommandScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCommandScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    private static final IPreferenceStore createPreferenceStore(RubyTextTools rubyTextTools) {
        Assert.isNotNull((Object)rubyTextTools);
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        if (rubyTextTools.getCorePreferenceStore() == null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{rubyTextTools.getPreferenceStore(), iPreferenceStore});
        }
        return new ChainedPreferenceStore(new IPreferenceStore[]{rubyTextTools.getPreferenceStore(), new PreferencesAdapter(rubyTextTools.getCorePreferenceStore()), iPreferenceStore});
    }

    private void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new RubyCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new RubyCommentScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_multiline_comment");
        this.fSinglelineCommentScanner = new RubyCommentScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_singleline_comment");
        this.fStringScanner = new SingleTokenRubyCodeScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_string");
        this.fRegexpScanner = new SingleTokenRubyCodeScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_regexp");
        this.fCommandScanner = new SingleTokenRubyCodeScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_command");
    }

    private boolean isNewSetup() {
        return this.textTools == null;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning("___ruby_partitioning");
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer(this.getCodeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        defaultDamagerRepairer = new DefaultDamagerRepairer(this.getSinglelineCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__ruby_singleline_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__ruby_singleline_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer(this.getMultilineCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__ruby_multiline_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__ruby_multiline_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer(this.getStringScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__ruby_string");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__ruby_string");
        defaultDamagerRepairer = new DefaultDamagerRepairer(this.getRegexpScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "partition_scanner_ruby_regular_expression");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "partition_scanner_ruby_regular_expression");
        defaultDamagerRepairer = new DefaultDamagerRepairer(this.getCommandScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "partition_scanner_ruby_command");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "partition_scanner_ruby_command");
        return presentationReconciler;
    }

    private ITokenScanner getCommandScanner() {
        return this.fCommandScanner;
    }

    protected ITokenScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected ITokenScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected ITokenScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected ITokenScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected ITokenScanner getRegexpScanner() {
        return this.fRegexpScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__ruby_multiline_comment", "__ruby_string", "__ruby_singleline_comment"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(iSourceViewer);
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new RubyCompletionProcessor((IEditorPart)this.getEditor()), "__dftl_partition_content_type");
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        RubyContentAssistPreference.configure(contentAssistant, this.getPreferenceStore());
        return contentAssistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new RubyAnnotationHover(RubyAnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        String string2 = this.getConfiguredDocumentPartitioning(iSourceViewer);
        if ("__ruby_singleline_comment".equals(string)) {
            return new IAutoEditStrategy[]{new RubyCommentAutoIndentStrategy(string2)};
        }
        return super.getAutoEditStrategies(iSourceViewer, string);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        return RubyPlugin.getDefault().getPreferenceStore();
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"#", ""};
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        RubyReconciler rubyReconciler = new RubyReconciler(this.fTextEditor, new RubyReconcilingStrategy((ITextEditor)((RubyAbstractEditor)this.fTextEditor)), true);
        rubyReconciler.setIsIncrementalReconciler(false);
        rubyReconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        rubyReconciler.setDelay(500);
        return rubyReconciler;
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        RubySourceViewer rubySourceViewer;
        if (!(this.fTextEditor instanceof RubyEditor)) {
            return super.getIndentPrefixes(iSourceViewer, string);
        }
        if (iSourceViewer instanceof RubySourceViewer && (rubySourceViewer = (RubySourceViewer)iSourceViewer).isTabReplacing()) {
            return new String[]{rubySourceViewer.getIndentString(), "\t", " "};
        }
        return super.getIndentPrefixes(iSourceViewer, string);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.fRubyDoubleClickSelector == null) {
            this.fRubyDoubleClickSelector = new RubyDoubleClickSelector();
        }
        return this.fRubyDoubleClickSelector;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        if (this.fRubyTextHover == null) {
            this.fRubyTextHover = new RubyCodeTextHover();
        }
        return this.fRubyTextHover;
    }
}

