/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import java.util.Hashtable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.internal.debug.core.RubyExceptionBreakpoint;
import org.rubypeople.rdt.internal.debug.core.RubyLineBreakpoint;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;
import org.rubypeople.rdt.internal.debug.core.model.RubyValue;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;

public class DebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private static Hashtable imageCache = new Hashtable();
    private Boolean isShowTypes;

    public String getText(Object object) {
        RubyExceptionBreakpoint rubyExceptionBreakpoint;
        if (object instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint rubyLineBreakpoint = (RubyLineBreakpoint)object;
            try {
                return String.valueOf(rubyLineBreakpoint.getMarker().getResource().getName()) + ":" + rubyLineBreakpoint.getLineNumber();
            }
            catch (CoreException coreException) {
                DebugUIPlugin.log((Throwable)coreException);
                return "--";
            }
        }
        if (object instanceof RubyExceptionBreakpoint) {
            rubyExceptionBreakpoint = (RubyExceptionBreakpoint)object;
            try {
                if (rubyExceptionBreakpoint.getException() == null || rubyExceptionBreakpoint.getException().length() == 0) {
                    return "No Catchpoint defined";
                }
                return "Suspend on exception: " + rubyExceptionBreakpoint.getException();
            }
            catch (CoreException coreException) {
                DebugUIPlugin.log((Throwable)coreException);
            }
        }
        if (object instanceof RubyVariable) {
            rubyExceptionBreakpoint = (RubyVariable)object;
            if (this.isShowTypes == Boolean.TRUE) {
                return String.valueOf(((RubyValue)rubyExceptionBreakpoint.getValue()).getReferenceTypeName()) + " " + rubyExceptionBreakpoint.toString();
            }
            return rubyExceptionBreakpoint.toString();
        }
        return DebugUIPlugin.getDefaultLabelProvider().getText(object);
    }

    protected IBreakpoint getBreakpoint(IMarker iMarker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(iMarker);
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
    }

    public void setAttribute(String string, Object object) {
        if (string.equals(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES)) {
            this.isShowTypes = (Boolean)object;
        }
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        System.out.println("getEditorId.");
        return "X";
    }

    public IEditorInput getEditorInput(Object object) {
        return null;
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        Image image = (Image)imageCache.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    public Image getImage(Object object) {
        RubyThread rubyThread;
        ImageDescriptor imageDescriptor = object instanceof IMarker || object instanceof RubyLineBreakpoint ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT") : (object instanceof RubyThread ? ((rubyThread = (RubyThread)object).isSuspended() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED") : (rubyThread.isTerminated() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_TERMINATED") : DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"))) : DebugUITools.getDefaultImageDescriptor((Object)object));
        return this.getImage(imageDescriptor);
    }
}

