/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerConstants;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;

public abstract class WSHandler {
    public static String DONE = "done";
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$handler$WSHandler == null ? (class$org$apache$ws$security$handler$WSHandler = WSHandler.class$("org.apache.ws.security.handler.WSHandler")) : class$org$apache$ws$security$handler$WSHandler).getName());
    protected static final WSSecurityEngine secEngine = WSSecurityEngine.getInstance();
    protected static Hashtable cryptos = new Hashtable(5);
    private boolean doDebug = log.isDebugEnabled();
    static /* synthetic */ Class class$org$apache$ws$security$handler$WSHandler;

    protected void doSenderAction(int doAction, Document doc, RequestData reqData, Vector actions, boolean isRequest) throws WSSecurityException {
        String done;
        boolean mu = this.decodeMustUnderstand(reqData);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setEnableSignatureConfirmation(this.decodeEnableSignatureConfirmation(reqData));
        wssConfig.setPrecisionInMilliSeconds(this.decodeTimestampPrecision(reqData));
        reqData.setWssConfig(wssConfig);
        Object mc = reqData.getMsgContext();
        String actor = this.getString("actor", mc);
        reqData.setActor(actor);
        WSSecHeader secHeader = new WSSecHeader(actor, mu);
        secHeader.insertSecurityHeader(doc);
        reqData.setSecHeader(secHeader);
        reqData.setSoapConstants(WSSecurityUtil.getSOAPConstants(doc.getDocumentElement()));
        if ((doAction & 1) == 1) {
            this.decodeUTParameter(reqData);
        }
        if ((doAction & 0x40) == 64) {
            this.decodeUTParameter(reqData);
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 2) == 2) {
            reqData.setSigCrypto(this.loadSignatureCrypto(reqData));
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 0x10) == 16) {
            this.decodeSignatureParameter(reqData);
        }
        if ((doAction & 4) == 4) {
            reqData.setEncCrypto(this.loadEncryptionCrypto(reqData));
            this.decodeEncryptionParameter(reqData);
        }
        if (reqData.getSignatureParts().isEmpty()) {
            WSEncryptionPart encP = new WSEncryptionPart(reqData.getSoapConstants().getBodyQName().getLocalPart(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
            reqData.getSignatureParts().add(encP);
        }
        if (!(!wssConfig.isEnableSignatureConfirmation() || isRequest || (done = (String)this.getProperty(reqData.getMsgContext(), "_sigConfDone_")) != null && DONE.equals(done))) {
            Vector results = null;
            results = (Vector)this.getProperty(reqData.getMsgContext(), "RECV_RESULTS");
            if (results != null) {
                wssConfig.getAction(128).execute(this, 128, doc, reqData);
            }
        }
        block4: for (int i = 0; i < actions.size(); ++i) {
            int actionToDo = (Integer)actions.get(i);
            if (this.doDebug) {
                log.debug((Object)("Performing Action: " + actionToDo));
            }
            switch (actionToDo) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    wssConfig.getAction(actionToDo).execute(this, actionToDo, doc, reqData);
                    continue block4;
                }
                case 256: {
                    reqData.setNoSerialization(true);
                }
            }
        }
        if (wssConfig.isEnableSignatureConfirmation() && isRequest && reqData.getSignatureValues().size() > 0) {
            Vector sigv = null;
            sigv = (Vector)this.getProperty(reqData.getMsgContext(), "_sendSignatureValues_");
            if (sigv == null) {
                sigv = new Vector();
                this.setProperty(reqData.getMsgContext(), "_sendSignatureValues_", sigv);
            }
            sigv.addAll(reqData.getSignatureValues());
        }
    }

    protected void doReceiverAction(int doAction, RequestData reqData) throws WSSecurityException {
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setEnableSignatureConfirmation(this.decodeEnableSignatureConfirmation(reqData));
        wssConfig.setTimeStampStrict(this.decodeTimestampStrict(reqData));
        reqData.setWssConfig(wssConfig);
        if ((doAction & 2) == 2) {
            this.decodeSignatureParameter2(reqData);
        }
        if ((doAction & 4) == 4) {
            this.decodeDecryptionParameter(reqData);
        }
        if ((doAction & 0x100) == 256) {
            reqData.setNoSerialization(true);
        }
    }

    protected boolean checkReceiverResults(Vector wsResult, Vector actions) {
        int resultActions = wsResult.size();
        int size = actions.size();
        int ai = 0;
        for (int i = 0; i < resultActions; ++i) {
            Integer actInt = (Integer)((WSSecurityEngineResult)wsResult.get(i)).get("action");
            int act = actInt;
            if (act == 128 || act == 4096 || ai < size && (Integer)actions.get(ai++) == act) continue;
            return false;
        }
        return true;
    }

    protected void checkSignatureConfirmation(RequestData reqData, Vector wsResult) throws WSSecurityException {
        if (this.doDebug) {
            log.debug((Object)"Check Signature confirmation");
        }
        Vector sigv = (Vector)this.getProperty(reqData.getMsgContext(), "_sendSignatureValues_");
        Vector sigConf = new Vector();
        WSSecurityUtil.fetchAllActionResults(wsResult, 128, sigConf);
        for (int i = 0; i < sigConf.size(); ++i) {
            byte[] sigVal = ((WSSecurityEngineResult)sigConf.get(i)).getSigConf().getSignatureValue();
            if (sigVal == null) continue;
            if (sigv == null || sigv.size() == 0) {
                if (sigVal.length == 0) continue;
                throw new WSSecurityException("WSHandler: Check Signature confirmation: got a SC element, but no stored SV");
            }
            boolean found = false;
            for (int ii = 0; ii < sigv.size(); ++ii) {
                byte[] storedValue = (byte[])sigv.get(i);
                if (!Arrays.equals(sigVal, storedValue)) continue;
                found = true;
                sigv.remove(ii);
                break;
            }
            if (found) continue;
            throw new WSSecurityException("WSHandler: Check Signature confirmation: got SC element, but no matching SV");
        }
        if (!reqData.isNoSerialization()) {
            log.debug((Object)"Check Signature confirmation - last handler");
            if (sigv != null && !sigv.isEmpty()) {
                throw new WSSecurityException("WSHandler: Check Signature confirmation: stored SV vector not empty");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Crypto loadSignatureCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String sigPropFile = this.getString("signaturePropFile", reqData.getMsgContext());
        if (sigPropFile != null) {
            crypto = (Crypto)cryptos.get(sigPropFile);
            if (crypto != null) return crypto;
            crypto = CryptoFactory.getInstance(sigPropFile, this.getClassLoader(reqData.getMsgContext()));
            cryptos.put(sigPropFile, crypto);
            return crypto;
        } else {
            if (this.getString("SignaturePropRefId", reqData.getMsgContext()) == null) throw new WSSecurityException("WSHandler: Signature: no crypto properties");
            String refId = this.getString("SignaturePropRefId", reqData.getMsgContext());
            if (refId == null) return crypto;
            Object propObj = this.getProperty(reqData.getMsgContext(), refId);
            if (!(propObj instanceof Properties)) throw new WSSecurityException("WSHandler: Signature: signaturePropRefId must hold a java.util.Properties object");
            crypto = (Crypto)cryptos.get(refId);
            if (crypto != null) return crypto;
            crypto = CryptoFactory.getInstance((Properties)propObj);
            cryptos.put(refId, crypto);
        }
        return crypto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Crypto loadEncryptionCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String encPropFile = this.getString("encryptionPropFile", reqData.getMsgContext());
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto != null) return crypto;
            crypto = CryptoFactory.getInstance(encPropFile, this.getClassLoader(reqData.getMsgContext()));
            cryptos.put(encPropFile, crypto);
            return crypto;
        } else if (this.getString("encryptionPropRefId", reqData.getMsgContext()) != null) {
            String refId = this.getString("encryptionPropRefId", reqData.getMsgContext());
            if (refId == null) return crypto;
            Object propObj = this.getProperty(reqData.getMsgContext(), refId);
            if (!(propObj instanceof Properties)) throw new WSSecurityException("WSHandler: Encryption: encryptionPropRefId must hold a java.util.Properties object");
            crypto = (Crypto)cryptos.get(refId);
            if (crypto != null) return crypto;
            crypto = CryptoFactory.getInstance((Properties)propObj);
            cryptos.put(refId, crypto);
            return crypto;
        } else {
            crypto = reqData.getSigCrypto();
            if (crypto != null) return crypto;
            throw new WSSecurityException("WSHandler: Encryption: no crypto property file");
        }
    }

    protected void decodeUTParameter(RequestData reqData) throws WSSecurityException {
        String add;
        Object mc = reqData.getMsgContext();
        String type = this.getString("passwordType", mc);
        reqData.setPwType(type);
        if (type != null) {
            reqData.setPwType(type.equals("PasswordText") ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        }
        if ((add = this.getString("addUTElements", mc)) != null) {
            reqData.setUtElements(StringUtil.split(add, ' '));
        }
    }

    protected void decodeSignatureParameter(RequestData reqData) throws WSSecurityException {
        Object mc = reqData.getMsgContext();
        String keyId = this.getString("signatureKeyIdentifier", mc);
        if (keyId != null) {
            Integer id = (Integer)WSHandlerConstants.keyIdentifier.get(keyId);
            if (id == null) {
                throw new WSSecurityException("WSHandler: Signature: unknown key identification");
            }
            int tmp = id;
            if (tmp != 2 && tmp != 1 && tmp != 3 && tmp != 4 && tmp != 8) {
                throw new WSSecurityException("WSHandler: Signature: illegal key identification");
            }
            reqData.setSigKeyId(tmp);
        }
        String algo = this.getString("signatureAlgorithm", mc);
        reqData.setSigAlgorithm(algo);
        String parts = this.getString("signatureParts", mc);
        if (parts != null) {
            this.splitEncParts(parts, reqData.getSignatureParts(), reqData);
        }
    }

    protected void decodeEncryptionParameter(RequestData reqData) throws WSSecurityException {
        Object mc = reqData.getMsgContext();
        String encUser = this.getString("encryptionUser", mc);
        if (encUser != null) {
            reqData.setEncUser(encUser);
        } else {
            reqData.setEncUser(reqData.getUsername());
        }
        if (reqData.getEncUser() == null) {
            throw new WSSecurityException("WSHandler: Encryption: no username");
        }
        this.handleSpecialUser(reqData);
        String encKeyId = this.getString("encryptionKeyIdentifier", mc);
        if (encKeyId != null) {
            Integer id = (Integer)WSHandlerConstants.keyIdentifier.get(encKeyId);
            if (id == null) {
                throw new WSSecurityException("WSHandler: Encryption: unknown key identification");
            }
            int tmp = id;
            reqData.setEncKeyId(tmp);
            if (tmp != 2 && tmp != 3 && tmp != 4 && tmp != 1 && tmp != 5 && tmp != 8) {
                throw new WSSecurityException("WSHandler: Encryption: illegal key identification");
            }
        }
        String encSymAlgo = this.getString("encryptionSymAlgorithm", mc);
        reqData.setEncSymmAlgo(encSymAlgo);
        String encKeyTransport = this.getString("encryptionKeyTransportAlgorithm", mc);
        reqData.setEncKeyTransport(encKeyTransport);
        String encParts = this.getString("encryptionParts", mc);
        if (encParts != null) {
            this.splitEncParts(encParts, reqData.getEncryptParts(), reqData);
        }
    }

    protected boolean decodeMustUnderstand(RequestData reqData) throws WSSecurityException {
        String mu = this.getString("mustUnderstand", reqData.getMsgContext());
        if (mu == null) {
            return true;
        }
        if ("0".equals(mu) || "false".equals(mu)) {
            return false;
        }
        if ("1".equals(mu) || "true".equals(mu)) {
            return true;
        }
        throw new WSSecurityException("WSHandler: illegal mustUnderstand parameter");
    }

    public int decodeTimeToLive(RequestData reqData) {
        String ttl = this.getString("timeToLive", reqData.getMsgContext());
        int ttl_i = 0;
        if (ttl != null) {
            try {
                ttl_i = Integer.parseInt(ttl);
            }
            catch (NumberFormatException e) {
                ttl_i = reqData.getTimeToLive();
            }
        }
        if (ttl_i <= 0) {
            ttl_i = reqData.getTimeToLive();
        }
        return ttl_i;
    }

    protected boolean decodeEnableSignatureConfirmation(RequestData reqData) throws WSSecurityException {
        String value = this.getString("enableSignatureConfirmation", reqData.getMsgContext());
        if (value == null) {
            return true;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new WSSecurityException("WSHandler: illegal enableSignatureConfirmation parameter");
    }

    protected boolean decodeTimestampPrecision(RequestData reqData) throws WSSecurityException {
        boolean precisionInMilliSeconds = true;
        String value = this.getString("precisionInMilliseconds", reqData.getMsgContext());
        if (value == null) {
            return true;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new WSSecurityException("WSHandler: illegal precisionInMilliSeconds parameter");
    }

    protected boolean decodeTimestampStrict(RequestData reqData) throws WSSecurityException {
        boolean precisionInMilliSeconds = true;
        String value = this.getString("timestampStrict", reqData.getMsgContext());
        if (value == null) {
            return true;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new WSSecurityException("WSHandler: illegal timestampStrict parameter");
    }

    public WSPasswordCallback getPassword(String username, int doAction, String clsProp, String refProp, RequestData reqData) throws WSSecurityException {
        WSPasswordCallback pwCb = null;
        String password = null;
        CallbackHandler cbHandler = null;
        String err = "provided null or empty password";
        Object mc = reqData.getMsgContext();
        String callback = this.getString(clsProp, mc);
        if (callback != null) {
            pwCb = this.readPwViaCallbackClass(callback, username, doAction, reqData);
            if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                throw new WSSecurityException("WSHandler: password callback class " + err);
            }
        } else {
            cbHandler = (CallbackHandler)this.getProperty(mc, refProp);
            if (cbHandler != null) {
                pwCb = this.performCallback(cbHandler, username, doAction);
                if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                    throw new WSSecurityException("WSHandler: password callback " + err);
                }
            } else {
                password = this.getPassword(mc);
                if (password == null) {
                    throw new WSSecurityException("WSHandler: application " + err);
                }
                this.setPassword(mc, null);
                pwCb = new WSPasswordCallback("", 0);
                pwCb.setPassword(password);
            }
        }
        return pwCb;
    }

    private WSPasswordCallback readPwViaCallbackClass(String callback, String username, int doAction, RequestData requestData) throws WSSecurityException {
        Class cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            cbClass = Loader.loadClass(this.getClassLoader(requestData.getMsgContext()), callback);
        }
        catch (ClassNotFoundException e) {
            throw new WSSecurityException("WSHandler: cannot load password callback class: " + callback, e);
        }
        try {
            cbHandler = (CallbackHandler)cbClass.newInstance();
        }
        catch (Exception e) {
            throw new WSSecurityException("WSHandler: cannot create instance of password callback: " + callback, e);
        }
        return this.performCallback(cbHandler, username, doAction);
    }

    private WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws WSSecurityException {
        WSPasswordCallback pwCb = null;
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new WSSecurityException("WSHandler: password callback failed", e);
        }
        return pwCb;
    }

    private void splitEncParts(String tmpS, Vector parts, RequestData reqData) throws WSSecurityException {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (this.doDebug) {
                    log.debug((Object)("single partDef: '" + partDef[0] + "'"));
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                if (nmSpace.length() <= 1) {
                    nmSpace = reqData.getSoapConstants().getEnvelopeURI();
                } else if ((nmSpace = nmSpace.substring(1)).equals("Null")) {
                    nmSpace = null;
                }
                String element = partDef[2].trim();
                if (this.doDebug) {
                    log.debug((Object)("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'"));
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new WSSecurityException("WSHandler: wrong part definition: " + tmpS);
            }
            parts.add(encPart);
        }
    }

    private void handleSpecialUser(RequestData reqData) {
        if (!"useReqSigCert".equals(reqData.getEncUser())) {
            return;
        }
        Vector results = null;
        results = (Vector)this.getProperty(reqData.getMsgContext(), "RECV_RESULTS");
        if (results == null) {
            return;
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            String hActor = rResult.getActor();
            if (!WSSecurityUtil.isActorEqual(reqData.getActor(), hActor)) continue;
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 2) continue;
                reqData.setEncCert(wser.getCertificate());
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Crypto loadDecryptionCrypto(RequestData reqData) throws WSSecurityException {
        Crypto crypto = null;
        String decPropFile = this.getString("decryptionPropFile", reqData.getMsgContext());
        if (decPropFile != null) {
            crypto = (Crypto)cryptos.get(decPropFile);
            if (crypto != null) return crypto;
            crypto = CryptoFactory.getInstance(decPropFile, this.getClassLoader(reqData.getMsgContext()));
            cryptos.put(decPropFile, crypto);
            return crypto;
        } else if (this.getString("decryptionPropRefId", reqData.getMsgContext()) != null) {
            String refId = this.getString("decryptionPropRefId", reqData.getMsgContext());
            if (refId == null) return crypto;
            Object propObj = this.getProperty(reqData.getMsgContext(), refId);
            if (!(propObj instanceof Properties)) throw new WSSecurityException("WSHandler: Decrytion: decryptionPropRefId must hold a java.util.Properties object");
            crypto = (Crypto)cryptos.get(refId);
            if (crypto != null) return crypto;
            crypto = CryptoFactory.getInstance((Properties)propObj);
            cryptos.put(refId, crypto);
            return crypto;
        } else {
            crypto = reqData.getSigCrypto();
            if (crypto != null) return crypto;
            throw new WSSecurityException("WSHandler: Encryption: no crypto property file");
        }
    }

    protected void decodeSignatureParameter2(RequestData reqData) throws WSSecurityException {
        reqData.setSigCrypto(this.loadSignatureCrypto(reqData));
    }

    protected void decodeDecryptionParameter(RequestData reqData) throws WSSecurityException {
        reqData.setDecCrypto(this.loadDecryptionCrypto(reqData));
    }

    protected CallbackHandler getPasswordCB(RequestData reqData) throws WSSecurityException {
        Object mc = reqData.getMsgContext();
        CallbackHandler cbHandler = null;
        String callback = this.getString("passwordCallbackClass", mc);
        if (callback != null) {
            Class cbClass = null;
            try {
                cbClass = Loader.loadClass(this.getClassLoader(reqData.getMsgContext()), callback);
            }
            catch (ClassNotFoundException e) {
                throw new WSSecurityException("WSHandler: cannot load password callback class: " + callback, e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException("WSHandler: cannot create instance of password callback: " + callback, e);
            }
        }
        cbHandler = (CallbackHandler)this.getProperty(mc, "passwordCallbackRef");
        if (cbHandler == null) {
            throw new WSSecurityException("WSHandler: no reference in callback property");
        }
        return cbHandler;
    }

    protected boolean verifyTrust(X509Certificate cert, RequestData reqData) throws WSSecurityException {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (this.doDebug) {
            log.debug((Object)("WSHandler: Transmitted certificate has subject " + subjectString));
            log.debug((Object)("WSHandler: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            alias = reqData.getSigCrypto().getAliasForX509Cert(issuerString, issuerSerial);
        }
        catch (WSSecurityException ex) {
            throw new WSSecurityException("WSHandler: Could not get alias for certificate with " + subjectString, ex);
        }
        if (alias != null) {
            try {
                certs = reqData.getSigCrypto().getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException("WSHandler: Could not get certificates for alias " + alias, ex);
            }
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (this.doDebug) {
                    log.debug((Object)("Direct trust for certificate with " + subjectString));
                }
                return true;
            }
        } else if (this.doDebug) {
            log.debug((Object)("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            aliases = reqData.getSigCrypto().getAliasesForDN(issuerString);
        }
        catch (WSSecurityException ex) {
            throw new WSSecurityException("WSHandler: Could not get alias for certificate with " + issuerString, ex);
        }
        if (aliases == null || aliases.length < 1) {
            if (this.doDebug) {
                log.debug((Object)("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (this.doDebug) {
                log.debug((Object)("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString));
            }
            try {
                certs = reqData.getSigCrypto().getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException("WSHandler: Could not get certificates for alias " + alias, ex);
            }
            if (certs == null | certs.length < 1) {
                throw new WSSecurityException("WSHandler: Could not get certificates for alias " + alias);
            }
            try {
                if (!reqData.getSigCrypto().validateCertPath(certs)) continue;
                if (this.doDebug) {
                    log.debug((Object)("WSHandler: Certificate path has been verified for certificate with subject " + subjectString));
                }
                return true;
            }
            catch (WSSecurityException ex) {
                throw new WSSecurityException("WSHandler: Certificate path verification failed for certificate with subject " + subjectString, ex);
            }
        }
        log.debug((Object)("WSHandler: Certificate path could not be verified for certificate with subject " + subjectString));
        return false;
    }

    protected boolean verifyTimestamp(Timestamp timestamp, int timeToLive) throws WSSecurityException {
        Calendar cre;
        Calendar validCreation = Calendar.getInstance();
        long currentTime = validCreation.getTime().getTime();
        validCreation.setTime(new Date(currentTime -= (long)(timeToLive * 1000)));
        if (this.doDebug) {
            log.debug((Object)"Preparing to verify the timestamp");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            log.debug((Object)("Validation of Timestamp: Current time is " + zulu.format(Calendar.getInstance().getTime())));
            log.debug((Object)("Validation of Timestamp: Valid creation is " + zulu.format(validCreation.getTime())));
            if (timestamp.getCreated() != null) {
                log.debug((Object)("Validation of Timestamp: Timestamp created is " + zulu.format(timestamp.getCreated().getTime())));
            }
        }
        if ((cre = timestamp.getCreated()) != null && !cre.after(validCreation)) {
            if (this.doDebug) {
                log.debug((Object)"Validation of Timestamp: The message was created too long ago");
            }
            return false;
        }
        if (this.doDebug) {
            log.debug((Object)"Validation of Timestamp: Everything is ok");
        }
        return true;
    }

    public String getString(String key, Object mc) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        String s = this.getStringOption(key);
        if (s != null) {
            return s;
        }
        if (mc == null) {
            throw new IllegalArgumentException("Message context cannot be null");
        }
        return (String)this.getProperty(mc, key);
    }

    public String getStringOption(String key) {
        Object o = this.getOption(key);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public ClassLoader getClassLoader(Object msgCtx) {
        try {
            return Loader.getTCL();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public abstract Object getOption(String var1);

    public abstract Object getProperty(Object var1, String var2);

    public abstract void setProperty(Object var1, String var2, Object var3);

    public abstract String getPassword(Object var1);

    public abstract void setPassword(Object var1, String var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

