/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.JmsPollingConsumer;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.JmsProviderMetadata;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryTopicEndpoint;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@ManagedResource(description="Managed JMS Endpoint")
@UriEndpoint(scheme="jms", title="JMS", syntax="jms:destinationType:destinationName", consumerClass=JmsConsumer.class, label="messaging")
public class JmsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
MultipleConsumersSupport,
Service {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicInteger runningMessageListeners = new AtomicInteger();
    private boolean pubSubDomain;
    private JmsBinding binding;
    @UriPath(defaultValue="queue", enums="queue,topic,temp:queue,temp:topic", description="The kind of destination to use")
    private String destinationType;
    @UriPath(description="Name of the queue or topic to use as destination")
    @Metadata(required="true")
    private String destinationName;
    private Destination destination;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter header to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam
    private JmsConfiguration configuration;

    public JmsEndpoint() {
        this(null, null);
    }

    public JmsEndpoint(Topic destination) throws JMSException {
        this("jms:topic:" + destination.getTopicName(), null);
        this.destination = destination;
        this.destinationType = "topic";
    }

    public JmsEndpoint(String uri, JmsComponent component, String destinationName, boolean pubSubDomain, JmsConfiguration configuration) {
        super(UnsafeUriCharactersEncoder.encode((String)uri), (Component)component);
        this.configuration = configuration;
        this.destinationName = destinationName;
        this.pubSubDomain = pubSubDomain;
        this.destinationType = pubSubDomain ? "topic" : "queue";
    }

    public JmsEndpoint(String endpointUri, JmsBinding binding, JmsConfiguration configuration, String destinationName, boolean pubSubDomain) {
        super(UnsafeUriCharactersEncoder.encode((String)endpointUri));
        this.binding = binding;
        this.configuration = configuration;
        this.destinationName = destinationName;
        this.pubSubDomain = pubSubDomain;
        this.destinationType = pubSubDomain ? "topic" : "queue";
    }

    public JmsEndpoint(String endpointUri, String destinationName, boolean pubSubDomain) {
        this(UnsafeUriCharactersEncoder.encode((String)endpointUri), null, new JmsConfiguration(), destinationName, pubSubDomain);
        this.binding = new JmsBinding(this);
        this.destinationType = pubSubDomain ? "topic" : "queue";
    }

    public JmsEndpoint(String endpointUri, String destinationName) {
        this(UnsafeUriCharactersEncoder.encode((String)endpointUri), destinationName, true);
    }

    public static JmsEndpoint newInstance(Destination destination, JmsComponent component) throws JMSException {
        JmsEndpoint answer = JmsEndpoint.newInstance(destination);
        JmsConfiguration newConfiguration = component.getConfiguration().copy();
        answer.setConfiguration(newConfiguration);
        answer.setCamelContext(component.getCamelContext());
        return answer;
    }

    public static JmsEndpoint newInstance(Destination destination) throws JMSException {
        if (destination instanceof TemporaryQueue) {
            return new JmsTemporaryQueueEndpoint((TemporaryQueue)destination);
        }
        if (destination instanceof TemporaryTopic) {
            return new JmsTemporaryTopicEndpoint((TemporaryTopic)destination);
        }
        if (destination instanceof Queue) {
            return new JmsQueueEndpoint((Queue)destination);
        }
        return new JmsEndpoint((Topic)destination);
    }

    public Producer createProducer() throws Exception {
        JmsProducer answer = new JmsProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public JmsConsumer createConsumer(Processor processor) throws Exception {
        AbstractMessageListenerContainer listenerContainer = this.createMessageListenerContainer();
        return this.createConsumer(processor, listenerContainer);
    }

    public AbstractMessageListenerContainer createMessageListenerContainer() throws Exception {
        return this.configuration.createMessageListenerContainer(this);
    }

    public void configureListenerContainer(AbstractMessageListenerContainer listenerContainer, JmsConsumer consumer) {
        if (this.destinationName != null) {
            listenerContainer.setDestinationName(this.destinationName);
            this.log.debug("Using destinationName: {} on listenerContainer: {}", (Object)this.destinationName, (Object)listenerContainer);
        } else if (this.destination != null) {
            listenerContainer.setDestination(this.destination);
            this.log.debug("Using destination: {} on listenerContainer: {}", (Object)this.destinationName, (Object)listenerContainer);
        } else {
            DestinationResolver resolver = this.getDestinationResolver();
            if (resolver == null) {
                throw new IllegalArgumentException("Neither destination, destinationName or destinationResolver are specified on this endpoint!");
            }
            listenerContainer.setDestinationResolver(resolver);
            this.log.debug("Using destinationResolver: {} on listenerContainer: {}", (Object)resolver, (Object)listenerContainer);
        }
        listenerContainer.setPubSubDomain(this.pubSubDomain);
        String consumerName = this.getThreadName();
        if (this.configuration.getTaskExecutor() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.configuration.getTaskExecutor(), (Object)listenerContainer);
            }
            this.setContainerTaskExecutor(listenerContainer, (Executor)this.configuration.getTaskExecutor());
            if (this.configuration.getTaskExecutor() instanceof ExecutorService) {
                consumer.setListenerContainerExecutorService((ExecutorService)this.configuration.getTaskExecutor(), false);
            }
        } else if (listenerContainer instanceof DefaultJmsMessageListenerContainer && this.configuration.getDefaultTaskExecutorType() == null || !(listenerContainer instanceof DefaultJmsMessageListenerContainer)) {
            ExecutorService executor = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)consumer, consumerName);
            this.setContainerTaskExecutor(listenerContainer, executor);
            consumer.setListenerContainerExecutorService(executor, true);
        } else {
            this.log.debug("Deferring creation of TaskExecutor for listener container: {} as per policy: {}", (Object)listenerContainer, (Object)this.configuration.getDefaultTaskExecutorType());
        }
        if (this.configuration.getTransactionName() == null && listenerContainer instanceof DefaultMessageListenerContainer) {
            ((DefaultMessageListenerContainer)listenerContainer).setTransactionName(consumerName);
        }
    }

    private void setContainerTaskExecutor(AbstractMessageListenerContainer listenerContainer, Executor executor) {
        if (listenerContainer instanceof SimpleMessageListenerContainer) {
            ((SimpleMessageListenerContainer)listenerContainer).setTaskExecutor(executor);
        } else if (listenerContainer instanceof DefaultMessageListenerContainer) {
            ((DefaultMessageListenerContainer)listenerContainer).setTaskExecutor(executor);
        }
    }

    public String getEndpointConfiguredDestinationName() {
        String remainder = ObjectHelper.after((String)this.getEndpointKey(), (String)"//");
        if (remainder != null && remainder.contains("?")) {
            remainder = ObjectHelper.before((String)remainder, (String)"?");
        }
        return JmsMessageHelper.normalizeDestinationName(remainder);
    }

    public JmsConsumer createConsumer(Processor processor, AbstractMessageListenerContainer listenerContainer) throws Exception {
        JmsConsumer consumer = new JmsConsumer(this, processor, listenerContainer);
        this.configureListenerContainer(listenerContainer, consumer);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        JmsPollingConsumer answer = new JmsPollingConsumer(this);
        this.configurePollingConsumer((PollingConsumer)answer);
        return answer;
    }

    public Exchange createExchange(ExchangePattern pattern) {
        Exchange exchange = super.createExchange(pattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        return exchange;
    }

    public Exchange createExchange(javax.jms.Message message, Session session) {
        Exchange exchange = this.createExchange(this.getExchangePattern());
        exchange.setIn((Message)new JmsMessage(message, session, this.getBinding()));
        return exchange;
    }

    public JmsOperations createInOnlyTemplate() {
        return this.configuration.createInOnlyTemplate(this, this.pubSubDomain, this.destinationName);
    }

    public JmsOperations createInOutTemplate() {
        return this.configuration.createInOutTemplate(this, this.pubSubDomain, this.destinationName, this.configuration.getRequestTimeout());
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public String getThreadName() {
        return "JmsConsumer[" + this.getEndpointConfiguredDestinationName() + "]";
    }

    public JmsComponent getComponent() {
        return (JmsComponent)super.getComponent();
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new JmsHeaderFilterStrategy(this.isIncludeAllJMSXProperties());
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.createBinding();
        }
        return this.binding;
    }

    protected JmsBinding createBinding() {
        return new JmsBinding(this);
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    @ManagedAttribute
    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public Class<? extends TemporaryQueue> getTemporaryQueueType() {
        JmsProviderMetadata metadata = this.getProviderMetadata();
        JmsOperations template = this.getMetadataJmsOperations();
        return metadata.getTemporaryQueueType(template);
    }

    public Class<? extends TemporaryTopic> getTemporaryTopicType() {
        JmsOperations template = this.getMetadataJmsOperations();
        JmsProviderMetadata metadata = this.getProviderMetadata();
        return metadata.getTemporaryTopicType(template);
    }

    protected JmsProviderMetadata getProviderMetadata() {
        JmsConfiguration conf = this.getConfiguration();
        JmsProviderMetadata metadata = conf.getProviderMetadata();
        return metadata;
    }

    protected JmsOperations getMetadataJmsOperations() {
        JmsOperations template = this.getConfiguration().getMetadataJmsOperations(this);
        if (template == null) {
            throw new IllegalArgumentException("No Metadata JmsTemplate supplied!");
        }
        return template;
    }

    protected ExecutorService getAsyncStartStopExecutorService() {
        if (this.getComponent() == null) {
            throw new IllegalStateException("AsyncStartStopListener requires JmsComponent to be configured on this endpoint: " + (Object)((Object)this));
        }
        return this.getComponent().getAsyncStartStopExecutorService();
    }

    public void onListenerContainerStarting(AbstractMessageListenerContainer container) {
        this.runningMessageListeners.incrementAndGet();
    }

    public void onListenerContainerStopped(AbstractMessageListenerContainer container) {
        this.runningMessageListeners.decrementAndGet();
    }

    protected boolean isRunning() {
        return this.isStarted();
    }

    public void stop() throws Exception {
        int running = this.runningMessageListeners.get();
        if (running <= 0) {
            super.stop();
        } else {
            this.log.trace("There are still {} running message listeners. Cannot stop endpoint {}", (Object)running, (Object)this);
        }
    }

    public void shutdown() throws Exception {
        int running = this.runningMessageListeners.get();
        if (running <= 0) {
            super.shutdown();
        } else {
            this.log.trace("There are still {} running message listeners. Cannot shutdown endpoint {}", (Object)running, (Object)this);
        }
    }

    @ManagedAttribute
    public int getAcknowledgementMode() {
        return this.getConfiguration().getAcknowledgementMode();
    }

    @ManagedAttribute
    public String getAcknowledgementModeName() {
        return this.getConfiguration().getAcknowledgementModeName();
    }

    @ManagedAttribute
    public int getCacheLevel() {
        return this.getConfiguration().getCacheLevel();
    }

    @ManagedAttribute
    public String getCacheLevelName() {
        return this.getConfiguration().getCacheLevelName();
    }

    @ManagedAttribute
    public String getReplyToCacheLevelName() {
        return this.getConfiguration().getReplyToCacheLevelName();
    }

    @ManagedAttribute
    public String getClientId() {
        return this.getConfiguration().getClientId();
    }

    @ManagedAttribute
    public int getConcurrentConsumers() {
        return this.getConfiguration().getConcurrentConsumers();
    }

    @ManagedAttribute
    public int getReplyToConcurrentConsumers() {
        return this.getConfiguration().getReplyToConcurrentConsumers();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.getConfiguration().getConnectionFactory();
    }

    public DestinationResolver getDestinationResolver() {
        return this.getConfiguration().getDestinationResolver();
    }

    @ManagedAttribute
    public String getDurableSubscriptionName() {
        return this.getConfiguration().getDurableSubscriptionName();
    }

    public ExceptionListener getExceptionListener() {
        return this.getConfiguration().getExceptionListener();
    }

    public ErrorHandler getErrorHandler() {
        return this.getConfiguration().getErrorHandler();
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return this.getConfiguration().getErrorHandlerLoggingLevel();
    }

    @ManagedAttribute
    public boolean isErrorHandlerLogStackTrace() {
        return this.getConfiguration().isErrorHandlerLogStackTrace();
    }

    @ManagedAttribute
    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.getConfiguration().setErrorHandlerLogStackTrace(errorHandlerLogStackTrace);
    }

    @ManagedAttribute
    public int getIdleTaskExecutionLimit() {
        return this.getConfiguration().getIdleTaskExecutionLimit();
    }

    @ManagedAttribute
    public int getIdleConsumerLimit() {
        return this.getConfiguration().getIdleConsumerLimit();
    }

    public JmsOperations getJmsOperations() {
        return this.getConfiguration().getJmsOperations();
    }

    public ConnectionFactory getListenerConnectionFactory() {
        return this.getConfiguration().getListenerConnectionFactory();
    }

    @ManagedAttribute
    public int getMaxConcurrentConsumers() {
        return this.getConfiguration().getMaxConcurrentConsumers();
    }

    @ManagedAttribute
    public int getReplyToMaxConcurrentConsumers() {
        return this.getConfiguration().getReplyToMaxConcurrentConsumers();
    }

    @ManagedAttribute
    public int getMaxMessagesPerTask() {
        return this.getConfiguration().getMaxMessagesPerTask();
    }

    public MessageConverter getMessageConverter() {
        return this.getConfiguration().getMessageConverter();
    }

    public JmsOperations getMetadataJmsOperations(JmsEndpoint endpoint) {
        return this.getConfiguration().getMetadataJmsOperations(endpoint);
    }

    @ManagedAttribute
    public int getPriority() {
        return this.getConfiguration().getPriority();
    }

    @ManagedAttribute
    public long getReceiveTimeout() {
        return this.getConfiguration().getReceiveTimeout();
    }

    @ManagedAttribute
    public long getRecoveryInterval() {
        return this.getConfiguration().getRecoveryInterval();
    }

    @ManagedAttribute
    public String getReplyTo() {
        return this.getConfiguration().getReplyTo();
    }

    @ManagedAttribute
    public String getReplyToOverride() {
        return this.getConfiguration().getReplyToOverride();
    }

    @ManagedAttribute
    public boolean isReplyToSameDestinationAllowed() {
        return this.getConfiguration().isReplyToSameDestinationAllowed();
    }

    @ManagedAttribute
    public String getReplyToDestinationSelectorName() {
        return this.getConfiguration().getReplyToDestinationSelectorName();
    }

    @ManagedAttribute
    public long getRequestTimeout() {
        return this.getConfiguration().getRequestTimeout();
    }

    @ManagedAttribute
    public long getRequestTimeoutCheckerInterval() {
        return this.getConfiguration().getRequestTimeoutCheckerInterval();
    }

    public TaskExecutor getTaskExecutor() {
        return this.getConfiguration().getTaskExecutor();
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        return this.getConfiguration().getTemplateConnectionFactory();
    }

    @ManagedAttribute
    public long getTimeToLive() {
        return this.getConfiguration().getTimeToLive();
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.getConfiguration().getTransactionManager();
    }

    @ManagedAttribute
    public String getTransactionName() {
        return this.getConfiguration().getTransactionName();
    }

    @ManagedAttribute
    public int getTransactionTimeout() {
        return this.getConfiguration().getTransactionTimeout();
    }

    @ManagedAttribute
    public boolean isAcceptMessagesWhileStopping() {
        return this.getConfiguration().isAcceptMessagesWhileStopping();
    }

    @ManagedAttribute
    public boolean isAlwaysCopyMessage() {
        return this.getConfiguration().isAlwaysCopyMessage();
    }

    @ManagedAttribute
    public boolean isAutoStartup() {
        return this.getConfiguration().isAutoStartup();
    }

    @ManagedAttribute
    public boolean isDeliveryPersistent() {
        return this.getConfiguration().isDeliveryPersistent();
    }

    @ManagedAttribute
    public Integer getDeliveryMode() {
        return this.getConfiguration().getDeliveryMode();
    }

    @ManagedAttribute
    public boolean isDisableReplyTo() {
        return this.getConfiguration().isDisableReplyTo();
    }

    @ManagedAttribute
    public boolean isEagerLoadingOfProperties() {
        return this.getConfiguration().isEagerLoadingOfProperties();
    }

    @ManagedAttribute
    public boolean isExplicitQosEnabled() {
        return this.getConfiguration().isExplicitQosEnabled();
    }

    @ManagedAttribute
    public boolean isExposeListenerSession() {
        return this.getConfiguration().isExposeListenerSession();
    }

    @ManagedAttribute
    public boolean isMessageIdEnabled() {
        return this.getConfiguration().isMessageIdEnabled();
    }

    @ManagedAttribute
    public boolean isMessageTimestampEnabled() {
        return this.getConfiguration().isMessageTimestampEnabled();
    }

    @ManagedAttribute
    public boolean isPreserveMessageQos() {
        return this.getConfiguration().isPreserveMessageQos();
    }

    @ManagedAttribute
    public boolean isPubSubNoLocal() {
        return this.getConfiguration().isPubSubNoLocal();
    }

    @ManagedAttribute
    public boolean isReplyToDeliveryPersistent() {
        return this.getConfiguration().isReplyToDeliveryPersistent();
    }

    @ManagedAttribute
    @Deprecated
    public boolean isSubscriptionDurable() {
        return this.getConfiguration().isSubscriptionDurable();
    }

    @ManagedAttribute
    public boolean isTransacted() {
        return this.getConfiguration().isTransacted();
    }

    @ManagedAttribute
    public boolean isLazyCreateTransactionManager() {
        return this.getConfiguration().isLazyCreateTransactionManager();
    }

    @ManagedAttribute
    @Deprecated
    public boolean isTransactedInOut() {
        return this.getConfiguration().isTransactedInOut();
    }

    @ManagedAttribute
    public boolean isUseMessageIDAsCorrelationID() {
        return this.getConfiguration().isUseMessageIDAsCorrelationID();
    }

    @ManagedAttribute
    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.getConfiguration().setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    @ManagedAttribute
    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementMode(consumerAcknowledgementMode);
    }

    @ManagedAttribute
    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    @ManagedAttribute
    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.getConfiguration().setAlwaysCopyMessage(alwaysCopyMessage);
    }

    @ManagedAttribute
    public void setAutoStartup(boolean autoStartup) {
        this.getConfiguration().setAutoStartup(autoStartup);
    }

    @ManagedAttribute
    public void setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
    }

    @ManagedAttribute
    public void setCacheLevelName(String cacheName) {
        this.getConfiguration().setCacheLevelName(cacheName);
    }

    @ManagedAttribute
    public void setReplyToCacheLevelName(String cacheName) {
        this.getConfiguration().setReplyToCacheLevelName(cacheName);
    }

    @ManagedAttribute
    public void setClientId(String consumerClientId) {
        this.getConfiguration().setClientId(consumerClientId);
    }

    @ManagedAttribute
    public void setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
    }

    @ManagedAttribute
    public void setReplyToConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setReplyToConcurrentConsumers(concurrentConsumers);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    @ManagedAttribute
    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.getConfiguration().setDeliveryPersistent(deliveryPersistent);
    }

    @ManagedAttribute
    public void setDeliveryMode(Integer deliveryMode) {
        this.getConfiguration().setDeliveryMode(deliveryMode);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.getConfiguration().setDestinationResolver(destinationResolver);
    }

    @ManagedAttribute
    public void setDisableReplyTo(boolean disableReplyTo) {
        this.getConfiguration().setDisableReplyTo(disableReplyTo);
    }

    @ManagedAttribute
    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
    }

    @ManagedAttribute
    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.getConfiguration().setEagerLoadingOfProperties(eagerLoadingOfProperties);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.getConfiguration().setExceptionListener(exceptionListener);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getConfiguration().setErrorHandler(errorHandler);
    }

    @ManagedAttribute
    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.getConfiguration().setExplicitQosEnabled(explicitQosEnabled);
    }

    @ManagedAttribute
    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.getConfiguration().setExposeListenerSession(exposeListenerSession);
    }

    @ManagedAttribute
    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.getConfiguration().setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    @ManagedAttribute
    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.getConfiguration().setIdleConsumerLimit(idleConsumerLimit);
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.getConfiguration().setJmsOperations(jmsOperations);
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.getConfiguration().setListenerConnectionFactory(listenerConnectionFactory);
    }

    @ManagedAttribute
    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @ManagedAttribute
    public void setReplyToMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setReplyToMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    @ManagedAttribute
    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.getConfiguration().setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.getConfiguration().setMessageConverter(messageConverter);
    }

    @ManagedAttribute
    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.getConfiguration().setMessageIdEnabled(messageIdEnabled);
    }

    @ManagedAttribute
    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.getConfiguration().setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public void setMetadataJmsOperations(JmsOperations metadataJmsOperations) {
        this.getConfiguration().setMetadataJmsOperations(metadataJmsOperations);
    }

    @ManagedAttribute
    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.getConfiguration().setPreserveMessageQos(preserveMessageQos);
    }

    @ManagedAttribute
    public void setPriority(int priority) {
        this.getConfiguration().setPriority(priority);
    }

    public void setProviderMetadata(JmsProviderMetadata providerMetadata) {
        this.getConfiguration().setProviderMetadata(providerMetadata);
    }

    @ManagedAttribute
    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.getConfiguration().setPubSubNoLocal(pubSubNoLocal);
    }

    @ManagedAttribute
    public void setReceiveTimeout(long receiveTimeout) {
        this.getConfiguration().setReceiveTimeout(receiveTimeout);
    }

    @ManagedAttribute
    public void setRecoveryInterval(long recoveryInterval) {
        this.getConfiguration().setRecoveryInterval(recoveryInterval);
    }

    @ManagedAttribute
    public void setReplyTo(String replyToDestination) {
        this.getConfiguration().setReplyTo(replyToDestination);
    }

    @ManagedAttribute
    public void setReplyToOverride(String replyToDestination) {
        this.getConfiguration().setReplyToOverride(replyToDestination);
    }

    @ManagedAttribute
    public void setReplyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
        this.getConfiguration().setReplyToSameDestinationAllowed(replyToSameDestinationAllowed);
    }

    @ManagedAttribute
    public void setReplyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
        this.getConfiguration().setReplyToDeliveryPersistent(replyToDeliveryPersistent);
    }

    @ManagedAttribute
    public void setReplyToDestinationSelectorName(String replyToDestinationSelectorName) {
        this.getConfiguration().setReplyToDestinationSelectorName(replyToDestinationSelectorName);
    }

    @ManagedAttribute
    public void setRequestTimeout(long requestTimeout) {
        this.getConfiguration().setRequestTimeout(requestTimeout);
    }

    @ManagedAttribute
    @Deprecated
    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.getConfiguration().setSubscriptionDurable(subscriptionDurable);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.getConfiguration().setTaskExecutor(taskExecutor);
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.getConfiguration().setTemplateConnectionFactory(templateConnectionFactory);
    }

    @ManagedAttribute
    public void setTimeToLive(long timeToLive) {
        this.getConfiguration().setTimeToLive(timeToLive);
    }

    @ManagedAttribute
    public void setTransacted(boolean consumerTransacted) {
        this.getConfiguration().setTransacted(consumerTransacted);
    }

    @ManagedAttribute
    @Deprecated
    public void setTransactedInOut(boolean transactedInOut) {
        this.getConfiguration().setTransactedInOut(transactedInOut);
    }

    @ManagedAttribute
    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.getConfiguration().setLazyCreateTransactionManager(lazyCreating);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.getConfiguration().setTransactionManager(transactionManager);
    }

    @ManagedAttribute
    public void setTransactionName(String transactionName) {
        this.getConfiguration().setTransactionName(transactionName);
    }

    @ManagedAttribute
    public void setTransactionTimeout(int transactionTimeout) {
        this.getConfiguration().setTransactionTimeout(transactionTimeout);
    }

    @ManagedAttribute
    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.getConfiguration().setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    public JmsMessageType getJmsMessageType() {
        return this.getConfiguration().getJmsMessageType();
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        this.getConfiguration().setJmsMessageType(jmsMessageType);
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.getConfiguration().getJmsKeyFormatStrategy();
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsHeaderStrategy) {
        this.getConfiguration().setJmsKeyFormatStrategy(jmsHeaderStrategy);
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.getConfiguration().getMessageCreatedStrategy();
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.getConfiguration().setMessageCreatedStrategy(messageCreatedStrategy);
    }

    @ManagedAttribute
    public boolean isTransferExchange() {
        return this.getConfiguration().isTransferExchange();
    }

    @ManagedAttribute
    public void setTransferExchange(boolean transferExchange) {
        this.getConfiguration().setTransferExchange(transferExchange);
    }

    @ManagedAttribute
    public boolean isTransferException() {
        return this.getConfiguration().isTransferException();
    }

    @ManagedAttribute
    public void setTransferException(boolean transferException) {
        this.getConfiguration().setTransferException(transferException);
    }

    @ManagedAttribute
    public boolean isTestConnectionOnStartup() {
        return this.configuration.isTestConnectionOnStartup();
    }

    @ManagedAttribute
    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.configuration.setTestConnectionOnStartup(testConnectionOnStartup);
    }

    @ManagedAttribute
    public boolean isForceSendOriginalMessage() {
        return this.configuration.isForceSendOriginalMessage();
    }

    @ManagedAttribute
    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.configuration.setForceSendOriginalMessage(forceSendOriginalMessage);
    }

    @ManagedAttribute
    public boolean isDisableTimeToLive() {
        return this.configuration.isDisableTimeToLive();
    }

    @ManagedAttribute
    public void setDisableTimeToLive(boolean disableTimeToLive) {
        this.configuration.setDisableTimeToLive(disableTimeToLive);
    }

    @ManagedAttribute
    public void setAsyncConsumer(boolean asyncConsumer) {
        this.configuration.setAsyncConsumer(asyncConsumer);
    }

    @ManagedAttribute
    public boolean isAsyncConsumer() {
        return this.configuration.isAsyncConsumer();
    }

    @ManagedAttribute
    public void setAsyncStartListener(boolean asyncStartListener) {
        this.configuration.setAsyncStartListener(asyncStartListener);
    }

    @ManagedAttribute
    public boolean isAsyncStartListener() {
        return this.configuration.isAsyncStartListener();
    }

    @ManagedAttribute
    public void setAsyncStopListener(boolean asyncStopListener) {
        this.configuration.setAsyncStopListener(asyncStopListener);
    }

    @ManagedAttribute
    public boolean isAsyncStopListener() {
        return this.configuration.isAsyncStopListener();
    }

    @ManagedAttribute
    public boolean isAllowNullBody() {
        return this.configuration.isAllowNullBody();
    }

    @ManagedAttribute
    public void setAllowNullBody(boolean allowNullBody) {
        this.configuration.setAllowNullBody(allowNullBody);
    }

    @ManagedAttribute
    public boolean isIncludeSentJMSMessageID() {
        return this.configuration.isIncludeSentJMSMessageID();
    }

    @ManagedAttribute
    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.configuration.setIncludeSentJMSMessageID(includeSentJMSMessageID);
    }

    @ManagedAttribute
    public boolean isIncludeAllJMSXProperties() {
        return this.configuration.isIncludeAllJMSXProperties();
    }

    @ManagedAttribute
    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.configuration.setIncludeAllJMSXProperties(includeAllJMSXProperties);
    }

    @ManagedAttribute
    public DefaultTaskExecutorType getDefaultTaskExecutorType() {
        return this.configuration.getDefaultTaskExecutorType();
    }

    public void setDefaultTaskExecutorType(DefaultTaskExecutorType type) {
        this.configuration.setDefaultTaskExecutorType(type);
    }

    public MessageListenerContainerFactory getMessageListenerContainerFactory() {
        return this.configuration.getMessageListenerContainerFactory();
    }

    public void setMessageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
        this.configuration.setMessageListenerContainerFactory(messageListenerContainerFactory);
        this.configuration.setConsumerType(ConsumerType.Custom);
    }

    @ManagedAttribute
    public String getReplyToType() {
        if (this.configuration.getReplyToType() != null) {
            return this.configuration.getReplyToType().name();
        }
        return null;
    }

    @ManagedAttribute
    public void setReplyToType(String replyToType) {
        ReplyToType type = ReplyToType.valueOf(replyToType);
        this.configuration.setReplyToType(type);
    }

    @ManagedAttribute(description="Number of running message listeners")
    public int getRunningMessageListeners() {
        return this.runningMessageListeners.get();
    }

    @ManagedAttribute
    public String getSelector() {
        return this.configuration.getSelector();
    }

    public void setSelector(String selector) {
        this.configuration.setSelector(selector);
    }

    protected String createEndpointUri() {
        String scheme = "jms";
        if (this.destination != null) {
            return scheme + ":" + this.destination;
        }
        if (this.destinationName != null) {
            return scheme + ":" + this.destinationName;
        }
        DestinationResolver resolver = this.getDestinationResolver();
        if (resolver != null) {
            return scheme + ":" + resolver;
        }
        return super.createEndpointUri();
    }
}

