/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.binding;

import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.binding.BindingEndpoint;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public class BindingConsumerProcessor
extends ServiceSupport
implements Processor {
    private final BindingEndpoint endpoint;
    private final Processor delegateProcessor;
    private final Processor bindingProcessor;

    public BindingConsumerProcessor(BindingEndpoint endpoint, Processor delegateProcessor) {
        this.endpoint = endpoint;
        this.delegateProcessor = delegateProcessor;
        this.bindingProcessor = endpoint.getBinding().createConsumeProcessor();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.endpoint.pipelineBindingProcessor(this.bindingProcessor, exchange, this.delegateProcessor);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.bindingProcessor instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.bindingProcessor)).setCamelContext(this.endpoint.getCamelContext());
        }
        if (this.delegateProcessor instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.delegateProcessor)).setCamelContext(this.endpoint.getCamelContext());
        }
        ServiceHelper.startServices(this.bindingProcessor, this.delegateProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.delegateProcessor, this.bindingProcessor);
    }
}

