/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.codec;

import java.util.Random;
import org.linkedin.util.codec.Codec;
import org.linkedin.util.codec.CodecUtils;

public class Base64Codec
implements Codec {
    public static final Base64Codec INSTANCE = new Base64Codec();
    public static final int NUM_BITS_PER_DIGIT = 6;
    private char[] _radix = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '_'};
    private int[] _reverseRadix;
    private static final int INT_RADIX_MASK = 63;

    public Base64Codec() {
        this.init();
    }

    public Base64Codec(Random rnd) {
        Base64Codec.shuffle(this._radix, rnd);
        this.init();
    }

    public Base64Codec(String password) {
        this(CodecUtils.createRandom(password));
    }

    private void init() {
        int i;
        this._reverseRadix = new int[128];
        for (i = 0; i < this._reverseRadix.length; ++i) {
            this._reverseRadix[i] = -1;
        }
        for (i = 0; i < this._radix.length; ++i) {
            this._reverseRadix[this._radix[i]] = i;
        }
        this._reverseRadix[46] = this._reverseRadix[45];
    }

    @Override
    public String encode(byte[] byteArray) {
        int c;
        int d;
        int b;
        int l = byteArray.length * 8 / 6;
        if (l % 4 != 0) {
            ++l;
        }
        char[] conv = new char[l];
        int i = 0;
        int k = conv.length - 1;
        while (i <= byteArray.length - 3) {
            b = byteArray[i++] & 0xFF;
            conv[k--] = this._radix[b & 0x3F];
            b >>>= 6;
            d = byteArray[i++] & 0xFF;
            c = d << 2 & 0x3C;
            conv[k--] = this._radix[b |= c];
            b = d >>> 4;
            d = byteArray[i++] & 0xFF;
            c = d << 4 & 0x30;
            conv[k--] = this._radix[b |= c];
            b = d >>> 2;
            conv[k--] = this._radix[b];
        }
        if (i == byteArray.length - 2) {
            b = byteArray[i++] & 0xFF;
            conv[k--] = this._radix[b & 0x3F];
            b >>>= 6;
            d = byteArray[i] & 0xFF;
            c = d << 2 & 0x3C;
            conv[k--] = this._radix[b |= c];
            b = d >>> 4;
            conv[k] = this._radix[b];
            return new String(conv);
        }
        if (i == byteArray.length - 1) {
            b = byteArray[i] & 0xFF;
            conv[k--] = this._radix[b & 0x3F];
            conv[k] = this._radix[b >>>= 6];
        }
        return new String(conv);
    }

    @Override
    public byte[] decode(String s) throws Codec.CannotDecodeException {
        char[] array = s.toCharArray();
        int start = 0;
        int len = array.length - start;
        int l = len * 6 / 8;
        boolean checkLast = false;
        if (l % 3 != 0) {
            ++l;
            checkLast = true;
        }
        byte[] res = new byte[l];
        int i = 0;
        int k = array.length - 1;
        try {
            int d;
            int c;
            int b;
            while (k >= start + 3) {
                c = b = this._reverseRadix[array[k--]];
                b = this._reverseRadix[array[k--]];
                d = b << 6 & 0xC0;
                res[i++] = (byte)(c |= d);
                c = b >>> 2;
                b = this._reverseRadix[array[k--]];
                d = b << 4 & 0xF0;
                res[i++] = (byte)(c |= d);
                c = b >>> 4;
                b = this._reverseRadix[array[k--]];
                d = b << 2 & 0xFC;
                res[i++] = (byte)(c |= d);
            }
            if (k == start + 2) {
                c = b = this._reverseRadix[array[k--]];
                b = this._reverseRadix[array[k--]];
                d = b << 6 & 0xC0;
                res[i++] = (byte)(c |= d);
                c = b >>> 2;
                b = this._reverseRadix[array[k]];
                d = b << 4 & 0xF0;
                res[i] = (byte)(c |= d);
            } else if (k == start + 1) {
                c = b = this._reverseRadix[array[k--]];
                b = this._reverseRadix[array[k]];
                d = b << 6 & 0xC0;
                res[i++] = (byte)(c |= d);
                c = b >>> 2;
                res[i] = (byte)c;
            } else if (k == start) {
                res[i] = (byte)this._reverseRadix[array[k]];
            }
            if (checkLast && res[l - 1] == 0) {
                byte[] res2 = new byte[l - 1];
                System.arraycopy(res, 0, res2, 0, l - 1);
                res = res2;
            }
        }
        catch (Exception ex) {
            throw new Codec.CannotDecodeException(s);
        }
        return res;
    }

    public static char[] shuffle(char[] array, Random random) {
        for (int i = array.length - 1; i > 2; --i) {
            int idx = random.nextInt(i);
            char tmp = array[idx];
            array[idx] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public String encode(long bits, int numbits) {
        char[] encoded = new char[(numbits + 5) / 6];
        for (int i = 0; i < encoded.length; ++i) {
            encoded[i] = this._radix[(byte)bits & 0x3F];
            bits >>>= 6;
        }
        return new String(encoded);
    }

    public long decode(String s, int numbits) {
        if (numbits > 64) {
            numbits = 64;
        }
        int numDigits = (numbits + 5) / 6;
        if (s.length() < numDigits) {
            numDigits = s.length();
        }
        long bits = 0L;
        for (int i = numDigits - 1; 0 <= i; --i) {
            int digit;
            bits <<= 6;
            char c = s.charAt(i);
            int n = digit = '\u0000' <= c && c < this._reverseRadix.length ? this._reverseRadix[c] : -1;
            if (digit == -1) continue;
            bits |= (long)digit;
        }
        return bits;
    }

    public byte decode(char c) {
        return (byte)this._reverseRadix[c & 0x7F];
    }
}

