/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.util.Assert;

public abstract class AbstractCacheInvoker {
    private CacheErrorHandler errorHandler;

    protected AbstractCacheInvoker(CacheErrorHandler errorHandler) {
        Assert.notNull("ErrorHandler must not be null");
        this.errorHandler = errorHandler;
    }

    protected AbstractCacheInvoker() {
        this(new SimpleCacheErrorHandler());
    }

    public void setErrorHandler(CacheErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CacheErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected Cache.ValueWrapper doGet(Cache cache, Object key) {
        try {
            return cache.get(key);
        }
        catch (RuntimeException e) {
            this.getErrorHandler().handleCacheGetError(e, cache, key);
            return null;
        }
    }

    protected void doPut(Cache cache, Object key, Object result) {
        try {
            cache.put(key, result);
        }
        catch (RuntimeException e) {
            this.getErrorHandler().handleCachePutError(e, cache, key, result);
        }
    }

    protected void doEvict(Cache cache, Object key) {
        try {
            cache.evict(key);
        }
        catch (RuntimeException e) {
            this.getErrorHandler().handleCacheEvictError(e, cache, key);
        }
    }

    protected void doClear(Cache cache) {
        try {
            cache.clear();
        }
        catch (RuntimeException e) {
            this.getErrorHandler().handleCacheClearError(e, cache);
        }
    }
}

