/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.CaseFrobStream;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.Stream;

public final class CapitalizeStream
extends CaseFrobStream {
    private boolean inWord;

    public CapitalizeStream(Stream target) {
        super(target);
    }

    public void _writeChar(char c) {
        if (this.inWord) {
            if (Character.isUpperCase(c)) {
                c = LispCharacter.toLowerCase(c);
            } else if (!Character.isLowerCase(c) && !Character.isDigit(c)) {
                this.inWord = false;
            }
        } else if (Character.isUpperCase(c)) {
            this.inWord = true;
        } else if (Character.isLowerCase(c)) {
            c = LispCharacter.toUpperCase(c);
            this.inWord = true;
        } else if (Character.isDigit(c)) {
            this.inWord = true;
        }
        this.target._writeChar(c);
    }

    public void _writeString(String s) {
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            this._writeChar(s.charAt(i));
        }
    }

    public void _writeLine(String s) {
        this.target._writeString(s);
        this.target._writeChar('\n');
    }
}

