<?php
return [
	'maintenances' => [
		'key' => 'maintenanceid',
		'fields' => [
			'maintenanceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'maintenance_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'description' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'active_since' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'active_till' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'hosts' => [
		'key' => 'hostid',
		'fields' => [
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'proxy_hostid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'disable_until' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'available' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'errors_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastaccess' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ipmi_authtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ipmi_privilege' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'ipmi_username' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			],
			'ipmi_password' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 20,
				'default' => '',
			],
			'ipmi_disable_until' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ipmi_available' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmp_disable_until' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmp_available' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'maintenanceid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			],
			'maintenance_status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'maintenance_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'maintenance_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ipmi_errors_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmp_errors_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ipmi_error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'snmp_error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'jmx_disable_until' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'jmx_available' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'jmx_errors_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'jmx_error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'description' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'tls_connect' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'tls_accept' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'tls_issuer' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 1024,
				'default' => '',
			],
			'tls_subject' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 1024,
				'default' => '',
			],
			'tls_psk_identity' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'tls_psk' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 512,
				'default' => '',
			],
		],
	],
	'groups' => [
		'key' => 'groupid',
		'fields' => [
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'internal' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'group_prototype' => [
		'key' => 'group_prototypeid',
		'fields' => [
			'group_prototypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'groupid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'group_prototype',
				'ref_field' => 'group_prototypeid',
			],
		],
	],
	'group_discovery' => [
		'key' => 'groupid',
		'fields' => [
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
			'parent_group_prototypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'group_prototype',
				'ref_field' => 'group_prototypeid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'lastcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ts_delete' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'screens' => [
		'key' => 'screenid',
		'fields' => [
			'screenid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			],
			'hsize' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'vsize' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'userid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'private' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
		],
	],
	'screens_items' => [
		'key' => 'screenitemid',
		'fields' => [
			'screenitemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'screenid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'screens',
				'ref_field' => 'screenid',
			],
			'resourcetype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'resourceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			],
			'width' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '320',
			],
			'height' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			],
			'x' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'y' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'colspan' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'rowspan' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'elements' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '25',
			],
			'valign' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'halign' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'style' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'url' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'dynamic' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'sort_triggers' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'application' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'max_columns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '3',
			],
		],
	],
	'screen_user' => [
		'key' => 'screenuserid',
		'fields' => [
			'screenuserid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'screenid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'screens',
				'ref_field' => 'screenid',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
		],
	],
	'screen_usrgrp' => [
		'key' => 'screenusrgrpid',
		'fields' => [
			'screenusrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'screenid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'screens',
				'ref_field' => 'screenid',
			],
			'usrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
		],
	],
	'slideshows' => [
		'key' => 'slideshowid',
		'fields' => [
			'slideshowid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'delay' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'private' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
		],
	],
	'slideshow_user' => [
		'key' => 'slideshowuserid',
		'fields' => [
			'slideshowuserid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'slideshowid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'slideshows',
				'ref_field' => 'slideshowid',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
		],
	],
	'slideshow_usrgrp' => [
		'key' => 'slideshowusrgrpid',
		'fields' => [
			'slideshowusrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'slideshowid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'slideshows',
				'ref_field' => 'slideshowid',
			],
			'usrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
		],
	],
	'slides' => [
		'key' => 'slideid',
		'fields' => [
			'slideid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'slideshowid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'slideshows',
				'ref_field' => 'slideshowid',
			],
			'screenid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'screens',
				'ref_field' => 'screenid',
			],
			'step' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'delay' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'drules' => [
		'key' => 'druleid',
		'fields' => [
			'druleid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'proxy_hostid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'iprange' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'delay' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '3600',
			],
			'nextcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'dchecks' => [
		'key' => 'dcheckid',
		'fields' => [
			'dcheckid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'druleid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'drules',
				'ref_field' => 'druleid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'key_' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'snmp_community' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ports' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			],
			'snmpv3_securityname' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'snmpv3_securitylevel' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_authpassphrase' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'snmpv3_privpassphrase' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'uniq' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_authprotocol' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_privprotocol' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_contextname' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'applications' => [
		'key' => 'applicationid',
		'fields' => [
			'applicationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'httptest' => [
		'key' => 'httptestid',
		'fields' => [
			'httptestid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'applicationid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			],
			'nextcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'delay' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '60',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'variables' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'agent' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => 'Zabbix',
			],
			'authentication' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'http_user' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'http_password' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httptest',
				'ref_field' => 'httptestid',
			],
			'http_proxy' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'retries' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'ssl_cert_file' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ssl_key_file' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ssl_key_password' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'verify_peer' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'verify_host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'headers' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
		],
	],
	'httpstep' => [
		'key' => 'httpstepid',
		'fields' => [
			'httpstepid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'httptestid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httptest',
				'ref_field' => 'httptestid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'no' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'url' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'timeout' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '15',
			],
			'posts' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'required' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'status_codes' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'variables' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'follow_redirects' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'retrieve_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'headers' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
		],
	],
	'interface' => [
		'key' => 'interfaceid',
		'fields' => [
			'interfaceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'main' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'useip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '127.0.0.1',
			],
			'dns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '10050',
			],
			'bulk' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
		],
	],
	'valuemaps' => [
		'key' => 'valuemapid',
		'fields' => [
			'valuemapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
		],
	],
	'items' => [
		'key' => 'itemid',
		'fields' => [
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmp_community' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'snmp_oid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'key_' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'delay' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'history' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '90',
			],
			'trends' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'trapper_hosts' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'units' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'multiplier' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'delta' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_securityname' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'snmpv3_securitylevel' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_authpassphrase' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'snmpv3_privpassphrase' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'formula' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'lastlogsize' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			],
			'logtimefmt' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'valuemapid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'valuemaps',
				'ref_field' => 'valuemapid',
			],
			'delay_flex' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'params' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'ipmi_sensor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'data_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'authtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'username' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'password' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'publickey' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'privatekey' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'mtime' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'interfaceid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'interface',
				'ref_field' => 'interfaceid',
			],
			'port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'description' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'inventory_link' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lifetime' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '30',
			],
			'snmpv3_authprotocol' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_privprotocol' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'state' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'snmpv3_contextname' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'evaltype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'httpstepitem' => [
		'key' => 'httpstepitemid',
		'fields' => [
			'httpstepitemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'httpstepid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httpstep',
				'ref_field' => 'httpstepid',
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'httptestitem' => [
		'key' => 'httptestitemid',
		'fields' => [
			'httptestitemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'httptestid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'httptest',
				'ref_field' => 'httptestid',
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'media_type' => [
		'key' => 'mediatypeid',
		'fields' => [
			'mediatypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'description' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			],
			'smtp_server' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'smtp_helo' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'smtp_email' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'exec_path' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'gsm_modem' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'username' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'passwd' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'smtp_port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '25',
			],
			'smtp_security' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'smtp_verify_peer' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'smtp_verify_host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'smtp_authentication' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'exec_params' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'users' => [
		'key' => 'userid',
		'fields' => [
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'alias' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			],
			'surname' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			],
			'passwd' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			],
			'url' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'autologin' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'autologout' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '900',
			],
			'lang' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 5,
				'default' => 'en_GB',
			],
			'refresh' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '30',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'theme' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => 'default',
			],
			'attempt_failed' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			],
			'attempt_ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'attempt_clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
			],
			'rows_per_page' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 50,
			],
		],
	],
	'usrgrp' => [
		'key' => 'usrgrpid',
		'fields' => [
			'usrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'gui_access' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'users_status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'debug_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'users_groups' => [
		'key' => 'id',
		'fields' => [
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'usrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
		],
	],
	'scripts' => [
		'key' => 'scriptid',
		'fields' => [
			'scriptid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'command' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'host_access' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'usrgrpid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'groupid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
			'description' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'confirmation' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'execute_on' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
		],
	],
	'actions' => [
		'key' => 'actionid',
		'fields' => [
			'actionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'eventsource' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'evaltype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'esc_period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'def_shortdata' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'def_longdata' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'recovery_msg' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'r_shortdata' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'r_longdata' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'formula' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'operations' => [
		'key' => 'operationid',
		'fields' => [
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'actionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			],
			'operationtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'esc_period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'esc_step_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'esc_step_to' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'evaltype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'opmessage' => [
		'key' => 'operationid',
		'fields' => [
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'default_msg' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'subject' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'message' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'mediatypeid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'media_type',
				'ref_field' => 'mediatypeid',
			],
		],
	],
	'opmessage_grp' => [
		'key' => 'opmessage_grpid',
		'fields' => [
			'opmessage_grpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'usrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
		],
	],
	'opmessage_usr' => [
		'key' => 'opmessage_usrid',
		'fields' => [
			'opmessage_usrid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
		],
	],
	'opcommand' => [
		'key' => 'operationid',
		'fields' => [
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'scriptid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'scripts',
				'ref_field' => 'scriptid',
			],
			'execute_on' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'authtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'username' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'password' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'publickey' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'privatekey' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'command' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
		],
	],
	'opcommand_hst' => [
		'key' => 'opcommand_hstid',
		'fields' => [
			'opcommand_hstid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'hostid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
		],
	],
	'opcommand_grp' => [
		'key' => 'opcommand_grpid',
		'fields' => [
			'opcommand_grpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
		],
	],
	'opgroup' => [
		'key' => 'opgroupid',
		'fields' => [
			'opgroupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
		],
	],
	'optemplate' => [
		'key' => 'optemplateid',
		'fields' => [
			'optemplateid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'templateid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
		],
	],
	'opconditions' => [
		'key' => 'opconditionid',
		'fields' => [
			'opconditionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'conditiontype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'operator' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'conditions' => [
		'key' => 'conditionid',
		'fields' => [
			'conditionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'actionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			],
			'conditiontype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'operator' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'config' => [
		'key' => 'configid',
		'fields' => [
			'configid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'refresh_unsupported' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'work_period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '1-5,00:00-24:00',
			],
			'alert_usrgrpid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'event_ack_enable' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'event_expire' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '7',
			],
			'event_show_max' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '100',
			],
			'default_theme' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => 'blue-theme',
			],
			'authentication_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ldap_host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ldap_port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => 389,
			],
			'ldap_base_dn' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ldap_bind_dn' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ldap_bind_password' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'ldap_search_attribute' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'dropdown_first_entry' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'dropdown_first_remember' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'discovery_groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
			'max_in_table' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '50',
			],
			'search_limit' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1000',
			],
			'severity_color_0' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '97AAB3',
			],
			'severity_color_1' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '7499FF',
			],
			'severity_color_2' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FFC859',
			],
			'severity_color_3' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'FFA059',
			],
			'severity_color_4' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'E97659',
			],
			'severity_color_5' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'E45959',
			],
			'severity_name_0' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Not classified',
			],
			'severity_name_1' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Information',
			],
			'severity_name_2' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Warning',
			],
			'severity_name_3' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Average',
			],
			'severity_name_4' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'High',
			],
			'severity_name_5' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => 'Disaster',
			],
			'ok_period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1800',
			],
			'blink_period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1800',
			],
			'problem_unack_color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'DC0000',
			],
			'problem_ack_color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => 'DC0000',
			],
			'ok_unack_color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '00AA00',
			],
			'ok_ack_color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '00AA00',
			],
			'problem_unack_style' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'problem_ack_style' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'ok_unack_style' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'ok_ack_style' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'snmptrap_logging' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'server_check_interval' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '10',
			],
			'hk_events_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'hk_events_trigger' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_events_internal' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_events_discovery' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_events_autoreg' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_services_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'hk_services' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_audit_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'hk_audit' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_sessions_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'hk_sessions' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'hk_history_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'hk_history_global' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'hk_history' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '90',
			],
			'hk_trends_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'hk_trends_global' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'hk_trends' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '365',
			],
			'default_inventory_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '-1',
			],
		],
	],
	'triggers' => [
		'key' => 'triggerid',
		'fields' => [
			'triggerid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'expression' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'description' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'url' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'priority' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastchange' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'comments' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'state' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'trigger_depends' => [
		'key' => 'triggerdepid',
		'fields' => [
			'triggerdepid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'triggerid_down' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'triggerid_up' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
		],
	],
	'functions' => [
		'key' => 'functionid',
		'fields' => [
			'functionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'triggerid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'function' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 12,
				'default' => '',
			],
			'parameter' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '0',
			],
		],
	],
	'graphs' => [
		'key' => 'graphid',
		'fields' => [
			'graphid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'width' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '900',
			],
			'height' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			],
			'yaxismin' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			],
			'yaxismax' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '100',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			],
			'show_work_period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'show_triggers' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'graphtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'show_legend' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'show_3d' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'percent_left' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			],
			'percent_right' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0',
			],
			'ymin_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ymax_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ymin_itemid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'ymax_itemid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'graphs_items' => [
		'key' => 'gitemid',
		'fields' => [
			'gitemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'graphid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'drawtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'sortorder' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '009600',
			],
			'yaxisside' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'calc_fnc' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'graph_theme' => [
		'key' => 'graphthemeid',
		'fields' => [
			'graphthemeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'theme' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'backgroundcolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'graphcolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'gridcolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'maingridcolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'gridbordercolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'textcolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'highlightcolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'leftpercentilecolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'rightpercentilecolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
			'nonworktimecolor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '',
			],
		],
	],
	'globalmacro' => [
		'key' => 'globalmacroid',
		'fields' => [
			'globalmacroid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'macro' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'hostmacro' => [
		'key' => 'hostmacroid',
		'fields' => [
			'hostmacroid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'macro' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'hosts_groups' => [
		'key' => 'hostgroupid',
		'fields' => [
			'hostgroupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
		],
	],
	'hosts_templates' => [
		'key' => 'hosttemplateid',
		'fields' => [
			'hosttemplateid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'templateid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
		],
	],
	'items_applications' => [
		'key' => 'itemappid',
		'fields' => [
			'itemappid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'applicationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
		],
	],
	'mappings' => [
		'key' => 'mappingid',
		'fields' => [
			'mappingid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'valuemapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'valuemaps',
				'ref_field' => 'valuemapid',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'newvalue' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
		],
	],
	'media' => [
		'key' => 'mediaid',
		'fields' => [
			'mediaid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'mediatypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'media_type',
				'ref_field' => 'mediatypeid',
			],
			'sendto' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			],
			'active' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'severity' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '63',
			],
			'period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '1-7,00:00-24:00',
			],
		],
	],
	'rights' => [
		'key' => 'rightid',
		'fields' => [
			'rightid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
		],
	],
	'services' => [
		'key' => 'serviceid',
		'fields' => [
			'serviceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'algorithm' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'triggerid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'showsla' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'goodsla' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '99.9',
			],
			'sortorder' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'services_links' => [
		'key' => 'linkid',
		'fields' => [
			'linkid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'serviceupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			],
			'servicedownid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			],
			'soft' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'services_times' => [
		'key' => 'timeid',
		'fields' => [
			'timeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'serviceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ts_from' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ts_to' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'note' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'icon_map' => [
		'key' => 'iconmapid',
		'fields' => [
			'iconmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'default_iconid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
		],
	],
	'icon_mapping' => [
		'key' => 'iconmappingid',
		'fields' => [
			'iconmappingid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'iconmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'icon_map',
				'ref_field' => 'iconmapid',
			],
			'iconid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
			'inventory_link' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'expression' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'sortorder' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'sysmaps' => [
		'key' => 'sysmapid',
		'fields' => [
			'sysmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'width' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '600',
			],
			'height' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '400',
			],
			'backgroundid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
			'label_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'label_location' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'highlight' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'expandproblem' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'markelements' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'show_unack' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'grid_size' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '50',
			],
			'grid_show' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'grid_align' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'label_format' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'label_type_host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'label_type_hostgroup' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'label_type_trigger' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'label_type_map' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'label_type_image' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
			'label_string_host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'label_string_hostgroup' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'label_string_trigger' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'label_string_map' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'label_string_image' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'iconmapid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'icon_map',
				'ref_field' => 'iconmapid',
			],
			'expand_macros' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'severity_min' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'private' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
		],
	],
	'sysmaps_elements' => [
		'key' => 'selementid',
		'fields' => [
			'selementid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'sysmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			],
			'elementid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			],
			'elementtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'iconid_off' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
			'iconid_on' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
			'label' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
			'label_location' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '-1',
			],
			'x' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'y' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'iconid_disabled' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
			'iconid_maintenance' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'images',
				'ref_field' => 'imageid',
			],
			'elementsubtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'areatype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'width' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			],
			'height' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '200',
			],
			'viewtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'use_iconmap' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'application' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'sysmaps_links' => [
		'key' => 'linkid',
		'fields' => [
			'linkid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'sysmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			],
			'selementid1' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_elements',
				'ref_field' => 'selementid',
			],
			'selementid2' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_elements',
				'ref_field' => 'selementid',
			],
			'drawtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			],
			'label' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 2048,
				'default' => '',
			],
		],
	],
	'sysmaps_link_triggers' => [
		'key' => 'linktriggerid',
		'fields' => [
			'linktriggerid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'linkid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_links',
				'ref_field' => 'linkid',
			],
			'triggerid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'drawtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'color' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 6,
				'default' => '000000',
			],
		],
	],
	'sysmap_element_url' => [
		'key' => 'sysmapelementurlid',
		'fields' => [
			'sysmapelementurlid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'selementid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps_elements',
				'ref_field' => 'selementid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			],
			'url' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'sysmap_url' => [
		'key' => 'sysmapurlid',
		'fields' => [
			'sysmapurlid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'sysmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
			],
			'url' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'elementtype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'sysmap_user' => [
		'key' => 'sysmapuserid',
		'fields' => [
			'sysmapuserid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'sysmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
		],
	],
	'sysmap_usrgrp' => [
		'key' => 'sysmapusrgrpid',
		'fields' => [
			'sysmapusrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'sysmapid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'sysmaps',
				'ref_field' => 'sysmapid',
			],
			'usrgrpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'usrgrp',
				'ref_field' => 'usrgrpid',
			],
			'permission' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '2',
			],
		],
	],
	'maintenances_hosts' => [
		'key' => 'maintenance_hostid',
		'fields' => [
			'maintenance_hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'maintenanceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			],
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
		],
	],
	'maintenances_groups' => [
		'key' => 'maintenance_groupid',
		'fields' => [
			'maintenance_groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'maintenanceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			],
			'groupid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'groups',
				'ref_field' => 'groupid',
			],
		],
	],
	'timeperiods' => [
		'key' => 'timeperiodid',
		'fields' => [
			'timeperiodid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'timeperiod_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'every' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '1',
			],
			'month' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'dayofweek' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'day' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'start_time' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'period' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'start_date' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'maintenances_windows' => [
		'key' => 'maintenance_timeperiodid',
		'fields' => [
			'maintenance_timeperiodid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'maintenanceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'maintenances',
				'ref_field' => 'maintenanceid',
			],
			'timeperiodid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'timeperiods',
				'ref_field' => 'timeperiodid',
			],
		],
	],
	'regexps' => [
		'key' => 'regexpid',
		'fields' => [
			'regexpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'test_string' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
		],
	],
	'expressions' => [
		'key' => 'expressionid',
		'fields' => [
			'expressionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'regexpid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'regexps',
				'ref_field' => 'regexpid',
			],
			'expression' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'expression_type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'exp_delimiter' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 1,
				'default' => '',
			],
			'case_sensitive' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'ids' => [
		'key' => 'table_name,field_name',
		'fields' => [
			'table_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'field_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'nextid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
		],
	],
	'alerts' => [
		'key' => 'alertid',
		'fields' => [
			'alertid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'actionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			],
			'eventid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			],
			'userid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'mediatypeid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'media_type',
				'ref_field' => 'mediatypeid',
			],
			'sendto' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 100,
				'default' => '',
			],
			'subject' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'message' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'retries' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'error' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'esc_step' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'alerttype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'history' => [
		'key' => '',
		'fields' => [
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'history_uint' => [
		'key' => '',
		'fields' => [
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'history_str' => [
		'key' => '',
		'fields' => [
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'history_log' => [
		'key' => 'id',
		'fields' => [
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'timestamp' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'source' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'severity' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'logeventid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'history_text' => [
		'key' => 'id',
		'fields' => [
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'proxy_history' => [
		'key' => 'id',
		'fields' => [
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'timestamp' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'source' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'severity' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'logeventid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'state' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastlogsize' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			],
			'mtime' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'flags' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'proxy_dhistory' => [
		'key' => 'id',
		'fields' => [
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'druleid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'drules',
				'ref_field' => 'druleid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'key_' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'dcheckid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'dchecks',
				'ref_field' => 'dcheckid',
			],
			'dns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
		],
	],
	'events' => [
		'key' => 'eventid',
		'fields' => [
			'eventid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'source' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'object' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'objectid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'acknowledged' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'trends' => [
		'key' => 'itemid,clock',
		'fields' => [
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'num' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value_min' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			],
			'value_avg' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			],
			'value_max' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_FLOAT,
				'length' => 16,
				'default' => '0.0000',
			],
		],
	],
	'trends_uint' => [
		'key' => 'itemid,clock',
		'fields' => [
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'num' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value_min' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			],
			'value_avg' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			],
			'value_max' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
				'default' => '0',
			],
		],
	],
	'acknowledges' => [
		'key' => 'acknowledgeid',
		'fields' => [
			'acknowledgeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'eventid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'message' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'auditlog' => [
		'key' => 'auditid',
		'fields' => [
			'auditid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'action' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'resourcetype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'details' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '0',
			],
			'ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'resourceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			],
			'resourcename' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'auditlog_details' => [
		'key' => 'auditdetailid',
		'fields' => [
			'auditdetailid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'auditid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'auditlog',
				'ref_field' => 'auditid',
			],
			'table_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'field_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'oldvalue' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'newvalue' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
		],
	],
	'service_alarms' => [
		'key' => 'servicealarmid',
		'fields' => [
			'servicealarmid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'serviceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'services',
				'ref_field' => 'serviceid',
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'autoreg_host' => [
		'key' => 'autoreg_hostid',
		'fields' => [
			'autoreg_hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'proxy_hostid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'listen_ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'listen_port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'listen_dns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'host_metadata' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'proxy_autoreg_host' => [
		'key' => 'id',
		'fields' => [
			'id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_UINT,
				'length' => 20,
			],
			'clock' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'listen_ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'listen_port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'listen_dns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'host_metadata' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'dhosts' => [
		'key' => 'dhostid',
		'fields' => [
			'dhostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'druleid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'drules',
				'ref_field' => 'druleid',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastup' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastdown' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'dservices' => [
		'key' => 'dserviceid',
		'fields' => [
			'dserviceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'dhostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'dhosts',
				'ref_field' => 'dhostid',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'key_' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'port' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastup' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'lastdown' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'dcheckid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'dchecks',
				'ref_field' => 'dcheckid',
			],
			'ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'dns' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
		],
	],
	'escalations' => [
		'key' => 'escalationid',
		'fields' => [
			'escalationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'actionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'actions',
				'ref_field' => 'actionid',
			],
			'triggerid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'eventid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			],
			'r_eventid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'events',
				'ref_field' => 'eventid',
			],
			'nextcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'esc_step' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'itemid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
		],
	],
	'globalvars' => [
		'key' => 'globalvarid',
		'fields' => [
			'globalvarid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'snmp_lastsize' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'graph_discovery' => [
		'key' => 'graphid',
		'fields' => [
			'graphid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			],
			'parent_graphid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'graphs',
				'ref_field' => 'graphid',
			],
		],
	],
	'host_inventory' => [
		'key' => 'hostid',
		'fields' => [
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'inventory_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'type_full' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'alias' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'os' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'os_full' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'os_short' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'serialno_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'serialno_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'tag' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'asset_tag' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'macaddress_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'macaddress_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'hardware' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'hardware_full' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'software' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'software_full' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'software_app_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'software_app_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'software_app_c' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'software_app_d' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'software_app_e' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'contact' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'location' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'location_lat' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			],
			'location_lon' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 16,
				'default' => '',
			],
			'notes' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'chassis' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'model' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'hw_arch' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			],
			'vendor' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'contract_number' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'installer_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'deployment_status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'url_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'url_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'url_c' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'host_networks' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'host_netmask' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'host_router' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'oob_ip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'oob_netmask' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'oob_router' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 39,
				'default' => '',
			],
			'date_hw_purchase' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'date_hw_install' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'date_hw_expiry' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'date_hw_decomm' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'site_address_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'site_address_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'site_address_c' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'site_city' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'site_state' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'site_country' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'site_zip' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'site_rack' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'site_notes' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'poc_1_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'poc_1_email' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'poc_1_phone_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_1_phone_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_1_cell' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_1_screen' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_1_notes' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
			'poc_2_name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'poc_2_email' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 128,
				'default' => '',
			],
			'poc_2_phone_a' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_2_phone_b' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_2_cell' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_2_screen' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'poc_2_notes' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_TEXT,
				'default' => '',
			],
		],
	],
	'housekeeper' => [
		'key' => 'housekeeperid',
		'fields' => [
			'housekeeperid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'tablename' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'field' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'value',
			],
		],
	],
	'images' => [
		'key' => 'imageid',
		'fields' => [
			'imageid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'imagetype' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '0',
			],
			'image' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_BLOB,
				'length' => 2048,
				'default' => '',
			],
		],
	],
	'item_discovery' => [
		'key' => 'itemdiscoveryid',
		'fields' => [
			'itemdiscoveryid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'parent_itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'key_' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'lastcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ts_delete' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'host_discovery' => [
		'key' => 'hostid',
		'fields' => [
			'hostid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'parent_hostid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'hosts',
				'ref_field' => 'hostid',
			],
			'parent_itemid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'host' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'lastcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ts_delete' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'interface_discovery' => [
		'key' => 'interfaceid',
		'fields' => [
			'interfaceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'interface',
				'ref_field' => 'interfaceid',
			],
			'parent_interfaceid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'interface',
				'ref_field' => 'interfaceid',
			],
		],
	],
	'profiles' => [
		'key' => 'profileid',
		'fields' => [
			'profileid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'idx' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 96,
				'default' => '',
			],
			'idx2' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			],
			'value_id' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'default' => '0',
			],
			'value_int' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'value_str' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'source' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 96,
				'default' => '',
			],
			'type' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'sessions' => [
		'key' => 'sessionid',
		'fields' => [
			'sessionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 32,
				'default' => '',
			],
			'userid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'users',
				'ref_field' => 'userid',
			],
			'lastaccess' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'status' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'trigger_discovery' => [
		'key' => 'triggerid',
		'fields' => [
			'triggerid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
			'parent_triggerid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'triggers',
				'ref_field' => 'triggerid',
			],
		],
	],
	'application_template' => [
		'key' => 'application_templateid',
		'fields' => [
			'application_templateid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'applicationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			],
			'templateid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			],
		],
	],
	'item_condition' => [
		'key' => 'item_conditionid',
		'fields' => [
			'item_conditionid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'operator' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '8',
			],
			'macro' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 64,
				'default' => '',
			],
			'value' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'application_prototype' => [
		'key' => 'application_prototypeid',
		'fields' => [
			'application_prototypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
			'templateid' => [
				'null' => true,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'application_prototype',
				'ref_field' => 'application_prototypeid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
		],
	],
	'item_application_prototype' => [
		'key' => 'item_application_prototypeid',
		'fields' => [
			'item_application_prototypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'application_prototypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'application_prototype',
				'ref_field' => 'application_prototypeid',
			],
			'itemid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'items',
				'ref_field' => 'itemid',
			],
		],
	],
	'application_discovery' => [
		'key' => 'application_discoveryid',
		'fields' => [
			'application_discoveryid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
			],
			'applicationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'applications',
				'ref_field' => 'applicationid',
			],
			'application_prototypeid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'application_prototype',
				'ref_field' => 'application_prototypeid',
			],
			'name' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_CHAR,
				'length' => 255,
				'default' => '',
			],
			'lastcheck' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'ts_delete' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'opinventory' => [
		'key' => 'operationid',
		'fields' => [
			'operationid' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_ID,
				'length' => 20,
				'ref_table' => 'operations',
				'ref_field' => 'operationid',
			],
			'inventory_mode' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
	'dbversion' => [
		'key' => '',
		'fields' => [
			'mandatory' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
			'optional' => [
				'null' => false,
				'type' => DB::FIELD_TYPE_INT,
				'length' => 10,
				'default' => '0',
			],
		],
	],
];
