#
#   MailScanner - SMTP E-Mail Virus Scanner
#   Copyright (C) 2002  Julian Field
#
#   $Id: GenericSpamScanner.pm 3119 2005-07-12 11:27:14Z jkf $
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#   The author, Julian Field, can be contacted by email at
#      Jules@JulianField.net
#   or by paper mail at
#      Julian Field
#      Dept of Electronics & Computer Science
#      University of Southampton
#      Southampton
#      SO17 1BJ
#      United Kingdom
#

package MailScanner::CustomConfig;

use IPC::Open2;
use FileHandle;

sub GenericSpamScanner {
  my($Message, $message) = @_;
  my($ip, $from, $to) = ($Message->{clientip},
	$Message->{from},
	$Message->{to});

  #print STDERR "Generic Spam Scanner\n";
  #print STDERR "====================\n";
  #print STDERR "\n";
  #print STDERR "IP = \"$ip\"\n";
  #print STDERR "From = \"$from\"\n";
  #print STDERR "To = \"" . join(", ", @$to) . "\"\n";
  #print STDERR "Message = \"" . join(", ", @$message) . "\"\n";

 # To call a remote program you might want to do this:
 my($fhread, $fhwrite, $pid, @result, $report, $users);
 foreach my $address (@$to) {
  $users .= "$address ";
 }
 my $cmd = sprintf "/usr/local/bin/dspamc --client --stdout --deliver=innocent,spam --mode=tum --user %s",$users;
 #print STDERR "cmd: $cmd\n";
 die "Can't fork: $!" unless defined($pid = open2($fhread, $fhwrite, $cmd));
 $fhwrite->print(@$message);
 $fhwrite->flush();
 $fhwrite->close();
 my $state = 0;
 my ($score,$report);
 my @headers = ();
 foreach my $line (<$fhread>) {
	next if ($state > 0);
 	chomp $line;
	if ($line =~ m/^$/) {
		$state++;
		next;
	}
	if ($line =~ m/^X-DSPAM/) {
		$line =~ m/^([^:]*): (.*)$/;
		my ($header,$val)=($1,$2);
		next if ($header eq "X-DSPAM-Processed");
		push @headers,"$header:$val";
		#printf STDERR "Storing: $header \/ $val, now %s headers\n", $#headers;
		$global::MS->{mta}->AddHeader($Message,
				"${header}:", $val);
		#@$message = ($line,@$message);
		if ($header eq "X-DSPAM-Result") {
			$result=$val;
		}
		if ($header eq "X-DSPAM-Confidence") {
			# Confidence is a percentage, so
			# make it 'spam' for 1.0 - 7.0, and
			# make it 'ham' for 0.0 - 0.999999
			if ($result eq "Spam") {
				$score= 6.0*$val+1.0;
			} else {
				$score = 1.0-$val;
			}
			#print STDERR "Score! $score\n";
		}
		if ($header eq "X-DSPAM-Improbability") {
			$report=$val;
			#print STDERR "Report! $report\n";
		}
	}
	next;
 }
	
 #print STDERR "Read \"$score\" from your program\n";
 $score = $score+0.0;

 #print STDERR "Read \"$report\" from your program\n";
 #printf STDERR "Read %d headers from your program\n",$#headers;

 return ($score, $report, @headers);

 # return (0.0, 'No report');
}

1;
