/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;

public class IfHandler
extends BlockParentHandler {
    public IfHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, "if", aAst, aParent);
    }

    public int suggestedChildLevel(ExpressionHandler aChild) {
        if (aChild instanceof ElseHandler) {
            return this.getLevel();
        }
        return super.suggestedChildLevel(aChild);
    }

    public int getLevelImpl() {
        if (this.isElseIf()) {
            return this.getParent().getLevel();
        }
        return super.getLevelImpl();
    }

    private boolean isElseIf() {
        DetailAST parent = this.getMainAst().getParent();
        return parent.getType() == 92 && parent.getLineNo() == this.getMainAst().getLineNo();
    }

    protected void checkToplevelToken() {
        if (this.isElseIf()) {
            return;
        }
        super.checkToplevelToken();
    }

    private void checkCondExpr() {
        DetailAST condAst = (DetailAST)this.getMainAst().findFirstToken(76).getNextSibling();
        int expectedLevel = this.getLevel() + this.getIndentCheck().getBasicOffset();
        this.checkExpressionSubtree(condAst, expectedLevel, false, false);
    }

    public void checkIndentation() {
        super.checkIndentation();
        this.checkCondExpr();
    }
}

