/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributes
implements AbstractFileSystem.Attr,
AbstractFileSystem.List {
    static final long serialVersionUID = -5801291358293736478L;
    @Deprecated
    public static final String ATTR_NAME = "filesystem";
    @Deprecated
    public static final String ATTR_EXT = "attributes";
    @Deprecated
    public static final String ATTR_NAME_EXT = "filesystem.attributes";
    private static final String ATTR_NAME_EXT_XML = System.getProperty("org.openide.filesystems.DefaultAttributes.ATTR_NAME_EXT_XML", ".nbattrs");
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private static final String PUBLIC_ID = "-//NetBeans//DTD DefaultAttributes 1.0//EN";
    private static final String DTD_PATH = "org/openide/filesystems/attributes.dtd";
    private AbstractFileSystem.Info info;
    private AbstractFileSystem.Change change;
    private AbstractFileSystem.List list;
    private String fileName;
    private transient Map cache;

    public DefaultAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
        this.info = info;
        this.change = change;
        this.list = list;
        this.fileName = ATTR_NAME_EXT_XML;
    }

    protected DefaultAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list, String string) {
        this(info, change, list);
        this.fileName = string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = AbstractFileSystem.readImpl("change", getField);
        Object object2 = AbstractFileSystem.readImpl("info", getField);
        Object object3 = AbstractFileSystem.readImpl("list", getField);
        this.change = (AbstractFileSystem.Change)object;
        this.info = (AbstractFileSystem.Info)object2;
        this.list = (AbstractFileSystem.List)object3;
    }

    @Override
    public String[] children(String string) {
        String[] stringArray = this.list.children(string);
        int n = 0;
        if (stringArray == null) {
            return null;
        }
        int n2 = stringArray.length;
        if (n2 == 1) {
            if (Utilities.getOperatingSystem() == 16384 && stringArray[0] != null && string != null && stringArray[0].equalsIgnoreCase("_nbattrs.")) {
                try {
                    this.deleteFile(string + "/" + stringArray[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stringArray[0] = this.getFileName();
            }
            if (this.getFileName().equals(stringArray[0]) || ATTR_NAME_EXT_XML.equals(stringArray[0]) || ATTR_NAME_EXT.equals(stringArray[0])) {
                try {
                    this.change.delete(string + "/" + stringArray[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new String[0];
            }
        }
        for (int i = 0; i < n2; ++i) {
            Object object;
            if (Utilities.getOperatingSystem() == 16384 && stringArray[i] != null && string != null && stringArray[i].equalsIgnoreCase("_nbattrs.")) {
                try {
                    object = new File(string + "/" + ".nbattrs");
                    if (!((File)object).exists()) {
                        this.cache = null;
                        this.copyVMSAttrFile(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stringArray[i] = this.getFileName();
            }
            object = this.getFileName() + "~";
            if (!this.getFileName().equals(stringArray[i]) && !ATTR_NAME_EXT.equals(stringArray[i]) && !ATTR_NAME_EXT_XML.equals(stringArray[i]) && !((String)object).equals(stringArray[i])) continue;
            stringArray[i] = null;
            if (++n >= 2) break;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVMSAttrFile(String string) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            this.change.createData(string + "/" + this.getFileName());
            inputStream = this.info.inputStream(string + "/" + "_nbattrs.");
            outputStream = this.info.outputStream(string + "/" + this.getFileName());
            byte[] byArray = new byte[256];
            while ((n = inputStream.read(byArray, 0, 256)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            inputStream = null;
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readAttribute(String string, String string2) {
        Table table;
        String[] stringArray = new String[2];
        DefaultAttributes.split(string, stringArray);
        if (string2.equals(READONLY_ATTRIBUTES)) {
            return this.info.readOnly(stringArray[0]) ? Boolean.TRUE : Boolean.FALSE;
        }
        DefaultAttributes defaultAttributes = this;
        synchronized (defaultAttributes) {
            table = this.loadTable(stringArray[0]);
        }
        return table.getAttr(stringArray[1], string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAttribute(String string, String string2, Object object) throws IOException {
        String[] stringArray = new String[2];
        DefaultAttributes.split(string, stringArray);
        while (true) {
            int n;
            Table table;
            Object object2 = this;
            synchronized (object2) {
                table = this.loadTable(stringArray[0]);
                n = table.version;
            }
            object2 = table.getAttr(stringArray[1], string2);
            if (object2 == object) {
                return;
            }
            DefaultAttributes defaultAttributes = this;
            synchronized (defaultAttributes) {
                Table table2 = this.loadTable(stringArray[0]);
                if (table == table2 && n == table2.version) {
                    if (object == null) {
                        table.setAttr(stringArray[1], string2, null);
                    } else {
                        int n2 = XMLMapAttr.Attr.distinguishObject(object);
                        if (n2 == XMLMapAttr.Attr.isValid("SERIALVALUE")) {
                            table.setAttr(stringArray[1], string2, object);
                        } else {
                            table.setAttr(stringArray[1], string2, XMLMapAttr.createAttribute(n2, object.toString()));
                        }
                    }
                    this.saveTable(stringArray[0], table);
                    return;
                }
            }
        }
    }

    @Override
    public synchronized Enumeration<String> attributes(String string) {
        String[] stringArray = new String[2];
        DefaultAttributes.split(string, stringArray);
        Table table = this.loadTable(stringArray[0]);
        return table.attrs(stringArray[1]);
    }

    @Override
    public synchronized void renameAttributes(String string, String string2) {
        try {
            String[] stringArray = new String[2];
            DefaultAttributes.split(string, stringArray);
            Table table = this.loadTable(stringArray[0]);
            Map map = (Map)table.remove(stringArray[1]);
            if (map == null) {
                return;
            }
            DefaultAttributes.split(string2, stringArray);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!FileUtil.transientAttributes.contains(entry.getKey())) continue;
                iterator.remove();
            }
            table.put(stringArray[1], map);
            this.saveTable(stringArray[0], table);
        }
        catch (IOException iOException) {
            ExternalUtil.exception(iOException);
        }
    }

    @Override
    public synchronized void deleteAttributes(String string) {
        try {
            String[] stringArray = new String[2];
            DefaultAttributes.split(string, stringArray);
            Table table = this.loadTable(stringArray[0]);
            if (table.remove(stringArray[1]) != null) {
                this.saveTable(stringArray[0], table);
            }
        }
        catch (IOException iOException) {
            ExternalUtil.exception(iOException);
        }
    }

    private Map getCache() {
        if (this.cache == null) {
            this.cache = new HashMap(31);
        }
        return this.cache;
    }

    private static void split(String string, String[] stringArray) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            stringArray[0] = "";
            stringArray[1] = string;
            return;
        }
        stringArray[0] = string.substring(0, n);
        stringArray[1] = ++n == string.length() ? "" : string.substring(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTable(String string, Table table) throws IOException {
        String string2 = (string.length() == 0 ? "" : string + '/') + this.getFileName();
        String string3 = string2 + "~";
        if (this.info.folder(string2)) {
            if (table.size() == 0) {
                return;
            }
            this.change.createData(string2);
        } else if (table.size() == 0) {
            this.deleteFile(string2);
            return;
        }
        PrintWriter printWriter = null;
        IOException iOException = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.info.outputStream(string3)), "UTF8"));
            table.writeToXML(printWriter);
            printWriter.flush();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (iOException != null) {
                this.deleteFile(string3);
                throw iOException;
            }
            try {
                this.deleteFile(string2);
            }
            catch (IOException iOException3) {}
            this.change.rename(string3, string2);
        }
    }

    private Table loadTable(String string) {
        Table table;
        Reference reference = (Reference)this.getCache().get(string);
        if (reference != null && (table = (Table)reference.get()) != null) {
            return table;
        }
        table = this.load(string);
        table.attach(string, this);
        this.getCache().put(string, new SoftReference<Table>(table));
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Table load(String string) {
        String[] stringArray = new String[]{(string.length() == 0 ? "" : string + '/') + this.getFileName(), (string.length() == 0 ? "" : string + '/') + ATTR_NAME_EXT};
        int i = 0;
        while (i < stringArray.length) {
            if (this.info.size(stringArray[i]) > 0L) {
                try {
                    InputStream inputStream = this.info.inputStream(stringArray[i]);
                    try {
                        Table table = DefaultAttributes.loadTable(inputStream, stringArray[i]);
                        return table;
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ExternalUtil.exception(fileNotFoundException);
                }
            }
            ++i;
        }
        return new Table();
    }

    static Table loadTable(InputStream inputStream, String string) {
        block5: {
            Table table = new Table();
            PushbackInputStream pushbackInputStream = null;
            boolean bl = false;
            try {
                if (string.endsWith(ATTR_NAME_EXT)) {
                    pushbackInputStream = new PushbackInputStream(inputStream, 4);
                    bl = DefaultAttributes.isSerialized(pushbackInputStream);
                }
                if (bl && pushbackInputStream != null) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(pushbackInputStream);
                    NbObjectInputStream nbObjectInputStream = new NbObjectInputStream((InputStream)bufferedInputStream);
                    Object object = nbObjectInputStream.readObject();
                    if (object instanceof Table) {
                        return (Table)object;
                    }
                    break block5;
                }
                BufferedInputStream bufferedInputStream = pushbackInputStream != null ? new BufferedInputStream(pushbackInputStream) : new BufferedInputStream(inputStream);
                table.readFromXML(bufferedInputStream, false);
                return table;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(NbBundle.getMessage(DefaultAttributes.class, (String)"EXC_DefAttrReadErr") + ": " + string);
                ExternalUtil.copyAnnotation(iOException, exception);
                ExternalUtil.exception(iOException);
            }
        }
        return new Table();
    }

    private static final boolean isSerialized(PushbackInputStream pushbackInputStream) throws IOException {
        int[] nArray = new int[]{172, 237, 0, 5};
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        pushbackInputStream.read(byArray, 0, byArray.length);
        pushbackInputStream.unread(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = n = byArray[i] < 0 ? byArray[i] + 256 : byArray[i];
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }

    synchronized void removeTable(String string) {
        this.getCache().remove(string);
    }

    static boolean acceptName(String string) {
        return string.endsWith(ATTR_NAME_EXT) || string.endsWith(ATTR_NAME_EXT_XML);
    }

    private String getFileName() {
        if (this.fileName == null) {
            this.fileName = ATTR_NAME_EXT_XML;
        }
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(String string) throws IOException {
        OutputStream outputStream = null;
        this.info.lock(string);
        try {
            outputStream = this.info.outputStream(string);
            outputStream.close();
            outputStream = null;
            this.change.delete(string);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            this.info.unlock(string);
        }
    }

    static abstract class ElementHandler {
        private static final String[] EMPTY = new String[0];
        private int mandatAttrCount;

        ElementHandler() {
        }

        public void startElement(String string, Attributes attributes) throws SAXException {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            if (!this.checkAttributes(attributes, hashMap, hashMap2)) {
                throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, (String)"XML_InaccurateParam") + ": " + string);
            }
            this.internalStartElement(string, hashMap, hashMap2);
        }

        protected void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
        }

        protected void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        protected void endElement(String string) throws SAXException {
        }

        protected String[] getKeys() {
            return EMPTY;
        }

        protected String[] getMandatoryAttrs() {
            return this.getKeys();
        }

        protected String[] getAllowedAttrs() {
            return EMPTY;
        }

        private int isMyTag(String string) {
            return this.isInArray(string, this.getKeys());
        }

        private int isAllowedAttr(String string) {
            return this.isInArray(string, this.getAllowedAttrs());
        }

        private boolean isMandatOK() {
            return this.mandatAttrCount == this.getMandatoryAttrs().length;
        }

        private int isMandatoryAttr(String string) {
            int n = this.isInArray(string, this.getMandatoryAttrs());
            if (n != -1) {
                ++this.mandatAttrCount;
            }
            return n;
        }

        private int isInArray(String string, String[] stringArray) {
            if (stringArray == null || string == null) {
                return -1;
            }
            String string2 = string.trim();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                return i;
            }
            return -1;
        }

        private boolean checkAttributes(Attributes attributes, HashMap hashMap, HashMap hashMap2) {
            this.mandatAttrCount = 0;
            if (attributes == null) {
                return false;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string;
                if (this.isMandatoryAttr(attributes.getQName(i)) != -1) {
                    string = attributes.getQName(i).toUpperCase(Locale.ENGLISH);
                    hashMap.put(string, attributes.getValue(i));
                    continue;
                }
                if (this.isAllowedAttr(attributes.getQName(i)) == -1) continue;
                string = attributes.getQName(i).toUpperCase(Locale.ENGLISH);
                hashMap2.put(string, attributes.getValue(i));
            }
            return this.isMandatOK();
        }
    }

    static class InnerParser
    extends DefaultHandler {
        private ElementHandler[] elmKeyService;
        private String tagInProcess = "";
        private String publicId;
        private String publicURL;

        InnerParser(String string, String string2, ElementHandler[] elementHandlerArray) {
            this.elmKeyService = elementHandlerArray;
            this.publicId = string;
            this.publicURL = string2;
        }

        public void parseXML(String string, boolean bl) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
            XMLReader xMLReader = this.getParser(bl);
            xMLReader.parse(string);
        }

        public void parseXML(InputStream inputStream, boolean bl) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
            InputSource inputSource = new InputSource(inputStream);
            XMLReader xMLReader = this.getParser(bl);
            xMLReader.parse(inputSource);
        }

        private XMLReader getParser(boolean bl) throws SAXException, ParserConfigurationException, FactoryConfigurationError {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)bl);
            xMLReader.setEntityResolver(this);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            return xMLReader;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.tagInProcess = string3 = string3.trim();
            for (int i = 0; i < this.elmKeyService.length; ++i) {
                if (this.elmKeyService[i].isMyTag(string3) == -1) continue;
                this.elmKeyService[i].startElement(string3, attributes);
                return;
            }
            throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, (String)"XML_UnknownElement") + " " + string3);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            for (int i = 0; i < this.elmKeyService.length; ++i) {
                if (this.elmKeyService[i].isMyTag(string3.trim()) == -1) continue;
                this.elmKeyService[i].endElement(string3.trim());
                return;
            }
            throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, (String)"XML_UnknownElement") + " " + string3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            for (int i = 0; i < this.elmKeyService.length; ++i) {
                if (this.elmKeyService[i].isMyTag(this.tagInProcess) == -1) continue;
                this.elmKeyService[i].characters(cArray, n, n2);
                return;
            }
            throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, (String)"XML_UnknownElement") + " " + this.tagInProcess);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string != null && string.equals(this.publicId)) {
                return new InputSource(this.publicURL);
            }
            return new InputSource(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Table
    extends HashMap
    implements Externalizable {
        static final long serialVersionUID = 2353458763249746934L;
        private transient String name;
        private transient DefaultAttributes attrs;
        private transient int version = 0;

        public Table() {
            super(11);
        }

        public void attach(String string, DefaultAttributes defaultAttributes) {
            this.name = string;
            this.attrs = defaultAttributes;
        }

        protected void finalize() {
            this.attrs.removeTable(this.name);
        }

        public Object getAttr(String string, String string2) {
            XMLMapAttr xMLMapAttr = (XMLMapAttr)this.get(string);
            if (xMLMapAttr != null) {
                Object object = null;
                try {
                    object = xMLMapAttr.getAttribute(string2);
                }
                catch (Exception exception) {
                    ExternalUtil.annotate((Throwable)exception, "fileName = " + string);
                    ExternalUtil.exception(exception);
                }
                if (object == null) {
                    return null;
                }
                if (!(object instanceof NbMarshalledObject)) {
                    return object;
                }
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
                try {
                    return nbMarshalledObject == null ? null : nbMarshalledObject.get();
                }
                catch (IOException iOException) {
                    ExternalUtil.log("Cannot load attribute " + string2 + " from " + string);
                    ExternalUtil.exception(iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.log("Cannot load attribute " + string2 + " from " + string);
                    ExternalUtil.exception(classNotFoundException);
                }
            }
            return null;
        }

        final void setMarshalledAttr(String string, String string2, NbMarshalledObject nbMarshalledObject) {
            this.setAttr(string, string2, nbMarshalledObject);
        }

        final void setAttr(String string, String string2, Object object) {
            XMLMapAttr xMLMapAttr = (XMLMapAttr)this.get(string);
            if (xMLMapAttr == null) {
                xMLMapAttr = new XMLMapAttr();
                this.put(string, xMLMapAttr);
            }
            xMLMapAttr.put(string2, object, false);
            if (object == null && xMLMapAttr.size() == 1) {
                this.remove(string);
            }
            ++this.version;
        }

        public Enumeration<String> attrs(String string) {
            Map map = (Map)this.get(string);
            if (map == null) {
                return Enumerations.empty();
            }
            HashSet hashSet = new HashSet(map.keySet());
            return Collections.enumeration(hashSet);
        }

        private ElementHandler parseFirstLevel() {
            ElementHandler elementHandler = new ElementHandler(){
                private final String[] ELM_KEYS = new String[]{"ATTRIBUTES"};
                private final String[] MANDAT_ATTR_KEYS = new String[]{"VERSION"};

                public void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elementHandler;
        }

        private ElementHandler parseSecondLevel(final StringBuffer stringBuffer) {
            ElementHandler elementHandler = new ElementHandler(){
                private final String[] ELM_KEYS = new String[]{"FILEOBJECT"};
                private final String[] MANDAT_ATTR_KEYS = new String[]{"NAME"};

                public void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
                    stringBuffer.delete(0, stringBuffer.length());
                    String string2 = (String)hashMap.get("NAME");
                    if (string2 == null) {
                        string2 = (String)hashMap.get("name");
                    }
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    }
                }

                public void endElement(String string) throws SAXException {
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elementHandler;
        }

        private ElementHandler parseThirdLevel(final StringBuffer stringBuffer) {
            ElementHandler elementHandler = new ElementHandler(){
                private final String[] ELM_KEYS = new String[]{"ATTR"};
                private final String[] MANDAT_ATTR_KEYS = new String[]{"NAME"};

                public void internalStartElement(String string, HashMap hashMap, HashMap hashMap2) throws SAXException {
                    if (hashMap2.isEmpty()) {
                        return;
                    }
                    String string2 = (String)hashMap.get("NAME");
                    if (string2 == null) {
                        string2 = (String)hashMap.get("name");
                    }
                    if (string2 == null) {
                        return;
                    }
                    for (Map.Entry entry : hashMap2.entrySet()) {
                        if (XMLMapAttr.Attr.isValid((String)entry.getKey()) == -1) continue;
                        XMLMapAttr.Attr attr = XMLMapAttr.createAttributeAndDecode((String)entry.getKey(), (String)entry.getValue());
                        Table.this.setAttr(stringBuffer.toString(), string2, attr);
                    }
                }

                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }

                protected String[] getAllowedAttrs() {
                    return XMLMapAttr.Attr.getAttrTypes();
                }
            };
            return elementHandler;
        }

        public void writeToXML(PrintWriter printWriter) {
            Iterator iterator = new TreeSet(this.keySet()).iterator();
            XMLMapAttr.writeHeading(printWriter);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XMLMapAttr xMLMapAttr = (XMLMapAttr)this.get(string);
                if (xMLMapAttr == null || xMLMapAttr.isEmpty()) continue;
                xMLMapAttr.write(printWriter, string, "    ");
            }
            XMLMapAttr.writeEnding(printWriter);
        }

        public void readFromXML(InputStream inputStream, boolean bl) throws SAXException {
            StringBuffer stringBuffer = new StringBuffer();
            ElementHandler[] elementHandlerArray = new ElementHandler[]{this.parseFirstLevel(), this.parseSecondLevel(stringBuffer), this.parseThirdLevel(stringBuffer)};
            String string = this.getClass().getClassLoader().getResource(DefaultAttributes.DTD_PATH).toExternalForm();
            InnerParser innerParser = new InnerParser(DefaultAttributes.PUBLIC_ID, string, elementHandlerArray);
            try {
                innerParser.parseXML(inputStream, bl);
            }
            catch (Exception exception) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(DefaultAttributes.class, (String)"EXC_DefAttrReadErr")), exception);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(DefaultAttributes.class, (String)"EXC_DefAttrReadErr")), factoryConfigurationError);
            }
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            for (String string : this.keySet()) {
                Map map = (Map)this.get(string);
                if (map == null || map.isEmpty()) continue;
                objectOutput.writeObject(string);
                for (Map.Entry entry : map.entrySet()) {
                    String string2 = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (string2 == null || v == null) continue;
                    objectOutput.writeObject(string2);
                    objectOutput.writeObject(v);
                }
                objectOutput.writeObject(null);
            }
            objectOutput.writeObject(null);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            String string;
            while ((string = (String)objectInput.readObject()) != null) {
                String string2;
                while ((string2 = (String)objectInput.readObject()) != null) {
                    Object object = objectInput.readObject();
                    if (object instanceof MarshalledObject) {
                        object = ((MarshalledObject)object).get();
                        object = new NbMarshalledObject(object);
                    }
                    if (!(object instanceof NbMarshalledObject)) continue;
                    this.setAttr(string, string2, object);
                }
            }
        }
    }
}

