/*
 * Decompiled with CFR 0.152.
 */
package tr.imports.thoughts;

import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import tr.imports.thoughts.ImportThoughts;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.collect.CollectThoughtsAction;

public final class ImportThoughtsAction
extends CallableSystemAction {
    public ImportThoughtsAction() {
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ImportThoughtsAction.this.enableDisable();
            }
        });
        r.allInstances();
        this.enableDisable();
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void performAction() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        try {
            if (ImportThoughts.doImport(data)) {
                this.activateCollectThoughts();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void activateCollectThoughts() {
        CollectThoughtsAction collect = (CollectThoughtsAction)SystemAction.get(CollectThoughtsAction.class);
        collect.performAction();
    }

    public String getName() {
        return NbBundle.getMessage(ImportThoughtsAction.class, (String)"CTL_ImportThoughtsAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void updateEnablement(boolean b) {
        this.setEnabled(b);
    }
}

