/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.BeanProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ActionMessageInput;
import flex.messaging.io.amf.AmfIO;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.XMLUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;

public abstract class AbstractAmfInput
extends AmfIO
implements ActionMessageInput {
    public static final int INITIAL_ARRAY_CAPACITY = 1024;
    public static final int DEFAULT_MAX_STRING_BYTES = 0x1900000;
    public static final String STRING_MAX_STRING_BYTES = "max-string-bytes";
    protected BeanProxy beanProxy = new BeanProxy();
    protected DataInputStream in = null;
    protected int maxStringBytes = 0x1900000;

    public AbstractAmfInput(SerializationContext context) {
        super(context);
        String maxStringBytes = System.getProperty(STRING_MAX_STRING_BYTES);
        if (maxStringBytes != null) {
            try {
                this.maxStringBytes = Integer.parseInt(maxStringBytes);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    protected Object stringToDocument(String xml) {
        if (xml != null && xml.indexOf(60) == -1) {
            return xml;
        }
        ClassUtil.validateCreation(Document.class);
        return XMLUtil.stringToDocument(xml, !this.context.legacyXMLNamespaces);
    }

    protected void checkUTFLength(int utflen) {
        if (utflen > this.maxStringBytes) {
            SerializationException ex = new SerializationException();
            ex.setMessage(10314, new Object[]{utflen, this.maxStringBytes});
            throw ex;
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] bytes) throws IOException {
        return this.in.read(bytes);
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.in.read(bytes, offset, length);
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public void readFully(byte[] bytes) throws IOException {
        this.in.readFully(bytes);
    }

    public void readFully(byte[] bytes, int offset, int length) throws IOException {
        this.in.readFully(bytes, offset, length);
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

