/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextState;
import org.icepdf.core.util.Defs;

public class GraphicsState {
    private static final Logger logger = Logger.getLogger(GraphicsState.class.toString());
    private static boolean enabledOverpaint = Defs.sysPropertyBoolean("org.icepdf.core.overpaint", true);
    private AffineTransform CTM = new AffineTransform();
    private int lineCap = 0;
    private float lineWidth = 1.0f;
    private int lineJoin = 0;
    private float miterLimit = 10.0f;
    private float[] dashArray = null;
    private float dashPhase = 0.0f;
    private Color fillColor = Color.black;
    private Color strokeColor = Color.black;
    private float strokeAlpha = 1.0f;
    private float fillAlpha = 1.0f;
    private PColorSpace fillColorSpace = new DeviceGray(null, null);
    private PColorSpace strokeColorSpace = new DeviceGray(null, null);
    private TextState textState = new TextState();
    private GraphicsState parentGraphicState = null;
    private Shapes shapes;
    private Area clip;
    private int overprintMode;
    private boolean overprintStroking;
    private boolean overprintOther;

    public GraphicsState(Shapes shapes) {
        this.shapes = shapes;
    }

    public GraphicsState(GraphicsState graphicsState) {
        this.CTM = new AffineTransform(graphicsState.CTM);
        this.lineCap = graphicsState.lineCap;
        this.lineWidth = graphicsState.lineWidth;
        this.miterLimit = graphicsState.miterLimit;
        this.lineJoin = graphicsState.lineJoin;
        this.fillColor = new Color(graphicsState.fillColor.getRed(), graphicsState.fillColor.getGreen(), graphicsState.fillColor.getBlue());
        this.strokeColor = new Color(graphicsState.strokeColor.getRed(), graphicsState.strokeColor.getGreen(), graphicsState.strokeColor.getBlue());
        this.shapes = graphicsState.shapes;
        if (graphicsState.clip != null) {
            this.clip = (Area)graphicsState.clip.clone();
        }
        this.fillColorSpace = graphicsState.fillColorSpace;
        this.strokeColorSpace = graphicsState.strokeColorSpace;
        this.textState = new TextState(graphicsState.textState);
        this.dashPhase = graphicsState.getDashPhase();
        this.dashArray = graphicsState.getDashArray();
        this.overprintMode = graphicsState.getOverprintMode();
        this.overprintOther = graphicsState.isOverprintOther();
        this.overprintStroking = graphicsState.isOverprintStroking();
    }

    public void setShapes(Shapes shapes) {
        this.shapes = shapes;
    }

    public void translate(double d, double d2) {
        this.CTM.translate(d, d2);
        this.shapes.add(new AffineTransform(this.CTM));
    }

    public void scale(double d, double d2) {
        this.CTM.scale(d, d2);
        this.shapes.add(new AffineTransform(this.CTM));
    }

    public void set(AffineTransform affineTransform) {
        this.CTM = new AffineTransform(affineTransform);
        this.shapes.add(new AffineTransform(this.CTM));
    }

    public GraphicsState save() {
        GraphicsState graphicsState = new GraphicsState(this);
        graphicsState.parentGraphicState = this;
        return graphicsState;
    }

    public void concatenate(ExtGState extGState) {
        if (extGState.getLineWidth() != null) {
            this.setLineWidth(extGState.getLineWidth().floatValue());
        }
        if (extGState.getLineCapStyle() != null) {
            this.setLineCap(extGState.getLineCapStyle().intValue());
        }
        if (extGState.getLineJoinStyle() != null) {
            this.setLineJoin(extGState.getLineJoinStyle().intValue());
        }
        if (extGState.getMiterLimit() != null) {
            this.setMiterLimit(extGState.getMiterLimit().floatValue());
        }
        if (extGState.getLineDashPattern() != null) {
            Vector vector = extGState.getLineDashPattern();
            try {
                this.setDashArray((float[])vector.elementAt(0));
                this.setDashPhase(((Number)vector.elementAt(1)).floatValue());
            }
            catch (ClassCastException classCastException) {
                logger.log(Level.FINE, "Dash cast error: ", classCastException);
            }
        }
        if (extGState.getNonStrokingAlphConstant() != null) {
            this.setFillAlpha(extGState.getNonStrokingAlphConstant().floatValue());
        }
        if (extGState.getStrokingAlphConstant() != null) {
            this.setStrokeAlpha(extGState.getStrokingAlphConstant().floatValue());
        }
        if (extGState.getOverprintMode() != null) {
            this.setOverprintMode(extGState.getOverprintMode().intValue());
        }
        this.processOverPaint(extGState.getOverprint(), extGState.getOverprintFill());
    }

    private void processOverPaint(Boolean bl, Boolean bl2) {
        if (enabledOverpaint && bl != null && bl2 == null && this.overprintMode == 1) {
            this.overprintOther = this.overprintStroking = bl.booleanValue();
        } else if (bl != null) {
            // empty if block
        }
    }

    public GraphicsState restore() {
        if (this.parentGraphicState != null) {
            this.parentGraphicState.set(this.parentGraphicState.CTM);
            if (this.parentGraphicState.clip != null) {
                this.parentGraphicState.shapes.add(this.parentGraphicState.clip.clone());
                this.parentGraphicState.shapes.addClipCommand();
            } else {
                this.parentGraphicState.shapes.addNoClipCommand();
            }
            this.parentGraphicState.shapes.add(new BasicStroke(this.parentGraphicState.lineWidth, this.parentGraphicState.lineCap, this.parentGraphicState.lineJoin, this.parentGraphicState.miterLimit, this.parentGraphicState.dashArray, this.parentGraphicState.dashPhase));
            this.parentGraphicState.shapes.add(this.parentGraphicState.getFillColor());
        }
        return this.parentGraphicState;
    }

    public void updateClipCM(AffineTransform affineTransform) {
        if (this.clip != null) {
            AffineTransform affineTransform2 = new AffineTransform();
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Eror generating clip inverse.", exception);
            }
            this.clip.transform(affineTransform2);
        }
    }

    public void setClip(Shape shape) {
        if (shape != null) {
            Area area = new Area(shape);
            if (this.clip != null) {
                area.intersect(this.clip);
            }
            this.clip = (Area)area.clone();
            this.shapes.add(area.clone());
            this.shapes.addClipCommand();
        } else {
            this.clip = null;
            this.shapes.addNoClipCommand();
        }
    }

    public Area getClip() {
        return this.clip;
    }

    public AffineTransform getCTM() {
        return this.CTM;
    }

    public void setCTM(AffineTransform affineTransform) {
        this.CTM = affineTransform;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(int n) {
        this.lineCap = n;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f <= Float.MIN_VALUE || f >= Float.MAX_VALUE || f == 0.0f ? 0.001f : f;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(int n) {
        this.lineJoin = n;
    }

    public float[] getDashArray() {
        return this.dashArray;
    }

    public void setDashArray(float[] fArray) {
        this.dashArray = fArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setDashPhase(float f) {
        this.dashPhase = f;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float f) {
        this.miterLimit = f;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeAlpha(float f) {
        this.strokeAlpha = f;
    }

    public float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public void setFillAlpha(float f) {
        this.fillAlpha = f;
    }

    public float getFillAlpha() {
        return this.fillAlpha;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public PColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PColorSpace pColorSpace) {
        this.fillColorSpace = pColorSpace;
    }

    public PColorSpace getStrokeColorSpace() {
        return this.strokeColorSpace;
    }

    public void setStrokeColorSpace(PColorSpace pColorSpace) {
        this.strokeColorSpace = pColorSpace;
    }

    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public int getOverprintMode() {
        return this.overprintMode;
    }

    public boolean isOverprintStroking() {
        return this.overprintStroking;
    }

    public boolean isOverprintOther() {
        return this.overprintOther;
    }

    public void setOverprintMode(int n) {
        this.overprintMode = n;
    }

    public void setOverprintStroking(boolean bl) {
        this.overprintStroking = bl;
    }

    public void setOverprintOther(boolean bl) {
        this.overprintOther = bl;
    }
}

