/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.ArrayList;
import java.util.List;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;

public class FreeSpaceList {
    private static final int FIRST_FREE_PAGE = 2;
    private static final int MAX_PAGE_COUNT = 0x3FFFFFFF;
    private List<PageRange> freeSpaceList = new ArrayList<PageRange>();

    public FreeSpaceList() {
        this.clear();
    }

    public synchronized void clear() {
        this.freeSpaceList.clear();
        this.freeSpaceList.add(new PageRange(2, 0x3FFFFFFF));
    }

    public synchronized int allocatePages(long l) {
        int n = (int)(l / 4096L) + 1;
        for (PageRange pageRange : this.freeSpaceList) {
            if (pageRange.length < n) continue;
            return pageRange.start;
        }
        throw DataUtils.newIllegalStateException("Could not find a free page to allocate", new Object[0]);
    }

    public synchronized void markUsed(Chunk chunk) {
        int n = (int)(chunk.start / 4096L);
        int n2 = (int)((chunk.start + (long)chunk.length) / 4096L) + 2 - n;
        PageRange pageRange = null;
        int n3 = 0;
        for (PageRange pageRange2 : this.freeSpaceList) {
            if (n >= pageRange2.start && n < pageRange2.start + pageRange2.length) {
                pageRange = pageRange2;
                break;
            }
            ++n3;
        }
        if (pageRange == null) {
            throw DataUtils.newIllegalStateException("Cannot find spot to mark chunk as used in free list: {0}", chunk);
        }
        if (n + n2 > pageRange.start + pageRange.length) {
            throw DataUtils.newIllegalStateException("Chunk runs over edge of free space: {0}", chunk);
        }
        if (pageRange.start == n) {
            pageRange.start += n2;
            pageRange.length -= n2;
            if (pageRange.length == 0) {
                this.freeSpaceList.remove(n3);
            }
        } else if (pageRange.start + pageRange.length == n + n2) {
            pageRange.length -= n2;
            if (pageRange.length == 0) {
                this.freeSpaceList.remove(n3);
            }
        } else {
            int n4 = n - pageRange.start;
            int n5 = n + n2;
            int n6 = pageRange.start + pageRange.length - n - n2;
            pageRange.length = n4;
            PageRange pageRange3 = new PageRange(n5, n6);
            this.freeSpaceList.add(n3 + 1, pageRange3);
        }
    }

    public synchronized void markFree(Chunk chunk) {
        Object object;
        int n = (int)(chunk.start / 4096L);
        int n2 = chunk.length / 4096 + 1;
        PageRange pageRange = null;
        int n3 = 0;
        for (PageRange pageRange2 : this.freeSpaceList) {
            if (pageRange2.start > n) {
                pageRange = pageRange2;
                break;
            }
            ++n3;
        }
        if (pageRange == null) {
            throw DataUtils.newIllegalStateException("Cannot find spot to mark chunk as unused in free list: {0}", chunk);
        }
        if (n + n2 + 1 == pageRange.start) {
            pageRange.start = n;
            pageRange.length += n2;
            if (n3 > 0) {
                object = this.freeSpaceList.get(n3 - 1);
                if (((PageRange)object).start + ((PageRange)object).length + 1 == pageRange.start) {
                    ((PageRange)object).length += pageRange.length;
                    this.freeSpaceList.remove(n3);
                }
            }
            return;
        }
        if (n3 > 0) {
            object = this.freeSpaceList.get(n3 - 1);
            if (((PageRange)object).start + ((PageRange)object).length + 1 == n) {
                ((PageRange)object).length += n2;
                if (((PageRange)object).start + ((PageRange)object).length + 1 == pageRange.start) {
                    ((PageRange)object).length += pageRange.length;
                    this.freeSpaceList.remove(n3);
                }
                return;
            }
        }
        object = new PageRange(n, n2);
        this.freeSpaceList.add(n3, (PageRange)object);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (PageRange pageRange : this.freeSpaceList) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(pageRange.start + "-" + (pageRange.start + pageRange.length - 1));
        }
        return stringBuilder.toString();
    }

    private static final class PageRange {
        public int start;
        public int length;

        public PageRange(int n, int n2) {
            this.start = n;
            this.length = n2;
        }

        public String toString() {
            return "start:" + this.start + " length:" + this.length;
        }
    }
}

