/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http.proxy;

import flex.messaging.FlexContext;
import flex.messaging.log.Log;
import flex.messaging.services.http.proxy.ProxyConstants;
import flex.messaging.services.http.proxy.ProxyContext;
import flex.messaging.services.http.proxy.ProxyException;
import flex.messaging.services.http.proxy.ProxyFilter;
import flex.messaging.services.http.proxy.ProxyUtil;
import flex.messaging.services.http.proxy.Target;
import flex.messaging.util.Base64;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

public class SecurityFilter
extends ProxyFilter {
    private static final int EMPTY_ERROR = 10708;
    private static final int ONLY_HTTP_HTTPS = 10712;
    private static final int NO_HTTPS_VIA_HTTP = 10713;
    private static final int NO_BASIC_NOT_HTTP = 10714;
    private static final int NO_BASIC_FOR_SOAP = 10715;
    private static final int DOMAIN_ERROR = 10716;
    private static final int LOGIN_REQUIRED = 10717;
    private static final int UNAUTHORIZED_ERROR = 10718;

    public void invoke(ProxyContext context) {
        this.checkURL(context);
        this.setCredentials(context);
        if (this.next != null) {
            this.next.invoke(context);
        }
        this.sendSecurityInfo(context);
    }

    private void checkURL(ProxyContext context) {
        Target target = context.getTarget();
        if (!context.getTarget().getUrl().getProtocol().equalsIgnoreCase("http") && !target.isHTTPS()) {
            Log.getLogger((String)"Service.HTTP").warn("PROXY SECURITY : Invalid URL - only HTTP or HTTPS URLs allowed");
            throw new ProxyException(10712);
        }
        if (target.isHTTPS() && !context.isClientHttps()) {
            Log.getLogger((String)"Service.HTTP").warn("PROXY SECURITY : Invalid URL - can't access HTTPS URLs when accessing proxy via HTTP.");
            throw new ProxyException(10713);
        }
    }

    private void setCredentials(ProxyContext context) {
        Enumeration headers;
        String user = null;
        String password = null;
        user = context.getTarget().getRemoteUsername();
        password = context.getTarget().getRemotePassword();
        String fromRequest = null;
        HttpServletRequest clientRequest = FlexContext.getHttpRequest();
        if (clientRequest != null) {
            fromRequest = clientRequest.getHeader(ProxyConstants.HEADER_CREDENTIALS);
        }
        if (fromRequest == null) {
            fromRequest = context.getCredentialsHeader();
        }
        if (fromRequest != null) {
            Base64.Decoder decoder = new Base64.Decoder();
            decoder.decode(fromRequest);
            String decoded = new String(decoder.drain());
            int colonIdx = decoded.indexOf(":");
            if (colonIdx != -1) {
                user = decoded.substring(0, colonIdx);
            }
            password = decoded.substring(colonIdx + 1);
        }
        if (clientRequest != null && (headers = clientRequest.getHeaders("Authorization")) != null) {
            while (headers.hasMoreElements()) {
                String value = (String)headers.nextElement();
                if (!value.startsWith("Basic")) continue;
                if (!context.isLocalDomainAndPort()) {
                    if (!Log.isInfo()) continue;
                    Log.getLogger((String)"Service.HTTP").debug("Not sending on Authentication header. Proxy domain:port of " + clientRequest.getServerName() + ":" + clientRequest.getServerPort() + " does not match target domain:port of " + context.getTarget().getUrl().getHost() + ":" + context.getTarget().getUrl().getPort());
                    continue;
                }
                Base64.Decoder decoder = new Base64.Decoder();
                String encoded = value.substring(6);
                decoder.decode(encoded);
                String decoded = new String(decoder.drain());
                int colonIdx = decoded.indexOf(":");
                user = decoded.substring(0, colonIdx);
                password = decoded.substring(colonIdx + 1);
            }
        }
        if (user != null) {
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(user, password);
            context.getHttpClient().getState().setCredentials(ProxyUtil.getDefaultAuthScope(), (Credentials)cred);
            context.setAuthorization(true);
            if (Log.isInfo()) {
                Log.getLogger((String)"Service.HTTP").info("-- Authentication header being sent for " + user);
            }
        }
    }

    private void sendSecurityInfo(ProxyContext context) {
        Target target = context.getTarget();
        String targetHost = target.getUrl().getHost();
        int statusCode = 200;
        boolean customAuth = target.useCustomAuthentication();
        StatusLine statusLine = context.getHttpMethod().getStatusLine();
        if (statusLine != null) {
            statusCode = statusLine.getStatusCode();
        }
        context.setStatusCode(statusCode);
        if (statusCode == 401 || statusCode == 403) {
            if (!customAuth) {
                if (!context.isHttpRequest()) {
                    throw new ProxyException(10714);
                }
                if (context.isSoapRequest()) {
                    throw new ProxyException(10715);
                }
                if (!context.isLocalDomainAndPort()) {
                    HttpServletRequest clientRequest = FlexContext.getHttpRequest();
                    String errorMessage = "The Flex proxy and the specified endpoint do not have the same domain, and so basic authentication cannot be used.  Please specify use-custom-authentication or run-as for services not located on the same domain as the Flex proxy. . The proxy domain:port is " + clientRequest.getServerName() + ":" + clientRequest.getServerPort() + " and the target domain:port is " + targetHost + ":" + target.getUrl().getPort();
                    Log.getLogger((String)"Service.HTTP").error(errorMessage);
                    throw new ProxyException(10716);
                }
                HttpServletResponse clientResponse = FlexContext.getHttpResponse();
                clientResponse.setStatus(statusCode);
            } else {
                String message = null;
                if (statusLine != null) {
                    message = statusLine.toString();
                }
                if (statusCode == 401) {
                    ProxyException se = new ProxyException();
                    se.setCode("Client.Authentication");
                    if (message == null) {
                        se.setMessage(10717);
                    } else {
                        se.setMessage(10708, new Object[]{message});
                    }
                    Header header = context.getHttpMethod().getResponseHeader(ProxyConstants.HEADER_AUTHENTICATE);
                    if (header != null) {
                        se.setDetails(header.getValue());
                    }
                    throw se;
                }
                ProxyException se = new ProxyException();
                se.setCode("Client.Authentication");
                if (message == null) {
                    se.setMessage(10718);
                } else {
                    se.setMessage(10708, new Object[]{message});
                }
                throw se;
            }
        }
    }
}

