/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import oracle.xml.parser.v2.PageManager;

abstract class AbstractPageManager
implements PageManager {
    static final int TABLE_DEFAULT = 100;
    int currentPage;
    int lastPage;
    long currentOffset;
    long lastOffset;
    long[] pageOffset;
    int[] pageLength;
    int tableSize;
    boolean modified;

    AbstractPageManager() {
    }

    public void init() {
        this.currentOffset = 0L;
        this.currentPage = 0;
        this.tableSize = 100;
        this.pageOffset = new long[this.tableSize];
        this.pageLength = new int[this.tableSize];
        this.lastPage = this.currentPage;
        this.lastOffset = this.currentOffset;
        this.modified = false;
    }

    public PageManager.PageId writePage(byte[] byArray, int n, int n2) {
        int n3 = this.lastPage;
        if (n2 == 0) {
            return null;
        }
        try {
            if (this.currentOffset != this.lastOffset) {
                this.seek(this.lastOffset);
                this.currentOffset = this.lastOffset;
                this.currentPage = this.lastPage;
            }
            this.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.currentPage >= this.tableSize) {
            this.appendPageTable();
        }
        this.pageOffset[this.currentPage] = this.currentOffset;
        this.pageLength[this.currentPage] = n2;
        ++this.currentPage;
        this.currentOffset += (long)n2;
        this.lastPage = this.currentPage;
        this.lastOffset = this.currentOffset;
        this.modified = true;
        return new PageId(n3);
    }

    public PageManager.PageId writePage(PageManager.PageId pageId, byte[] byArray, int n, int n2) {
        PageId pageId2 = (PageId)pageId;
        int n3 = pageId2.getId();
        long l = this.pageOffset(pageId2);
        int n4 = this.pageLength(pageId2);
        try {
            if (n4 != n2) {
                long l2;
                long l3 = l + (long)n4;
                long l4 = this.lastOffset;
                int n5 = 4096;
                byte[] byArray2 = new byte[n5];
                long l5 = n2 - n4;
                if (l5 > 0L) {
                    l2 = l4;
                    while (l2 > l3) {
                        if (l2 - (long)n5 < l3) {
                            n5 = (int)(l2 - l3);
                            l2 = l3;
                        } else {
                            l2 -= (long)n5;
                        }
                        this.seek(l2);
                        this.read(byArray2, 0, n5);
                        this.seek(l2 + l5);
                        this.write(byArray2, 0, n5);
                    }
                } else if (l5 < 0L) {
                    for (l2 = l3; l2 < l4; l2 += (long)n5) {
                        if (l2 + (long)n5 > l4) {
                            n5 = (int)(l4 - l2);
                        }
                        this.seek(l2);
                        this.read(byArray2, 0, n5);
                        this.seek(l2 + l5);
                        this.write(byArray2, 0, n5);
                    }
                }
                int n6 = n3 + 1;
                while (n6 < this.lastPage) {
                    int n7 = n6++;
                    this.pageOffset[n7] = this.pageOffset[n7] + l5;
                }
                this.lastOffset += l5;
            }
            if (this.currentOffset != l) {
                this.currentOffset = l;
                this.currentPage = n3;
            }
            this.seek(l);
            this.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        this.pageLength[this.currentPage] = n2;
        ++this.currentPage;
        this.currentOffset += (long)n2;
        this.modified = true;
        return new PageId(n3);
    }

    public int readPage(PageManager.PageId pageId, byte[] byArray, int n) {
        int n2 = 0;
        try {
            PageId pageId2 = (PageId)pageId;
            int n3 = pageId2.getId();
            long l = this.pageOffset(pageId2);
            if (this.currentOffset != l) {
                this.currentOffset = l;
                this.currentPage = n3;
                this.seek(this.currentOffset);
            }
            n2 = this.read(byArray, n, this.pageLength(pageId2));
            this.currentOffset += (long)n2;
            ++this.currentPage;
        }
        catch (IOException iOException) {
            n2 = 0;
        }
        return n2;
    }

    public PageManager.PageId nextPageId() {
        try {
            int n = this.currentPage;
            return new PageId(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int pageLength(PageManager.PageId pageId) {
        PageId pageId2 = (PageId)pageId;
        int n = pageId2.getId();
        try {
            return this.pageLength[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public byte pageIdToBytes(PageManager.PageId pageId, byte[] byArray, int n) {
        int n2 = ((PageId)pageId).getId();
        if (n + 4 > byArray.length) {
            return -1;
        }
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 0 & 0xFF);
        return 4;
    }

    public PageManager.PageId pageIdFromBytes(byte[] byArray, int n) {
        if (n + 4 > byArray.length) {
            return null;
        }
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n++] & 0xFF;
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        return new PageId(n6);
    }

    private long pageOffset(PageManager.PageId pageId) {
        PageId pageId2 = (PageId)pageId;
        int n = pageId2.getId();
        try {
            return this.pageOffset[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
    }

    public abstract void seek(long var1) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close();

    private void appendPageTable() {
        long[] lArray = this.pageOffset;
        this.pageOffset = new long[this.tableSize + 100];
        System.arraycopy(lArray, 0, this.pageOffset, 0, this.tableSize);
        int[] nArray = this.pageLength;
        this.pageLength = new int[this.tableSize + 100];
        System.arraycopy(nArray, 0, this.pageLength, 0, this.tableSize);
        this.tableSize += 100;
    }

    class PageId
    implements PageManager.PageId {
        int id;

        PageId(int n) {
            this.id = n;
        }

        int getId() {
            return this.id;
        }

        public String toString() {
            return "ID" + this.id;
        }

        public int compareTo(Object object) {
            PageId pageId = (PageId)object;
            return this.id - pageId.id;
        }

        public boolean equals(Object object) {
            if (object instanceof PageId) {
                return ((PageId)object).id == this.id;
            }
            return false;
        }
    }
}

