/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.msgpack.jruby.ExtensionValue;

public class Decoder
implements Iterator<IRubyObject> {
    private final Ruby runtime;
    private final Encoding binaryEncoding;
    private final Encoding utf8Encoding;
    private final RubyClass unpackErrorClass;
    private final RubyClass underflowErrorClass;
    private ByteBuffer buffer;

    public Decoder(Ruby ruby) {
        this(ruby, new byte[0], 0, 0);
    }

    public Decoder(Ruby ruby, byte[] byArray) {
        this(ruby, byArray, 0, byArray.length);
    }

    public Decoder(Ruby ruby, byte[] byArray, int n, int n2) {
        this.runtime = ruby;
        this.binaryEncoding = ruby.getEncodingService().getAscii8bitEncoding();
        this.utf8Encoding = UTF8Encoding.INSTANCE;
        this.unpackErrorClass = ruby.getModule("MessagePack").getClass("UnpackError");
        this.underflowErrorClass = ruby.getModule("MessagePack").getClass("UnderflowError");
        this.feed(byArray, n, n2);
    }

    public void feed(byte[] byArray) {
        this.feed(byArray, 0, byArray.length);
    }

    public void feed(byte[] byArray, int n, int n2) {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.wrap(byArray, n, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.buffer.remaining() + n2);
            byteBuffer.put(this.buffer);
            byteBuffer.put(byArray, n, n2);
            byteBuffer.flip();
            this.buffer = byteBuffer;
        }
    }

    public void reset() {
        this.buffer.rewind();
    }

    public int offset() {
        return this.buffer.position();
    }

    private IRubyObject consumeUnsignedLong() {
        long l = this.buffer.getLong();
        if (l < 0L) {
            return RubyBignum.newBignum((Ruby)this.runtime, (BigInteger)BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63));
        }
        return this.runtime.newFixnum(l);
    }

    private IRubyObject consumeString(int n, Encoding encoding) {
        byte[] byArray = this.readBytes(n);
        ByteList byteList = new ByteList(byArray, encoding);
        return this.runtime.newString(byteList);
    }

    private IRubyObject consumeArray(int n) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            iRubyObjectArray[i] = this.next();
        }
        return this.runtime.newArray(iRubyObjectArray);
    }

    private IRubyObject consumeHash(int n) {
        RubyHash rubyHash = RubyHash.newHash((Ruby)this.runtime);
        for (int i = 0; i < n; ++i) {
            rubyHash.fastASet(this.next(), this.next());
        }
        return rubyHash;
    }

    private IRubyObject consumeExtension(int n) {
        byte by = this.buffer.get();
        byte[] byArray = this.readBytes(n);
        return ExtensionValue.newExtensionValue(this.runtime, by, byArray);
    }

    private byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        return byArray;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.buffer.remaining() > 0;
    }

    @Override
    public IRubyObject next() {
        int n = this.buffer.position();
        try {
            byte by = this.buffer.get();
            switch (by >> 4 & 0xF) {
                case 8: {
                    return this.consumeHash(by & 0xF);
                }
                case 9: {
                    return this.consumeArray(by & 0xF);
                }
                case 10: 
                case 11: {
                    return this.consumeString(by & 0x1F, this.utf8Encoding);
                }
                case 12: {
                    switch (by) {
                        case -64: {
                            return this.runtime.getNil();
                        }
                        case -62: {
                            return this.runtime.getFalse();
                        }
                        case -61: {
                            return this.runtime.getTrue();
                        }
                        case -60: {
                            return this.consumeString(this.buffer.get() & 0xFF, this.binaryEncoding);
                        }
                        case -59: {
                            return this.consumeString(this.buffer.getShort() & 0xFFFF, this.binaryEncoding);
                        }
                        case -58: {
                            return this.consumeString(this.buffer.getInt(), this.binaryEncoding);
                        }
                        case -57: {
                            return this.consumeExtension(this.buffer.get());
                        }
                        case -56: {
                            return this.consumeExtension(this.buffer.getShort());
                        }
                        case -55: {
                            return this.consumeExtension(this.buffer.getInt());
                        }
                        case -54: {
                            return this.runtime.newFloat((double)this.buffer.getFloat());
                        }
                        case -53: {
                            return this.runtime.newFloat(this.buffer.getDouble());
                        }
                        case -52: {
                            return this.runtime.newFixnum((long)this.buffer.get() & 0xFFL);
                        }
                        case -51: {
                            return this.runtime.newFixnum((long)this.buffer.getShort() & 0xFFFFL);
                        }
                        case -50: {
                            return this.runtime.newFixnum((long)this.buffer.getInt() & 0xFFFFFFFFL);
                        }
                        case -49: {
                            return this.consumeUnsignedLong();
                        }
                    }
                    break;
                }
                case 13: {
                    switch (by) {
                        case -48: {
                            return this.runtime.newFixnum((int)this.buffer.get());
                        }
                        case -47: {
                            return this.runtime.newFixnum((int)this.buffer.getShort());
                        }
                        case -46: {
                            return this.runtime.newFixnum(this.buffer.getInt());
                        }
                        case -45: {
                            return this.runtime.newFixnum(this.buffer.getLong());
                        }
                        case -44: {
                            return this.consumeExtension(1);
                        }
                        case -43: {
                            return this.consumeExtension(2);
                        }
                        case -42: {
                            return this.consumeExtension(4);
                        }
                        case -41: {
                            return this.consumeExtension(8);
                        }
                        case -40: {
                            return this.consumeExtension(16);
                        }
                        case -39: {
                            return this.consumeString(this.buffer.get() & 0xFF, this.utf8Encoding);
                        }
                        case -38: {
                            return this.consumeString(this.buffer.getShort() & 0xFFFF, this.utf8Encoding);
                        }
                        case -37: {
                            return this.consumeString(this.buffer.getInt(), this.utf8Encoding);
                        }
                        case -36: {
                            return this.consumeArray(this.buffer.getShort() & 0xFFFF);
                        }
                        case -35: {
                            return this.consumeArray(this.buffer.getInt());
                        }
                        case -34: {
                            return this.consumeHash(this.buffer.getShort() & 0xFFFF);
                        }
                        case -33: {
                            return this.consumeHash(this.buffer.getInt());
                        }
                    }
                    break;
                }
                case 14: 
                case 15: {
                    return this.runtime.newFixnum((0x1F & by) - 32);
                }
                default: {
                    return this.runtime.newFixnum((int)by);
                }
            }
            this.buffer.position(n);
            throw this.runtime.newRaiseException(this.unpackErrorClass, "Illegal byte sequence");
        }
        catch (RaiseException raiseException) {
            this.buffer.position(n);
            throw raiseException;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            this.buffer.position(n);
            throw this.runtime.newRaiseException(this.underflowErrorClass, "Not enough bytes available");
        }
    }
}

