/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.SnapshotSerializer;
import liquibase.servicelocator.PrioritizedService;
import liquibase.servicelocator.ServiceLocator;

public class SnapshotSerializerFactory {
    private static SnapshotSerializerFactory instance;
    private Map<String, List<SnapshotSerializer>> serializers = new HashMap<String, List<SnapshotSerializer>>();

    public static void reset() {
        instance = new SnapshotSerializerFactory();
    }

    public static SnapshotSerializerFactory getInstance() {
        if (instance == null) {
            instance = new SnapshotSerializerFactory();
        }
        return instance;
    }

    private SnapshotSerializerFactory() {
        try {
            Class<SnapshotSerializer>[] classes;
            for (Class<SnapshotSerializer> clazz : classes = ServiceLocator.getInstance().findClasses(SnapshotSerializer.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public Map<String, List<SnapshotSerializer>> getSerializers() {
        return this.serializers;
    }

    public List<SnapshotSerializer> getSerializers(String fileNameOrExtension) {
        List<SnapshotSerializer> snapshotSerializers = this.serializers.get(fileNameOrExtension = fileNameOrExtension.replaceAll(".*\\.", ""));
        if (snapshotSerializers == null) {
            return Collections.emptyList();
        }
        return snapshotSerializers;
    }

    public SnapshotSerializer getSerializer(String fileNameOrExtension) {
        List<SnapshotSerializer> snapshotSerializers = this.getSerializers(fileNameOrExtension);
        if (snapshotSerializers.isEmpty()) {
            throw new RuntimeException("No serializers associated with the filename or extension '" + fileNameOrExtension + "'");
        }
        return snapshotSerializers.get(0);
    }

    public void register(SnapshotSerializer snapshotSerializer) {
        for (String extension : snapshotSerializer.getValidFileExtensions()) {
            List<SnapshotSerializer> snapshotSerializers = this.serializers.get(extension);
            if (snapshotSerializers == null) {
                snapshotSerializers = new ArrayList<SnapshotSerializer>();
                this.serializers.put(extension, snapshotSerializers);
            }
            snapshotSerializers.add(snapshotSerializer);
            Collections.sort(snapshotSerializers, PrioritizedService.COMPARATOR);
        }
    }

    public void unregister(SnapshotSerializer snapshotSerializer) {
        Iterator<Map.Entry<String, List<SnapshotSerializer>>> entryIterator = this.serializers.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, List<SnapshotSerializer>> entry = entryIterator.next();
            List<SnapshotSerializer> snapshotSerializers = entry.getValue();
            Iterator<SnapshotSerializer> iterator = snapshotSerializers.iterator();
            while (iterator.hasNext()) {
                SnapshotSerializer value = iterator.next();
                if (!value.equals(snapshotSerializer)) continue;
                iterator.remove();
            }
            if (!snapshotSerializers.isEmpty()) continue;
            entryIterator.remove();
        }
    }
}

