/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.FString;
import gnu.lists.IntSequence;
import gnu.lists.Range;
import gnu.lists.SubCharSeq;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Strings {
    public static int characterAt(CharSequence cseq, int index) {
        return Strings.characterAt(cseq, 0, cseq.length(), index);
    }

    public static int characterAt(CharSequence cseq, int start, int end, int index) {
        char ch0;
        if (index < start || index >= end) {
            throw new IndexOutOfBoundsException();
        }
        char ch1 = cseq.charAt(index);
        if (ch1 >= '\ud800' && ch1 <= '\udbff') {
            char ch2;
            if (index + 1 < end && (ch2 = cseq.charAt(index + 1)) >= '\udc00' && ch2 <= '\udfff') {
                return (ch1 - 55296 << 10) + (ch2 - 56320) + 65536;
            }
        } else if (ch1 >= '\udc00' && ch1 <= '\udfff' && index > start && (ch0 = cseq.charAt(index - 1)) >= '\ud800' && ch0 <= '\udbff') {
            return 0x1FFFFF;
        }
        return ch1;
    }

    public static int sizeInCodePoints(CharSequence str) {
        int len = str.length();
        int nsurr = 0;
        int i = 0;
        while (i < len) {
            char next;
            char ch;
            if ((ch = str.charAt(i++)) < '\ud800' || ch > '\udbff' || i >= len || (next = str.charAt(i)) < '\udc00' || next > '\udfff') continue;
            ++i;
            ++nsurr;
        }
        return len - nsurr;
    }

    public static void makeUpperCase(CharSeq str) {
        int i = str.length();
        while (--i >= 0) {
            str.setCharAt(i, Character.toUpperCase(str.charAt(i)));
        }
    }

    public static void makeLowerCase(CharSeq str) {
        int i = str.length();
        while (--i >= 0) {
            str.setCharAt(i, Character.toLowerCase(str.charAt(i)));
        }
    }

    public static void makeCapitalize(CharSeq str) {
        char prev = ' ';
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            ch = !Character.isLetterOrDigit(prev) ? Character.toTitleCase(ch) : Character.toLowerCase(ch);
            str.setCharAt(i, ch);
            prev = ch;
        }
    }

    public static void printQuoted(CharSequence str, Appendable ps, int escapes) {
        int len = str.length();
        try {
            ps.append('\"');
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '\\' || ch == '\"') {
                    ps.append('\\');
                } else if (escapes > 0) {
                    if (ch == '\n') {
                        ps.append("\\n");
                        continue;
                    }
                    if (ch == '\r') {
                        ps.append("\\r");
                        continue;
                    }
                    if (ch == '\t') {
                        ps.append("\\t");
                        continue;
                    }
                    if (ch == '\u0007') {
                        ps.append("\\a");
                        continue;
                    }
                    if (ch == '\b') {
                        ps.append("\\b");
                        continue;
                    }
                    if (ch == '\u000b') {
                        ps.append("\\v");
                        continue;
                    }
                    if (ch == '\f') {
                        ps.append("\\f");
                        continue;
                    }
                    if (escapes > 1 && (ch < ' ' || ch >= '\u007f')) {
                        ps.append("\\x");
                        ps.append(Integer.toHexString(ch));
                        ps.append(';');
                        continue;
                    }
                }
                ps.append(ch);
            }
            ps.append('\"');
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void copyInto(CharSequence src, int start, int end, CharSeq dst, int at) {
        int dstLen = dst.length();
        int srcLen = src.length();
        if (at < 0 || at > dstLen || start < 0 || end > srcLen || end < start || dstLen - at < end - start) {
            throw new StringIndexOutOfBoundsException();
        }
        if (at < start) {
            int i = at;
            for (int j = start; j < end; ++j) {
                dst.setCharAt(i, src.charAt(j));
                ++i;
            }
        } else {
            int i = at + end - start;
            int j = end;
            while (--j >= start) {
                dst.setCharAt(--i, src.charAt(j));
            }
        }
    }

    public static CharSequence indirectIndexed(CharSequence base2, IntSequence indexes) {
        Range.IntRange range;
        if (base2 instanceof FString) {
            return (FString)((FString)base2).select(indexes);
        }
        if (indexes instanceof Range.IntRange && (range = (Range.IntRange)indexes).getStepInt() == 1) {
            int start = range.getStartInt();
            int bsize = base2.length();
            if (start < 0 || start > bsize) {
                throw new IndexOutOfBoundsException();
            }
            if (range.isUnbounded()) {
                return SubCharSeq.valueOf(base2, start, bsize);
            }
            int size = range.size();
            if (start + size < 0 || start + size > bsize) {
                throw new IndexOutOfBoundsException();
            }
            return SubCharSeq.valueOf(base2, start, start + size);
        }
        int len = indexes.size();
        StringBuilder sbuf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sbuf.append(base2.charAt(indexes.intAt(i)));
        }
        return sbuf.toString();
    }

    public static String toUtf8(byte[] bytes, int start, int length) {
        return new String(bytes, start, length, StandardCharsets.UTF_8);
    }
}

